/* pggstrvector.h - PggStrVector data structure and function definitions
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef PGG_INCLUDE_STRVECTOR_H_19990721190300
#define PGG_INCLUDE_STRVECTOR_H_19990721190300


typedef struct
{
    char **     vector;
    int         capacity;
    int         used;
} PggStrVector;


extern int	pgg_strvector_init(PggStrVector *strvector);
extern int	pgg_strvector_cloneto(PggStrVector *strvector, PggStrVector *to);
extern void	pgg_strvector_clear(PggStrVector *strvector);
extern void	pgg_strvector_release(PggStrVector *strvector);
extern int	pgg_strvector_append(PggStrVector *strvector, const char *str);
extern int	pgg_strvector_insert(PggStrVector *strvector, int index, const char *str);
extern void	pgg_strvector_remove(PggStrVector *strvector, int index);


#endif


