/* pgg_pubkey_set_config.c - Sets the PggConfig object of a PggPubkey
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <includes.h>
#include <pgg.h>
#include <pggdebug.h>
#include <pggpubkey.h>


#define pubkey		((PggPubkeyPtr)(_pubkey))


void pgg_pubkey_set_config(PggPubkey _pubkey, PggConfig config, PggErrenv errenv)
{
    PggErrenv		local_errenv;
    
    PGG_STD_ASSERT(PggPubkey, pubkey);
    
    pgg_errenv_reset(local_errenv);
    
    if (config)
        pgg_config_addref(config, local_errenv);
    
    if (!pgg_errenv_is_set(local_errenv)) {
        pgg_errenv_copy(errenv, local_errenv);
    }
    else {
        if (pubkey->config)
            pgg_config_release(pubkey->config, NULL);
        pubkey->config = config;
    }
}


