/* file.c - description
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <includes.h>
#include <pgg.h>
#include <pggdebug.h>
#include <pggcolons.h>


#define colons          ((PggColonsPtr)(_colons))


PggColons pgg_colons_clone(PggColons _colons, PggErrenv errenv)
{
    PggErrenv                   local_errenv;
    PggColonsPtr                new_colons;

    PGG_STD_ASSERT_ARG(PggColons, colons, NULL);

    pgg_errenv_reset(local_errenv);

    if (!( new_colons = _malloc(PggColons) ))
        PGG_RETURN_ERR_ARG(RESOURCE, MEMORY, NULL);

    memcpy(new_colons, colons, _size(PggColons));

    new_colons->magic      = PggColonsMAGIC;
    new_colons->refcounter = 1;

    new_colons->buffer = pgg_buffer_clone(colons->buffer, local_errenv);

    if (pgg_errenv_is_set(local_errenv)) {
        free(new_colons);
        pgg_errenv_copy(errenv, local_errenv);
        pgg_errenv_copy(errenv, local_errenv);
        return NULL;
    }

    return _hd(PggColons, new_colons);
}


