/* pgg_algo_set_compress.c - Sets the compress identifier of a PggAlgo object
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <includes.h>
#include <pgg.h>
#include <pggalgo.h>
#include <pggdebug.h>


#define algo		((PggAlgoPtr)(_algo))


void pgg_algo_set_compress(PggAlgo _algo, Pgg_Compress compress, PggErrenv errenv)
{
    PGG_STD_ASSERT(PggAlgo, algo);
    PGG_ASSERT(compress >= PGG_COMPRESS_USEPREFS, ARGUMENT, VALUE);
    PGG_ASSERT(compress <= PGG_COMPRESS_RFCZLIB, ARGUMENT, VALUE);
    algo->compress = compress;
}


