//---------------------------------------------------------------------------
// GPGee - GNU Privacy Guard Explorer Extension
// GPGeeUtility.cpp - Miscelaneous utility functions header file
// Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of GPGee.
//
// GPGee is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// GPGee is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------
#ifndef GPGeeUtilityH
#define GPGeeUtilityH
//---------------------------------------------------------------------------
#include "gpgme/gpgme.h"
//---------------------------------------------------------------------------
typedef enum { GPG_UNKNOWN, GPG_MESSAGE, GPG_SIGNATURE, GPG_CLEARSIGNED } gpg_file_type;
//---------------------------------------------------------------------------
AnsiString __fastcall MinimizeName(AnsiString FileName, TEdit *Edit);
AnsiString __fastcall MinimizeName(AnsiString FileName, TFont *Font, int Width);
gpg_file_type __fastcall IdentifyFile(AnsiString FileName);
TDateTime __fastcall GPGToDateTime(unsigned long GPGDate, bool LocalTime = true);
AnsiString __fastcall KeyTypeToString(gpgme_pk_cipher_t KeyType);
AnsiString __fastcall TrustToString(gpgme_validity_t Trust);
AnsiString __fastcall DigestToString(gpgme_md_t Digest);
AnsiString __fastcall GetMessage(int ident);
AnsiString FormMessage(int ident, ...);
gpgme_keycache_t __fastcall GetKeyCache(bool GetSecretKeys, bool Cleanup = false);
AnsiString __fastcall GetLastErrorMessage(void);
void __fastcall CheckVersion(void);
void __fastcall CleanupPassphraseCache(TStringList *Cache);
void __fastcall Upgrade(void);
AnsiString __fastcall GetTempFileName(AnsiString Prefix);
bool __fastcall AppendFile(AnsiString AppendFilename, AnsiString TargetFilename);
void __fastcall DirectoryList(AnsiString Directory, TStringList *DirList);
//---------------------------------------------------------------------------
#define CleanupKeyCaches() GetKeyCache(false,true)
#define NOEXCEPT(a) try { a; } catch (...) { }
//---------------------------------------------------------------------------
// Message id numbers for the language modules
//---------------------------------------------------------------------------
#define MSG_MENU_VERIFYDECRYPT            100
#define MSG_MENU_CONFIGURE                101
#define MSG_MENU_SIGNENCRYPT              102
#define MSG_MENU_SIGN                     103
#define MSG_MENU_ENCRYPT                  104
#define MSG_MENU_SENCRYPT                 105

#define MSG_GPGME_VALIDITY_UNKNOWN        200
#define MSG_GPGME_VALIDITY_UNDEFINED      201
#define MSG_GPGME_VALIDITY_NEVER          202
#define MSG_GPGME_VALIDITY_MARGINAL       203
#define MSG_GPGME_VALIDITY_FULL           204
#define MSG_GPGME_VALIDITY_ULTIMATE       205
#define MSG_GPGME_VALIDITY_ERROR          206

#define MSG_GPGME_TRUST_UNKNOWN           300
#define MSG_GPGME_TRUST_UNDEFINED         301
#define MSG_GPGME_TRUST_NEVER             302
#define MSG_GPGME_TRUST_MARGINAL          303
#define MSG_GPGME_TRUST_FUL               304
#define MSG_GPGME_TRUST_ULTIMATE          305
#define MSG_GPGME_TRUST_ERROR             306

#define MSG_GPGME_MD_UNKNOWN              310
#define MSG_GPGME_MD_MD5                  311
#define MSG_GPGME_MD_SHA1                 312
#define MSG_GPGME_MD_RMD160	          313
#define MSG_GPGME_MD_TIGER                316
#define MSG_GPGME_MD_SHA256               318
#define MSG_GPGME_MD_SHA384               319
#define MSG_GPGME_MD_SHA512               320

#define MSG_GPGEE_TYPE_SIGNATURE          330
#define MSG_GPGEE_TYPE_MESSAGE            331
#define MSG_GPGEE_TYPE_UNKNOWN            332

#define MSG_CAPTION_GPGEE_BUTTON_OK       400

#define MSG_ERROR_GPGME_LIB_INIT          1000
#define MSG_ERROR_GPGME_KEYCACHE_INIT_PUB 1001
#define MSG_ERROR_GPGME_KEYCACHE_INIT_SEC 1002
#define MSG_ERROR_GPGME_KEYCACHE_LOAD_PUB 1003
#define MSG_ERROR_GPGME_KEYCACHE_LOAD_SEC 1004

#define MSG_ERROR_GPGEE_FIND_SECRETKEY    1100
#define MSG_ERROR_GPGEE_SET_SIGNINGKEY    1101
#define MSG_ERROR_GPGEE_ADD_RECIPIENT     1102
#define MSG_ERROR_GPGEE_FAILED_OPERATION  1103
#define MSG_ERROR_GPGEE_KEYGROUPCREATE    1104
#define MSG_ERROR_GPGEE_KEYGROUPOPEN      1105
#define MSG_ERROR_GPGEE_KEYGROUPLOAD      1106
#define MSG_CONFIRM_GPGEE_KEYGROUPDELETE  1107
#define MSG_QUERY_SIGAPPEND_MSG           1108
#define MSG_QUERY_SIGAPPEND_CAPTION       1109
#define MSG_ERROR_GPGEE_APPENDSIGNATURE   1110

#define MSG_ERROR_GPGEE_IDENTIFY          1200
#define MSG_ERROR_GPGEE_CANCELED          1201
#define MSG_QUERY_GPGEE_OVERWRITE_MSG     1202
#define MSG_QUERY_GPGEE_OVERWRITE_CAPTION 1203
#define MSG_ERROR_GPGEE_FILE_EXISTS       1204
#define MSG_RESULT_GPGEE_DECRYPT_SUCCESS  1205
#define MSG_RESULT_GPGEE_NO_SECRET_KEY    1206
#define MSG_RESULT_GPGEE_BAD_ARMOR        1207
#define MSG_RESULT_GPGEE_BAD_MDC          1208
#define MSG_RESULT_GPGEE_NO_VERIFY_FILE   1209
#define MSG_RESULT_GPGEE_PREFIXGOOD       1210
#define MSG_RESULT_GPGEE_PREFIXEGOOD      1211
#define MSG_RESULT_GPGEE_PREFIXRGOOD      1212
#define MSG_RESULT_GPGEE_BODYNONE         1213
#define MSG_RESULT_GPGEE_BODYNOKEY        1214
#define MSG_RESULT_GPGEE_BODYNOSIG        1215
#define MSG_RESULT_GPGEE_BODYERROR        1216
#define MSG_RESULT_GPGEE_BODYBAD          1217
#define MSG_RESULT_GPGEE_BODYSTANDARD     1218
#define MSG_RESULT_GPGEE_POSTEXPIREDOK    1219
#define MSG_RESULT_GPGEE_POSTEXPIREDBAD   1220
#define MSG_RESULT_GPGEE_POSTEXPIREDUNK   1221
#define MSG_RESULT_GPGEE_POSTREVOKED      1222
#define MSG_RESULT_GPGEE_POSTDODGYTRUST   1223
#define MSG_QUERY_GPGEE_SYMPASSPHRASE     1224

#define MSG_QUERY_GPGEE_SYMENCRYPT        1300

#define FORM_BTN_OK                       2000
#define FORM_BTN_CANCEL                   2001
#define FORM_BTN_HELP                     2002

#define FORM_SIGN_CAPTION                 2100
#define FORM_SIGN_BTN_OK                  2101
#define FORM_SIGN_BTN_CANCEL              2102
#define FORM_SIGN_BTN_HELP                2103
#define FORM_SIGN_LABEL_KEYGROUPS         2104
#define FORM_SIGN_LABEL_SIGNINGKEYS       2105
#define FORM_SIGN_LABEL_ENCRYPTOPTIONS    2106
#define FORM_SIGN_LABEL_SIGOPTIONS        2107
#define FORM_SIGN_LABEL_MISCOPTIONS       2108
#define FORM_SIGN_RADIO_NONE              2109
#define FORM_SIGN_RADIO_PUBLIC            2110
#define FORM_SIGN_RADIO_SYMMETRIC         2111
#define FORM_SIGN_RADIO_ATTACHED          2112
#define FORM_SIGN_RADIO_DETACHED          2113
#define FORM_SIGN_CHECK_CLEARSIGN         2114
#define FORM_SIGN_CHECK_ARMOUR            2115
#define FORM_SIGN_CHECK_READONLY          2116
#define FORM_SIGN_CHECK_APPEND            2117
#define FORM_SIGN_COLUMN_NAME             2118
#define FORM_SIGN_COLUMN_KEYID            2119
#define FORM_SIGN_COLUMN_SIZE             2120
#define FORM_SIGN_COLUMN_TYPE             2121
#define FORM_SIGN_COLUMN_VALIDITY         2122
#define FORM_SIGN_HINT_GROUPADD           2123
#define FORM_SIGN_HINT_GROUPMODIFY        2124
#define FORM_SIGN_HINT_GROUPDELETE        2125

#define FORM_VERIFY_CAPTION               2200
#define FORM_VERIFY_BTN_CANCEL            2201
#define FORM_VERIFY_BTN_HELP              2202
#define FORM_VERIFY_COLUMN_FILENAME       2203
#define FORM_VERIFY_COLUMN_TYPE           2204

#define FORM_PASS_CAPTION                 2300
#define FORM_PASS_CHECK_HIDE              2301
#define FORM_PASS_LABEL_SECRET            2302
#define FORM_PASS_LABEL_USER              2303
#define FORM_PASS_LABEL_ID                2304
#define FORM_PASS_LABEL_TYPE              2305
#define FORM_PASS_LABEL_SIZE              2306
#define FORM_PASS_LABEL_DATE              2307

#define FORM_CONFIG_CAPTION               2400
#define FORM_CONFIG_LABEL_GPGOPTIONS      2401
#define FORM_CONFIG_LABEL_GENERALOPTIONS  2402
#define FORM_CONFIG_LABEL_OVERWRITE       2403
#define FORM_CONFIG_CHECK_PROGRAMPATH     2404
#define FORM_CONFIG_CHECK_OPTIONSFILE     2405
#define FORM_CONFIG_CHECK_PUBKEYRING      2406
#define FORM_CONFIG_CHECK_SECKEYRING      2407
#define FORM_CONFIG_CHECK_FORCETRUST      2408
#define FORM_CONFIG_CHECK_ENCRYPTSELF     2409
#define FORM_CONFIG_CHECK_CACHE           2410
#define FORM_CONFIG_CHECK_PARENTID        2411
#define FORM_CONFIG_CHECK_RELEASE         2412
#define FORM_CONFIG_RADIO_ASK             2413
#define FORM_CONFIG_RADIO_ALWAYS          2414
#define FORM_CONFIG_RADIO_NEVER           2415

#define FORM_NOTIFY_CAPTION               2500
#define FORM_NOTIFY_LABEL_MESSAGE         2501
#define FORM_NOTIFY_LABEL_URL             2502
#define FORM_NOTIFY_LABEL_CURRENT         2503
#define FORM_NOTIFY_LABEL_NEW             2504
#define FORM_NOTIFY_CHECK_NOREPEAT        2505

#define FORM_PROGRESS_CAPTION             2600
#define FORM_PROGRESS_LABEL_CACHING       2601
//---------------------------------------------------------------------------
#endif
