//------------------------------ $Keywords ----------------------------------
// GPGee - GNU Privacy Guard Explorer Extension
// GPGeeNewVersionNotify.cpp - Inform the user of a new version
// Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of GPGee.
//
// GPGee is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// GPGee is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// VCS: $Version: 0 $ $Revision: 3 $
/*
$History: **** V 0.1 by kfitzner ****
$History: * gpgeenewversionnotify.cpp - 2005-08-31 6:51:22 PM - 3992 Bytes
$History: * gpgeenewversionnotify.dfm - 2005-08-31 6:47:00 PM - 2120 Bytes
$History: * gpgeenewversionnotify.h - 2005-08-31 6:41:14 PM - 2343 Bytes
$History: * gpgeenewversionnotify.ddp - 2005-08-31 6:50:50 PM - 51 Bytes
$History: * Initial check-in
$History: **** V 0.2 by kfitzner ****
$History: * gpgeenewversionnotify.cpp - 2005-09-05 3:18:09 AM - 4562 Bytes
$History: * gpgeenewversionnotify.dfm - 2005-08-31 6:47:00 PM - 2120 Bytes
$History: * gpgeenewversionnotify.h - 2005-08-31 6:41:14 PM - 2343 Bytes
$History: * gpgeenewversionnotify.ddp - 2005-09-04 5:27:42 PM - 51 Bytes
$History: * Add logging
$History: **** Latest ** V 0.3 by kfitzner ** 2005-10-06 8:28:33 PM ****
$History: * Add language support - now all forms' visual elements 
$History: * are stored in the string table (strings.rc)
*/
//----------------------------  $NoKeywords ---------------------------------


//---------------------------------------------------------------------------
// File Notes:
//---------------------------------------------------------------------------
// 31 Aug 2005 - Kurt Fitzner <kfitzner@excelcia.org>
//
// A very simple form - simply tell the user that there is a new version
// available and give the URL.  No muss, no fuss.
//
// ShellExecute() is used on the URL in order to cause the OS to launch
// the default browser.
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TProgramLog.h"
#include "GPGeeUtility.h"
#include "GPGeeNewVersionNotify.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TformGPGeeNewVersionNotify *formGPGeeNewVersionNotify;
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Form constructor
//
__fastcall TformGPGeeNewVersionNotify::TformGPGeeNewVersionNotify(TComponent* Owner, AnsiString MyVersion, AnsiString NewVersion) : TForm(Owner)
{
  __ENTERFUNCTION__;
  sMyVersion = MyVersion;
  sNewVersion = NewVersion;
  __RETURNFUNCTION__;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// OnShow event handler - simply set the version label captions to the
// version strings we were provided at construction time
//
void __fastcall TformGPGeeNewVersionNotify::FormShow(TObject *Sender)
{
  __ENTERFUNCTION__;

  // Read in the language strings for the form's visual text labels and change them on the form.  Borland's language
  // editor is capable of doing this, but it's much easier for translators if we can give them a single resource
  // string table to translate instead of forcing them to use Borland's translation tool.
  this->Caption              = GetMessage(FORM_NOTIFY_CAPTION);
  btnOk->Caption             = GetMessage(FORM_BTN_OK);
  lblMessage->Caption        = GetMessage(FORM_NOTIFY_LABEL_MESSAGE);
  lblURL->Caption            = GetMessage(FORM_NOTIFY_LABEL_URL);
  lblMyVersion->Caption      = GetMessage(FORM_NOTIFY_LABEL_CURRENT);
  lblCurrentVersion->Caption = GetMessage(FORM_NOTIFY_LABEL_NEW);
  chbSquelch->Caption        = GetMessage(FORM_NOTIFY_CHECK_NOREPEAT);

  lblMyVersionValue->Caption = sMyVersion;
  lblCurrentVersionValue->Caption = sNewVersion;
  __RETURNFUNCTION__;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// What to do when the user clicks on the URL
//
void __fastcall TformGPGeeNewVersionNotify::lblURLClick(TObject *Sender)
{
  __ENTERFUNCTION__;
  ShellExecute(HInstance, "open", lblURL->Caption.c_str(), NULL, NULL, 0);
  __RETURNFUNCTION__;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Ok button OnClick event handler.  What modal result we return depends
// on whether the user has checked the "Don't notify..." box
//
void __fastcall TformGPGeeNewVersionNotify::btnOkClick(TObject *Sender)
{
  __ENTERFUNCTION__;
  if (chbSquelch->Checked)
    ModalResult = mrCancel;
  else
    ModalResult = mrOk;
  __RETURNFUNCTION__;
}
//---------------------------------------------------------------------------

