/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.sig.rsa;

import gnu.crypto.sig.rsa.GnuRSAPrivateKey;
import gnu.crypto.sig.rsa.GnuRSAPublicKey;
import gnu.crypto.sig.rsa.RSAKeyPairGenerator;
import gnu.crypto.sig.rsa.RSAKeyPairRawCodec;
import gnu.crypto.sig.rsa.RSAPSSSignature;
import gnu.crypto.sig.rsa.RSAPSSSignatureRawCodec;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;

public class TestOfRSACodec
implements Testlet {
    private RSAKeyPairGenerator kpg = new RSAKeyPairGenerator();
    private KeyPair kp;

    public void test(TestHarness harness) {
        this.testKeyPairRawCodec(harness);
        this.testPrivateKeyValueOf(harness);
        this.testPublicKeyValueOf(harness);
        this.testSignatureRawCodec(harness);
    }

    public void testKeyPairRawCodec(TestHarness harness) {
        harness.checkPoint("TestOfRSACodec.testKeyPairRawCodec");
        try {
            byte[] pk1;
            this.setUp();
            RSAPublicKey pubK = (RSAPublicKey)this.kp.getPublic();
            RSAPrivateKey secK = (RSAPrivateKey)this.kp.getPrivate();
            try {
                pk1 = ((GnuRSAPublicKey)pubK).getEncoded(0);
                harness.fail("Succeeded with unknown format ID");
            }
            catch (IllegalArgumentException x) {
                harness.check(true, "Recognised unknown format ID");
            }
            pk1 = ((GnuRSAPublicKey)pubK).getEncoded(1);
            byte[] pk2 = ((GnuRSAPrivateKey)secK).getEncoded(1);
            RSAKeyPairRawCodec codec = new RSAKeyPairRawCodec();
            PublicKey newPubK = codec.decodePublicKey(pk1);
            PrivateKey newSecK = codec.decodePrivateKey(pk2);
            harness.check(pubK.equals(newPubK), "RSA public key Raw encoder/decoder test");
            harness.check(secK.equals(newSecK), "RSA private key Raw encoder/decoder test");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRSACodec.testKeyPairRawCodec");
        }
    }

    public void testSignatureRawCodec(TestHarness harness) {
        harness.checkPoint("TestOfRSACodec.testSignatureRawCodec");
        try {
            this.setUp();
            RSAPublicKey pubK = (RSAPublicKey)this.kp.getPublic();
            RSAPrivateKey secK = (RSAPrivateKey)this.kp.getPrivate();
            RSAPSSSignature alice = new RSAPSSSignature();
            RSAPSSSignature bob = (RSAPSSSignature)alice.clone();
            byte[] message = "1 if by land, 2 if by sea...".getBytes();
            HashMap<String, Key> map = new HashMap<String, Key>();
            map.put("gnu.crypto.sig.private.key", secK);
            alice.setupSign(map);
            alice.update(message, 0, message.length);
            Object signature = alice.sign();
            RSAPSSSignatureRawCodec codec = new RSAPSSSignatureRawCodec();
            byte[] encodedSignature = codec.encodeSignature(signature);
            Object decodedSignature = codec.decodeSignature(encodedSignature);
            map.put("gnu.crypto.sig.public.key", pubK);
            bob.setupVerify(map);
            bob.update(message, 0, message.length);
            harness.check(bob.verify(decodedSignature));
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRSACodec.testSignatureRawCodec");
        }
    }

    public void testPublicKeyValueOf(TestHarness harness) {
        harness.checkPoint("TestOfRSACodec.testPublicKeyValueOf");
        try {
            this.setUp();
            RSAPublicKey pubK = (RSAPublicKey)this.kp.getPublic();
            byte[] pk = ((GnuRSAPublicKey)pubK).getEncoded(1);
            GnuRSAPublicKey newPubK = GnuRSAPublicKey.valueOf((byte[])pk);
            harness.check(pubK.equals(newPubK));
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRSACodec.testPublicKeyValueOf");
        }
    }

    public void testPrivateKeyValueOf(TestHarness harness) {
        harness.checkPoint("TestOfRSACodec.testPrivateKeyValueOf");
        this.setUp();
        try {
            GnuRSAPrivateKey privateK = (GnuRSAPrivateKey)this.kp.getPrivate();
            byte[] pk = privateK.getEncoded(1);
            GnuRSAPrivateKey newSecK = GnuRSAPrivateKey.valueOf((byte[])pk);
            harness.check(privateK.equals(newSecK));
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfRSACodec.testPrivateKeyValueOf");
        }
    }

    private void setUp() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("gnu.crypto.rsa.L", new Integer(1024));
        this.kpg.setup(map);
        this.kp = this.kpg.generate();
    }
}

