/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.cipher;

import gnu.crypto.cipher.BaseCipher;
import gnu.crypto.util.Util;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class Serpent
extends BaseCipher {
    private static final String NAME = "serpent";
    private static final int DEFAULT_KEY_SIZE = 16;
    private static final int DEFAULT_BLOCK_SIZE = 16;
    private static final int ROUNDS = 32;
    private static final int PHI = -1640531527;
    private static final byte[] KAT_KEY = Util.toReversedBytesFromString("008000000000000000000000000000000000000000000000");
    private static final byte[] KAT_CT = Util.toReversedBytesFromString("5587B5BCB9EE5A28BA2BACC418005240");
    private static Boolean valid;
    private int x0;
    private int x1;
    private int x2;
    private int x3;
    private int x4;

    public Serpent() {
        super(NAME, 16, 16);
    }

    public Object clone() {
        Serpent result = new Serpent();
        result.currentBlockSize = this.currentBlockSize;
        return result;
    }

    public Iterator blockSizes() {
        return Collections.singleton(new Integer(16)).iterator();
    }

    public Iterator keySizes() {
        ArrayList<Integer> keySizes = new ArrayList<Integer>();
        keySizes.add(new Integer(16));
        keySizes.add(new Integer(24));
        keySizes.add(new Integer(32));
        return Collections.unmodifiableList(keySizes).iterator();
    }

    public Object makeKey(byte[] kb, int blockSize) throws InvalidKeyException {
        int t;
        if (kb.length != 16 && kb.length != 24 && kb.length != 32) {
            throw new InvalidKeyException("Key length is not 16, 24, or 32 bytes");
        }
        Key key = new Key();
        int[] w = new int[132];
        int i = 0;
        int j = 0;
        while (i < 8 && j < kb.length) {
            w[i] = kb[j++] & 0xFF | (kb[j++] & 0xFF) << 8 | (kb[j++] & 0xFF) << 16 | (kb[j++] & 0xFF) << 24;
            ++i;
        }
        if (i != 8) {
            w[i] = 1;
        }
        i = 8;
        j = 0;
        while (i < 16) {
            t = w[j] ^ w[i - 5] ^ w[i - 3] ^ w[i - 1] ^ 0x9E3779B9 ^ j++;
            w[i] = t << 11 | t >>> 21;
            ++i;
        }
        i = 0;
        while (i < 8) {
            w[i] = w[i + 8];
            ++i;
        }
        while (i < w.length) {
            t = w[i - 8] ^ w[i - 5] ^ w[i - 3] ^ w[i - 1] ^ 0x9E3779B9 ^ i;
            w[i] = t << 11 | t >>> 21;
            ++i;
        }
        this.sbox3(w[0], w[1], w[2], w[3]);
        key.k0 = this.x0;
        key.k1 = this.x1;
        key.k2 = this.x2;
        key.k3 = this.x3;
        this.sbox2(w[4], w[5], w[6], w[7]);
        key.k4 = this.x0;
        key.k5 = this.x1;
        key.k6 = this.x2;
        key.k7 = this.x3;
        this.sbox1(w[8], w[9], w[10], w[11]);
        key.k8 = this.x0;
        key.k9 = this.x1;
        key.k10 = this.x2;
        key.k11 = this.x3;
        this.sbox0(w[12], w[13], w[14], w[15]);
        key.k12 = this.x0;
        key.k13 = this.x1;
        key.k14 = this.x2;
        key.k15 = this.x3;
        this.sbox7(w[16], w[17], w[18], w[19]);
        key.k16 = this.x0;
        key.k17 = this.x1;
        key.k18 = this.x2;
        key.k19 = this.x3;
        this.sbox6(w[20], w[21], w[22], w[23]);
        key.k20 = this.x0;
        key.k21 = this.x1;
        key.k22 = this.x2;
        key.k23 = this.x3;
        this.sbox5(w[24], w[25], w[26], w[27]);
        key.k24 = this.x0;
        key.k25 = this.x1;
        key.k26 = this.x2;
        key.k27 = this.x3;
        this.sbox4(w[28], w[29], w[30], w[31]);
        key.k28 = this.x0;
        key.k29 = this.x1;
        key.k30 = this.x2;
        key.k31 = this.x3;
        this.sbox3(w[32], w[33], w[34], w[35]);
        key.k32 = this.x0;
        key.k33 = this.x1;
        key.k34 = this.x2;
        key.k35 = this.x3;
        this.sbox2(w[36], w[37], w[38], w[39]);
        key.k36 = this.x0;
        key.k37 = this.x1;
        key.k38 = this.x2;
        key.k39 = this.x3;
        this.sbox1(w[40], w[41], w[42], w[43]);
        key.k40 = this.x0;
        key.k41 = this.x1;
        key.k42 = this.x2;
        key.k43 = this.x3;
        this.sbox0(w[44], w[45], w[46], w[47]);
        key.k44 = this.x0;
        key.k45 = this.x1;
        key.k46 = this.x2;
        key.k47 = this.x3;
        this.sbox7(w[48], w[49], w[50], w[51]);
        key.k48 = this.x0;
        key.k49 = this.x1;
        key.k50 = this.x2;
        key.k51 = this.x3;
        this.sbox6(w[52], w[53], w[54], w[55]);
        key.k52 = this.x0;
        key.k53 = this.x1;
        key.k54 = this.x2;
        key.k55 = this.x3;
        this.sbox5(w[56], w[57], w[58], w[59]);
        key.k56 = this.x0;
        key.k57 = this.x1;
        key.k58 = this.x2;
        key.k59 = this.x3;
        this.sbox4(w[60], w[61], w[62], w[63]);
        key.k60 = this.x0;
        key.k61 = this.x1;
        key.k62 = this.x2;
        key.k63 = this.x3;
        this.sbox3(w[64], w[65], w[66], w[67]);
        key.k64 = this.x0;
        key.k65 = this.x1;
        key.k66 = this.x2;
        key.k67 = this.x3;
        this.sbox2(w[68], w[69], w[70], w[71]);
        key.k68 = this.x0;
        key.k69 = this.x1;
        key.k70 = this.x2;
        key.k71 = this.x3;
        this.sbox1(w[72], w[73], w[74], w[75]);
        key.k72 = this.x0;
        key.k73 = this.x1;
        key.k74 = this.x2;
        key.k75 = this.x3;
        this.sbox0(w[76], w[77], w[78], w[79]);
        key.k76 = this.x0;
        key.k77 = this.x1;
        key.k78 = this.x2;
        key.k79 = this.x3;
        this.sbox7(w[80], w[81], w[82], w[83]);
        key.k80 = this.x0;
        key.k81 = this.x1;
        key.k82 = this.x2;
        key.k83 = this.x3;
        this.sbox6(w[84], w[85], w[86], w[87]);
        key.k84 = this.x0;
        key.k85 = this.x1;
        key.k86 = this.x2;
        key.k87 = this.x3;
        this.sbox5(w[88], w[89], w[90], w[91]);
        key.k88 = this.x0;
        key.k89 = this.x1;
        key.k90 = this.x2;
        key.k91 = this.x3;
        this.sbox4(w[92], w[93], w[94], w[95]);
        key.k92 = this.x0;
        key.k93 = this.x1;
        key.k94 = this.x2;
        key.k95 = this.x3;
        this.sbox3(w[96], w[97], w[98], w[99]);
        key.k96 = this.x0;
        key.k97 = this.x1;
        key.k98 = this.x2;
        key.k99 = this.x3;
        this.sbox2(w[100], w[101], w[102], w[103]);
        key.k100 = this.x0;
        key.k101 = this.x1;
        key.k102 = this.x2;
        key.k103 = this.x3;
        this.sbox1(w[104], w[105], w[106], w[107]);
        key.k104 = this.x0;
        key.k105 = this.x1;
        key.k106 = this.x2;
        key.k107 = this.x3;
        this.sbox0(w[108], w[109], w[110], w[111]);
        key.k108 = this.x0;
        key.k109 = this.x1;
        key.k110 = this.x2;
        key.k111 = this.x3;
        this.sbox7(w[112], w[113], w[114], w[115]);
        key.k112 = this.x0;
        key.k113 = this.x1;
        key.k114 = this.x2;
        key.k115 = this.x3;
        this.sbox6(w[116], w[117], w[118], w[119]);
        key.k116 = this.x0;
        key.k117 = this.x1;
        key.k118 = this.x2;
        key.k119 = this.x3;
        this.sbox5(w[120], w[121], w[122], w[123]);
        key.k120 = this.x0;
        key.k121 = this.x1;
        key.k122 = this.x2;
        key.k123 = this.x3;
        this.sbox4(w[124], w[125], w[126], w[127]);
        key.k124 = this.x0;
        key.k125 = this.x1;
        key.k126 = this.x2;
        key.k127 = this.x3;
        this.sbox3(w[128], w[129], w[130], w[131]);
        key.k128 = this.x0;
        key.k129 = this.x1;
        key.k130 = this.x2;
        key.k131 = this.x3;
        return key;
    }

    public synchronized void encrypt(byte[] in, int i, byte[] out, int o, Object K, int bs) {
        Key key = (Key)K;
        this.x0 = in[i] & 0xFF | (in[i + 1] & 0xFF) << 8 | (in[i + 2] & 0xFF) << 16 | (in[i + 3] & 0xFF) << 24;
        this.x1 = in[i + 4] & 0xFF | (in[i + 5] & 0xFF) << 8 | (in[i + 6] & 0xFF) << 16 | (in[i + 7] & 0xFF) << 24;
        this.x2 = in[i + 8] & 0xFF | (in[i + 9] & 0xFF) << 8 | (in[i + 10] & 0xFF) << 16 | (in[i + 11] & 0xFF) << 24;
        this.x3 = in[i + 12] & 0xFF | (in[i + 13] & 0xFF) << 8 | (in[i + 14] & 0xFF) << 16 | (in[i + 15] & 0xFF) << 24;
        this.x0 ^= key.k0;
        this.x1 ^= key.k1;
        this.x2 ^= key.k2;
        this.x3 ^= key.k3;
        this.sbox0();
        this.x1 ^= key.k4;
        this.x4 ^= key.k5;
        this.x2 ^= key.k6;
        this.x0 ^= key.k7;
        this.sbox1();
        this.x0 ^= key.k8;
        this.x4 ^= key.k9;
        this.x2 ^= key.k10;
        this.x1 ^= key.k11;
        this.sbox2();
        this.x2 ^= key.k12;
        this.x1 ^= key.k13;
        this.x4 ^= key.k14;
        this.x3 ^= key.k15;
        this.sbox3();
        this.x1 ^= key.k16;
        this.x4 ^= key.k17;
        this.x3 ^= key.k18;
        this.x0 ^= key.k19;
        this.sbox4();
        this.x4 ^= key.k20;
        this.x2 ^= key.k21;
        this.x1 ^= key.k22;
        this.x0 ^= key.k23;
        this.sbox5();
        this.x2 ^= key.k24;
        this.x0 ^= key.k25;
        this.x4 ^= key.k26;
        this.x1 ^= key.k27;
        this.sbox6();
        this.x2 ^= key.k28;
        this.x0 ^= key.k29;
        this.x3 ^= key.k30;
        this.x4 ^= key.k31;
        this.sbox7();
        this.x0 = this.x3;
        this.x3 = this.x2;
        this.x2 = this.x4;
        this.x0 ^= key.k32;
        this.x1 ^= key.k33;
        this.x2 ^= key.k34;
        this.x3 ^= key.k35;
        this.sbox0();
        this.x1 ^= key.k36;
        this.x4 ^= key.k37;
        this.x2 ^= key.k38;
        this.x0 ^= key.k39;
        this.sbox1();
        this.x0 ^= key.k40;
        this.x4 ^= key.k41;
        this.x2 ^= key.k42;
        this.x1 ^= key.k43;
        this.sbox2();
        this.x2 ^= key.k44;
        this.x1 ^= key.k45;
        this.x4 ^= key.k46;
        this.x3 ^= key.k47;
        this.sbox3();
        this.x1 ^= key.k48;
        this.x4 ^= key.k49;
        this.x3 ^= key.k50;
        this.x0 ^= key.k51;
        this.sbox4();
        this.x4 ^= key.k52;
        this.x2 ^= key.k53;
        this.x1 ^= key.k54;
        this.x0 ^= key.k55;
        this.sbox5();
        this.x2 ^= key.k56;
        this.x0 ^= key.k57;
        this.x4 ^= key.k58;
        this.x1 ^= key.k59;
        this.sbox6();
        this.x2 ^= key.k60;
        this.x0 ^= key.k61;
        this.x3 ^= key.k62;
        this.x4 ^= key.k63;
        this.sbox7();
        this.x0 = this.x3;
        this.x3 = this.x2;
        this.x2 = this.x4;
        this.x0 ^= key.k64;
        this.x1 ^= key.k65;
        this.x2 ^= key.k66;
        this.x3 ^= key.k67;
        this.sbox0();
        this.x1 ^= key.k68;
        this.x4 ^= key.k69;
        this.x2 ^= key.k70;
        this.x0 ^= key.k71;
        this.sbox1();
        this.x0 ^= key.k72;
        this.x4 ^= key.k73;
        this.x2 ^= key.k74;
        this.x1 ^= key.k75;
        this.sbox2();
        this.x2 ^= key.k76;
        this.x1 ^= key.k77;
        this.x4 ^= key.k78;
        this.x3 ^= key.k79;
        this.sbox3();
        this.x1 ^= key.k80;
        this.x4 ^= key.k81;
        this.x3 ^= key.k82;
        this.x0 ^= key.k83;
        this.sbox4();
        this.x4 ^= key.k84;
        this.x2 ^= key.k85;
        this.x1 ^= key.k86;
        this.x0 ^= key.k87;
        this.sbox5();
        this.x2 ^= key.k88;
        this.x0 ^= key.k89;
        this.x4 ^= key.k90;
        this.x1 ^= key.k91;
        this.sbox6();
        this.x2 ^= key.k92;
        this.x0 ^= key.k93;
        this.x3 ^= key.k94;
        this.x4 ^= key.k95;
        this.sbox7();
        this.x0 = this.x3;
        this.x3 = this.x2;
        this.x2 = this.x4;
        this.x0 ^= key.k96;
        this.x1 ^= key.k97;
        this.x2 ^= key.k98;
        this.x3 ^= key.k99;
        this.sbox0();
        this.x1 ^= key.k100;
        this.x4 ^= key.k101;
        this.x2 ^= key.k102;
        this.x0 ^= key.k103;
        this.sbox1();
        this.x0 ^= key.k104;
        this.x4 ^= key.k105;
        this.x2 ^= key.k106;
        this.x1 ^= key.k107;
        this.sbox2();
        this.x2 ^= key.k108;
        this.x1 ^= key.k109;
        this.x4 ^= key.k110;
        this.x3 ^= key.k111;
        this.sbox3();
        this.x1 ^= key.k112;
        this.x4 ^= key.k113;
        this.x3 ^= key.k114;
        this.x0 ^= key.k115;
        this.sbox4();
        this.x4 ^= key.k116;
        this.x2 ^= key.k117;
        this.x1 ^= key.k118;
        this.x0 ^= key.k119;
        this.sbox5();
        this.x2 ^= key.k120;
        this.x0 ^= key.k121;
        this.x4 ^= key.k122;
        this.x1 ^= key.k123;
        this.sbox6();
        this.x2 ^= key.k124;
        this.x0 ^= key.k125;
        this.x3 ^= key.k126;
        this.x4 ^= key.k127;
        this.sbox7noLT();
        this.x0 = this.x3;
        this.x3 = this.x2;
        this.x2 = this.x4;
        this.x0 ^= key.k128;
        this.x1 ^= key.k129;
        this.x2 ^= key.k130;
        this.x3 ^= key.k131;
        out[o] = (byte)this.x0;
        out[o + 1] = (byte)(this.x0 >>> 8);
        out[o + 2] = (byte)(this.x0 >>> 16);
        out[o + 3] = (byte)(this.x0 >>> 24);
        out[o + 4] = (byte)this.x1;
        out[o + 5] = (byte)(this.x1 >>> 8);
        out[o + 6] = (byte)(this.x1 >>> 16);
        out[o + 7] = (byte)(this.x1 >>> 24);
        out[o + 8] = (byte)this.x2;
        out[o + 9] = (byte)(this.x2 >>> 8);
        out[o + 10] = (byte)(this.x2 >>> 16);
        out[o + 11] = (byte)(this.x2 >>> 24);
        out[o + 12] = (byte)this.x3;
        out[o + 13] = (byte)(this.x3 >>> 8);
        out[o + 14] = (byte)(this.x3 >>> 16);
        out[o + 15] = (byte)(this.x3 >>> 24);
    }

    public synchronized void decrypt(byte[] in, int i, byte[] out, int o, Object K, int bs) {
        Key key = (Key)K;
        this.x0 = in[i] & 0xFF | (in[i + 1] & 0xFF) << 8 | (in[i + 2] & 0xFF) << 16 | (in[i + 3] & 0xFF) << 24;
        this.x1 = in[i + 4] & 0xFF | (in[i + 5] & 0xFF) << 8 | (in[i + 6] & 0xFF) << 16 | (in[i + 7] & 0xFF) << 24;
        this.x2 = in[i + 8] & 0xFF | (in[i + 9] & 0xFF) << 8 | (in[i + 10] & 0xFF) << 16 | (in[i + 11] & 0xFF) << 24;
        this.x3 = in[i + 12] & 0xFF | (in[i + 13] & 0xFF) << 8 | (in[i + 14] & 0xFF) << 16 | (in[i + 15] & 0xFF) << 24;
        this.x0 ^= key.k128;
        this.x1 ^= key.k129;
        this.x2 ^= key.k130;
        this.x3 ^= key.k131;
        this.sboxI7noLT();
        this.x3 ^= key.k124;
        this.x0 ^= key.k125;
        this.x1 ^= key.k126;
        this.x4 ^= key.k127;
        this.sboxI6();
        this.x0 ^= key.k120;
        this.x1 ^= key.k121;
        this.x2 ^= key.k122;
        this.x4 ^= key.k123;
        this.sboxI5();
        this.x1 ^= key.k116;
        this.x3 ^= key.k117;
        this.x4 ^= key.k118;
        this.x2 ^= key.k119;
        this.sboxI4();
        this.x1 ^= key.k112;
        this.x2 ^= key.k113;
        this.x4 ^= key.k114;
        this.x0 ^= key.k115;
        this.sboxI3();
        this.x0 ^= key.k108;
        this.x1 ^= key.k109;
        this.x4 ^= key.k110;
        this.x2 ^= key.k111;
        this.sboxI2();
        this.x1 ^= key.k104;
        this.x3 ^= key.k105;
        this.x4 ^= key.k106;
        this.x2 ^= key.k107;
        this.sboxI1();
        this.x0 ^= key.k100;
        this.x1 ^= key.k101;
        this.x2 ^= key.k102;
        this.x4 ^= key.k103;
        this.sboxI0();
        this.x0 ^= key.k96;
        this.x3 ^= key.k97;
        this.x1 ^= key.k98;
        this.x4 ^= key.k99;
        this.sboxI7();
        this.x1 = this.x3;
        this.x3 = this.x4;
        this.x4 = this.x2;
        this.x3 ^= key.k92;
        this.x0 ^= key.k93;
        this.x1 ^= key.k94;
        this.x4 ^= key.k95;
        this.sboxI6();
        this.x0 ^= key.k88;
        this.x1 ^= key.k89;
        this.x2 ^= key.k90;
        this.x4 ^= key.k91;
        this.sboxI5();
        this.x1 ^= key.k84;
        this.x3 ^= key.k85;
        this.x4 ^= key.k86;
        this.x2 ^= key.k87;
        this.sboxI4();
        this.x1 ^= key.k80;
        this.x2 ^= key.k81;
        this.x4 ^= key.k82;
        this.x0 ^= key.k83;
        this.sboxI3();
        this.x0 ^= key.k76;
        this.x1 ^= key.k77;
        this.x4 ^= key.k78;
        this.x2 ^= key.k79;
        this.sboxI2();
        this.x1 ^= key.k72;
        this.x3 ^= key.k73;
        this.x4 ^= key.k74;
        this.x2 ^= key.k75;
        this.sboxI1();
        this.x0 ^= key.k68;
        this.x1 ^= key.k69;
        this.x2 ^= key.k70;
        this.x4 ^= key.k71;
        this.sboxI0();
        this.x0 ^= key.k64;
        this.x3 ^= key.k65;
        this.x1 ^= key.k66;
        this.x4 ^= key.k67;
        this.sboxI7();
        this.x1 = this.x3;
        this.x3 = this.x4;
        this.x4 = this.x2;
        this.x3 ^= key.k60;
        this.x0 ^= key.k61;
        this.x1 ^= key.k62;
        this.x4 ^= key.k63;
        this.sboxI6();
        this.x0 ^= key.k56;
        this.x1 ^= key.k57;
        this.x2 ^= key.k58;
        this.x4 ^= key.k59;
        this.sboxI5();
        this.x1 ^= key.k52;
        this.x3 ^= key.k53;
        this.x4 ^= key.k54;
        this.x2 ^= key.k55;
        this.sboxI4();
        this.x1 ^= key.k48;
        this.x2 ^= key.k49;
        this.x4 ^= key.k50;
        this.x0 ^= key.k51;
        this.sboxI3();
        this.x0 ^= key.k44;
        this.x1 ^= key.k45;
        this.x4 ^= key.k46;
        this.x2 ^= key.k47;
        this.sboxI2();
        this.x1 ^= key.k40;
        this.x3 ^= key.k41;
        this.x4 ^= key.k42;
        this.x2 ^= key.k43;
        this.sboxI1();
        this.x0 ^= key.k36;
        this.x1 ^= key.k37;
        this.x2 ^= key.k38;
        this.x4 ^= key.k39;
        this.sboxI0();
        this.x0 ^= key.k32;
        this.x3 ^= key.k33;
        this.x1 ^= key.k34;
        this.x4 ^= key.k35;
        this.sboxI7();
        this.x1 = this.x3;
        this.x3 = this.x4;
        this.x4 = this.x2;
        this.x3 ^= key.k28;
        this.x0 ^= key.k29;
        this.x1 ^= key.k30;
        this.x4 ^= key.k31;
        this.sboxI6();
        this.x0 ^= key.k24;
        this.x1 ^= key.k25;
        this.x2 ^= key.k26;
        this.x4 ^= key.k27;
        this.sboxI5();
        this.x1 ^= key.k20;
        this.x3 ^= key.k21;
        this.x4 ^= key.k22;
        this.x2 ^= key.k23;
        this.sboxI4();
        this.x1 ^= key.k16;
        this.x2 ^= key.k17;
        this.x4 ^= key.k18;
        this.x0 ^= key.k19;
        this.sboxI3();
        this.x0 ^= key.k12;
        this.x1 ^= key.k13;
        this.x4 ^= key.k14;
        this.x2 ^= key.k15;
        this.sboxI2();
        this.x1 ^= key.k8;
        this.x3 ^= key.k9;
        this.x4 ^= key.k10;
        this.x2 ^= key.k11;
        this.sboxI1();
        this.x0 ^= key.k4;
        this.x1 ^= key.k5;
        this.x2 ^= key.k6;
        this.x4 ^= key.k7;
        this.sboxI0();
        this.x2 = this.x1;
        this.x1 = this.x3;
        this.x3 = this.x4;
        this.x0 ^= key.k0;
        this.x1 ^= key.k1;
        this.x2 ^= key.k2;
        this.x3 ^= key.k3;
        out[o] = (byte)this.x0;
        out[o + 1] = (byte)(this.x0 >>> 8);
        out[o + 2] = (byte)(this.x0 >>> 16);
        out[o + 3] = (byte)(this.x0 >>> 24);
        out[o + 4] = (byte)this.x1;
        out[o + 5] = (byte)(this.x1 >>> 8);
        out[o + 6] = (byte)(this.x1 >>> 16);
        out[o + 7] = (byte)(this.x1 >>> 24);
        out[o + 8] = (byte)this.x2;
        out[o + 9] = (byte)(this.x2 >>> 8);
        out[o + 10] = (byte)(this.x2 >>> 16);
        out[o + 11] = (byte)(this.x2 >>> 24);
        out[o + 12] = (byte)this.x3;
        out[o + 13] = (byte)(this.x3 >>> 8);
        out[o + 14] = (byte)(this.x3 >>> 16);
        out[o + 15] = (byte)(this.x3 >>> 24);
    }

    public boolean selfTest() {
        if (valid == null) {
            boolean result = super.selfTest();
            if (result) {
                result = this.testKat(KAT_KEY, KAT_CT);
            }
            valid = new Boolean(result);
        }
        return valid;
    }

    private void sbox0() {
        this.x3 ^= this.x0;
        this.x4 = this.x1;
        this.x1 &= this.x3;
        this.x4 ^= this.x2;
        this.x1 ^= this.x0;
        this.x0 |= this.x3;
        this.x0 ^= this.x4;
        this.x4 ^= this.x3;
        this.x3 ^= this.x2;
        this.x2 |= this.x1;
        this.x2 ^= this.x4;
        this.x4 ^= 0xFFFFFFFF;
        this.x4 |= this.x1;
        this.x1 ^= this.x3;
        this.x1 ^= this.x4;
        this.x3 |= this.x0;
        this.x1 ^= this.x3;
        this.x4 ^= this.x3;
        this.x1 = this.x1 << 13 | this.x1 >>> 19;
        this.x4 ^= this.x1;
        this.x3 = this.x1 << 3;
        this.x2 = this.x2 << 3 | this.x2 >>> 29;
        this.x4 ^= this.x2;
        this.x0 ^= this.x2;
        this.x4 = this.x4 << 1 | this.x4 >>> 31;
        this.x0 ^= this.x3;
        this.x0 = this.x0 << 7 | this.x0 >>> 25;
        this.x3 = this.x4;
        this.x1 ^= this.x4;
        this.x3 <<= 7;
        this.x1 ^= this.x0;
        this.x2 ^= this.x0;
        this.x2 ^= this.x3;
        this.x1 = this.x1 << 5 | this.x1 >>> 27;
        this.x2 = this.x2 << 22 | this.x2 >>> 10;
    }

    private void sbox1() {
        this.x4 ^= 0xFFFFFFFF;
        this.x3 = this.x1;
        this.x1 ^= this.x4;
        this.x3 |= this.x4;
        this.x3 ^= this.x0;
        this.x0 &= this.x1;
        this.x2 ^= this.x3;
        this.x0 ^= this.x4;
        this.x0 |= this.x2;
        this.x1 ^= this.x3;
        this.x0 ^= this.x1;
        this.x4 &= this.x2;
        this.x1 |= this.x4;
        this.x4 ^= this.x3;
        this.x1 ^= this.x2;
        this.x3 |= this.x0;
        this.x1 ^= this.x3;
        this.x3 ^= 0xFFFFFFFF;
        this.x4 ^= this.x0;
        this.x3 &= this.x2;
        this.x4 ^= 0xFFFFFFFF;
        this.x3 ^= this.x1;
        this.x4 ^= this.x3;
        this.x0 = this.x0 << 13 | this.x0 >>> 19;
        this.x4 ^= this.x0;
        this.x3 = this.x0 << 3;
        this.x2 = this.x2 << 3 | this.x2 >>> 29;
        this.x4 ^= this.x2;
        this.x1 ^= this.x2;
        this.x4 = this.x4 << 1 | this.x4 >>> 31;
        this.x1 ^= this.x3;
        this.x1 = this.x1 << 7 | this.x1 >>> 25;
        this.x3 = this.x4;
        this.x0 ^= this.x4;
        this.x3 <<= 7;
        this.x0 ^= this.x1;
        this.x2 ^= this.x1;
        this.x2 ^= this.x3;
        this.x0 = this.x0 << 5 | this.x0 >>> 27;
        this.x2 = this.x2 << 22 | this.x2 >>> 10;
    }

    private void sbox2() {
        this.x3 = this.x0;
        this.x0 &= this.x2;
        this.x0 ^= this.x1;
        this.x2 ^= this.x4;
        this.x2 ^= this.x0;
        this.x1 |= this.x3;
        this.x1 ^= this.x4;
        this.x3 ^= this.x2;
        this.x4 = this.x1;
        this.x1 |= this.x3;
        this.x1 ^= this.x0;
        this.x0 &= this.x4;
        this.x3 ^= this.x0;
        this.x4 ^= this.x1;
        this.x4 ^= this.x3;
        this.x3 ^= 0xFFFFFFFF;
        this.x2 = this.x2 << 13 | this.x2 >>> 19;
        this.x1 ^= this.x2;
        this.x0 = this.x2 << 3;
        this.x4 = this.x4 << 3 | this.x4 >>> 29;
        this.x1 ^= this.x4;
        this.x3 ^= this.x4;
        this.x1 = this.x1 << 1 | this.x1 >>> 31;
        this.x3 ^= this.x0;
        this.x3 = this.x3 << 7 | this.x3 >>> 25;
        this.x0 = this.x1;
        this.x2 ^= this.x1;
        this.x0 <<= 7;
        this.x2 ^= this.x3;
        this.x4 ^= this.x3;
        this.x4 ^= this.x0;
        this.x2 = this.x2 << 5 | this.x2 >>> 27;
        this.x4 = this.x4 << 22 | this.x4 >>> 10;
    }

    private void sbox3() {
        this.x0 = this.x2;
        this.x2 |= this.x3;
        this.x3 ^= this.x1;
        this.x1 &= this.x0;
        this.x0 ^= this.x4;
        this.x4 ^= this.x3;
        this.x3 &= this.x2;
        this.x0 |= this.x1;
        this.x3 ^= this.x0;
        this.x2 ^= this.x1;
        this.x0 &= this.x2;
        this.x1 ^= this.x3;
        this.x0 ^= this.x4;
        this.x1 |= this.x2;
        this.x1 ^= this.x4;
        this.x2 ^= this.x3;
        this.x4 = this.x1;
        this.x1 |= this.x3;
        this.x1 ^= this.x2;
        this.x1 = this.x1 << 13 | this.x1 >>> 19;
        this.x4 ^= this.x1;
        this.x2 = this.x1 << 3;
        this.x3 = this.x3 << 3 | this.x3 >>> 29;
        this.x4 ^= this.x3;
        this.x0 ^= this.x3;
        this.x4 = this.x4 << 1 | this.x4 >>> 31;
        this.x0 ^= this.x2;
        this.x0 = this.x0 << 7 | this.x0 >>> 25;
        this.x2 = this.x4;
        this.x1 ^= this.x4;
        this.x2 <<= 7;
        this.x1 ^= this.x0;
        this.x3 ^= this.x0;
        this.x3 ^= this.x2;
        this.x1 = this.x1 << 5 | this.x1 >>> 27;
        this.x3 = this.x3 << 22 | this.x3 >>> 10;
    }

    private void sbox4() {
        this.x4 ^= this.x0;
        this.x0 ^= 0xFFFFFFFF;
        this.x3 ^= this.x0;
        this.x0 ^= this.x1;
        this.x2 = this.x4;
        this.x4 &= this.x0;
        this.x4 ^= this.x3;
        this.x2 ^= this.x0;
        this.x1 ^= this.x2;
        this.x3 &= this.x2;
        this.x3 ^= this.x1;
        this.x1 &= this.x4;
        this.x0 ^= this.x1;
        this.x2 |= this.x4;
        this.x2 ^= this.x1;
        this.x1 |= this.x0;
        this.x1 ^= this.x3;
        this.x3 &= this.x0;
        this.x1 ^= 0xFFFFFFFF;
        this.x2 ^= this.x3;
        this.x4 = this.x4 << 13 | this.x4 >>> 19;
        this.x2 ^= this.x4;
        this.x3 = this.x4 << 3;
        this.x1 = this.x1 << 3 | this.x1 >>> 29;
        this.x2 ^= this.x1;
        this.x0 ^= this.x1;
        this.x2 = this.x2 << 1 | this.x2 >>> 31;
        this.x0 ^= this.x3;
        this.x0 = this.x0 << 7 | this.x0 >>> 25;
        this.x3 = this.x2;
        this.x4 ^= this.x2;
        this.x3 <<= 7;
        this.x4 ^= this.x0;
        this.x1 ^= this.x0;
        this.x1 ^= this.x3;
        this.x4 = this.x4 << 5 | this.x4 >>> 27;
        this.x1 = this.x1 << 22 | this.x1 >>> 10;
    }

    private void sbox5() {
        this.x4 ^= this.x2;
        this.x2 ^= this.x0;
        this.x0 ^= 0xFFFFFFFF;
        this.x3 = this.x2;
        this.x2 &= this.x4;
        this.x1 ^= this.x0;
        this.x2 ^= this.x1;
        this.x1 |= this.x3;
        this.x3 ^= this.x0;
        this.x0 &= this.x2;
        this.x0 ^= this.x4;
        this.x3 ^= this.x2;
        this.x3 ^= this.x1;
        this.x1 ^= this.x4;
        this.x4 &= this.x0;
        this.x1 ^= 0xFFFFFFFF;
        this.x4 ^= this.x3;
        this.x3 |= this.x0;
        this.x1 ^= this.x3;
        this.x2 = this.x2 << 13 | this.x2 >>> 19;
        this.x0 ^= this.x2;
        this.x3 = this.x2 << 3;
        this.x4 = this.x4 << 3 | this.x4 >>> 29;
        this.x0 ^= this.x4;
        this.x1 ^= this.x4;
        this.x0 = this.x0 << 1 | this.x0 >>> 31;
        this.x1 ^= this.x3;
        this.x1 = this.x1 << 7 | this.x1 >>> 25;
        this.x3 = this.x0;
        this.x2 ^= this.x0;
        this.x3 <<= 7;
        this.x2 ^= this.x1;
        this.x4 ^= this.x1;
        this.x4 ^= this.x3;
        this.x2 = this.x2 << 5 | this.x2 >>> 27;
        this.x4 = this.x4 << 22 | this.x4 >>> 10;
    }

    private void sbox6() {
        this.x4 ^= 0xFFFFFFFF;
        this.x3 = this.x1;
        this.x1 &= this.x2;
        this.x2 ^= this.x3;
        this.x1 ^= this.x4;
        this.x4 |= this.x3;
        this.x0 ^= this.x1;
        this.x4 ^= this.x2;
        this.x2 |= this.x0;
        this.x4 ^= this.x0;
        this.x3 ^= this.x2;
        this.x2 |= this.x1;
        this.x2 ^= this.x4;
        this.x3 ^= this.x1;
        this.x3 ^= this.x2;
        this.x1 ^= 0xFFFFFFFF;
        this.x4 &= this.x3;
        this.x4 ^= this.x1;
        this.x2 = this.x2 << 13 | this.x2 >>> 19;
        this.x0 ^= this.x2;
        this.x1 = this.x2 << 3;
        this.x3 = this.x3 << 3 | this.x3 >>> 29;
        this.x0 ^= this.x3;
        this.x4 ^= this.x3;
        this.x0 = this.x0 << 1 | this.x0 >>> 31;
        this.x4 ^= this.x1;
        this.x4 = this.x4 << 7 | this.x4 >>> 25;
        this.x1 = this.x0;
        this.x2 ^= this.x0;
        this.x1 <<= 7;
        this.x2 ^= this.x4;
        this.x3 ^= this.x4;
        this.x3 ^= this.x1;
        this.x2 = this.x2 << 5 | this.x2 >>> 27;
        this.x3 = this.x3 << 22 | this.x3 >>> 10;
    }

    private void sbox7() {
        this.x1 = this.x3;
        this.x3 &= this.x0;
        this.x3 ^= this.x4;
        this.x4 &= this.x0;
        this.x1 ^= this.x3;
        this.x3 ^= this.x0;
        this.x0 ^= this.x2;
        this.x2 |= this.x1;
        this.x2 ^= this.x3;
        this.x4 ^= this.x0;
        this.x3 ^= this.x4;
        this.x4 &= this.x2;
        this.x4 ^= this.x1;
        this.x1 ^= this.x3;
        this.x3 &= this.x2;
        this.x1 ^= 0xFFFFFFFF;
        this.x3 ^= this.x1;
        this.x1 &= this.x2;
        this.x0 ^= this.x4;
        this.x1 ^= this.x0;
        this.x3 = this.x3 << 13 | this.x3 >>> 19;
        this.x1 ^= this.x3;
        this.x0 = this.x3 << 3;
        this.x4 = this.x4 << 3 | this.x4 >>> 29;
        this.x1 ^= this.x4;
        this.x2 ^= this.x4;
        this.x1 = this.x1 << 1 | this.x1 >>> 31;
        this.x2 ^= this.x0;
        this.x2 = this.x2 << 7 | this.x2 >>> 25;
        this.x0 = this.x1;
        this.x3 ^= this.x1;
        this.x0 <<= 7;
        this.x3 ^= this.x2;
        this.x4 ^= this.x2;
        this.x4 ^= this.x0;
        this.x3 = this.x3 << 5 | this.x3 >>> 27;
        this.x4 = this.x4 << 22 | this.x4 >>> 10;
    }

    private void sbox7noLT() {
        this.x1 = this.x3;
        this.x3 &= this.x0;
        this.x3 ^= this.x4;
        this.x4 &= this.x0;
        this.x1 ^= this.x3;
        this.x3 ^= this.x0;
        this.x0 ^= this.x2;
        this.x2 |= this.x1;
        this.x2 ^= this.x3;
        this.x4 ^= this.x0;
        this.x3 ^= this.x4;
        this.x4 &= this.x2;
        this.x4 ^= this.x1;
        this.x1 ^= this.x3;
        this.x3 &= this.x2;
        this.x1 ^= 0xFFFFFFFF;
        this.x3 ^= this.x1;
        this.x1 &= this.x2;
        this.x0 ^= this.x4;
        this.x1 ^= this.x0;
    }

    private void sboxI7noLT() {
        this.x4 = this.x2;
        this.x2 ^= this.x0;
        this.x0 &= this.x3;
        this.x2 ^= 0xFFFFFFFF;
        this.x4 |= this.x3;
        this.x3 ^= this.x1;
        this.x1 |= this.x0;
        this.x0 ^= this.x2;
        this.x2 &= this.x4;
        this.x1 ^= this.x2;
        this.x2 ^= this.x0;
        this.x0 |= this.x2;
        this.x3 &= this.x4;
        this.x0 ^= this.x3;
        this.x4 ^= this.x1;
        this.x3 ^= this.x4;
        this.x4 |= this.x0;
        this.x3 ^= this.x2;
        this.x4 ^= this.x2;
    }

    private void sboxI6() {
        this.x1 = this.x1 >>> 22 | this.x1 << 10;
        this.x3 = this.x3 >>> 5 | this.x3 << 27;
        this.x2 = this.x0;
        this.x1 ^= this.x4;
        this.x2 <<= 7;
        this.x3 ^= this.x4;
        this.x1 ^= this.x2;
        this.x3 ^= this.x0;
        this.x4 = this.x4 >>> 7 | this.x4 << 25;
        this.x0 = this.x0 >>> 1 | this.x0 << 31;
        this.x0 ^= this.x3;
        this.x2 = this.x3 << 3;
        this.x4 ^= this.x2;
        this.x3 = this.x3 >>> 13 | this.x3 << 19;
        this.x0 ^= this.x1;
        this.x4 ^= this.x1;
        this.x1 = this.x1 >>> 3 | this.x1 << 29;
        this.x3 ^= this.x1;
        this.x2 = this.x1;
        this.x1 &= this.x3;
        this.x2 ^= this.x4;
        this.x1 ^= 0xFFFFFFFF;
        this.x4 ^= this.x0;
        this.x1 ^= this.x4;
        this.x2 |= this.x3;
        this.x3 ^= this.x1;
        this.x4 ^= this.x2;
        this.x2 ^= this.x0;
        this.x0 &= this.x4;
        this.x0 ^= this.x3;
        this.x3 ^= this.x4;
        this.x3 |= this.x1;
        this.x4 ^= this.x0;
        this.x2 ^= this.x3;
    }

    private void sboxI5() {
        this.x2 = this.x2 >>> 22 | this.x2 << 10;
        this.x0 = this.x0 >>> 5 | this.x0 << 27;
        this.x3 = this.x1;
        this.x2 ^= this.x4;
        this.x3 <<= 7;
        this.x0 ^= this.x4;
        this.x2 ^= this.x3;
        this.x0 ^= this.x1;
        this.x4 = this.x4 >>> 7 | this.x4 << 25;
        this.x1 = this.x1 >>> 1 | this.x1 << 31;
        this.x1 ^= this.x0;
        this.x3 = this.x0 << 3;
        this.x4 ^= this.x3;
        this.x0 = this.x0 >>> 13 | this.x0 << 19;
        this.x1 ^= this.x2;
        this.x4 ^= this.x2;
        this.x2 = this.x2 >>> 3 | this.x2 << 29;
        this.x1 ^= 0xFFFFFFFF;
        this.x3 = this.x4;
        this.x2 ^= this.x1;
        this.x4 |= this.x0;
        this.x4 ^= this.x2;
        this.x2 |= this.x1;
        this.x2 &= this.x0;
        this.x3 ^= this.x4;
        this.x2 ^= this.x3;
        this.x3 |= this.x0;
        this.x3 ^= this.x1;
        this.x1 &= this.x2;
        this.x1 ^= this.x4;
        this.x3 ^= this.x2;
        this.x4 &= this.x3;
        this.x3 ^= this.x1;
        this.x4 ^= this.x0;
        this.x4 ^= this.x3;
        this.x3 ^= 0xFFFFFFFF;
    }

    private void sboxI4() {
        this.x4 = this.x4 >>> 22 | this.x4 << 10;
        this.x1 = this.x1 >>> 5 | this.x1 << 27;
        this.x0 = this.x3;
        this.x4 ^= this.x2;
        this.x0 <<= 7;
        this.x1 ^= this.x2;
        this.x4 ^= this.x0;
        this.x1 ^= this.x3;
        this.x2 = this.x2 >>> 7 | this.x2 << 25;
        this.x3 = this.x3 >>> 1 | this.x3 << 31;
        this.x3 ^= this.x1;
        this.x0 = this.x1 << 3;
        this.x2 ^= this.x0;
        this.x1 = this.x1 >>> 13 | this.x1 << 19;
        this.x3 ^= this.x4;
        this.x2 ^= this.x4;
        this.x0 = this.x4 = this.x4 >>> 3 | this.x4 << 29;
        this.x4 &= this.x2;
        this.x4 ^= this.x3;
        this.x3 |= this.x2;
        this.x3 &= this.x1;
        this.x0 ^= this.x4;
        this.x0 ^= this.x3;
        this.x3 &= this.x4;
        this.x1 ^= 0xFFFFFFFF;
        this.x2 ^= this.x0;
        this.x3 ^= this.x2;
        this.x2 &= this.x1;
        this.x2 ^= this.x4;
        this.x1 ^= this.x3;
        this.x4 &= this.x1;
        this.x2 ^= this.x1;
        this.x4 ^= this.x0;
        this.x4 |= this.x2;
        this.x2 ^= this.x1;
        this.x4 ^= this.x3;
    }

    private void sboxI3() {
        this.x4 = this.x4 >>> 22 | this.x4 << 10;
        this.x1 = this.x1 >>> 5 | this.x1 << 27;
        this.x3 = this.x2;
        this.x4 ^= this.x0;
        this.x3 <<= 7;
        this.x1 ^= this.x0;
        this.x4 ^= this.x3;
        this.x1 ^= this.x2;
        this.x0 = this.x0 >>> 7 | this.x0 << 25;
        this.x2 = this.x2 >>> 1 | this.x2 << 31;
        this.x2 ^= this.x1;
        this.x3 = this.x1 << 3;
        this.x0 ^= this.x3;
        this.x1 = this.x1 >>> 13 | this.x1 << 19;
        this.x2 ^= this.x4;
        this.x0 ^= this.x4;
        this.x3 = this.x4 = this.x4 >>> 3 | this.x4 << 29;
        this.x4 ^= this.x2;
        this.x2 &= this.x4;
        this.x2 ^= this.x1;
        this.x1 &= this.x3;
        this.x3 ^= this.x0;
        this.x0 |= this.x2;
        this.x0 ^= this.x4;
        this.x1 ^= this.x3;
        this.x4 ^= this.x1;
        this.x1 |= this.x0;
        this.x1 ^= this.x2;
        this.x3 ^= this.x4;
        this.x4 &= this.x0;
        this.x2 |= this.x0;
        this.x2 ^= this.x4;
        this.x3 ^= this.x1;
        this.x4 ^= this.x3;
    }

    private void sboxI2() {
        this.x4 = this.x4 >>> 22 | this.x4 << 10;
        this.x0 = this.x0 >>> 5 | this.x0 << 27;
        this.x3 = this.x1;
        this.x4 ^= this.x2;
        this.x3 <<= 7;
        this.x0 ^= this.x2;
        this.x4 ^= this.x3;
        this.x0 ^= this.x1;
        this.x2 = this.x2 >>> 7 | this.x2 << 25;
        this.x1 = this.x1 >>> 1 | this.x1 << 31;
        this.x1 ^= this.x0;
        this.x3 = this.x0 << 3;
        this.x2 ^= this.x3;
        this.x0 = this.x0 >>> 13 | this.x0 << 19;
        this.x1 ^= this.x4;
        this.x2 ^= this.x4;
        this.x4 = this.x4 >>> 3 | this.x4 << 29;
        this.x4 ^= this.x2;
        this.x2 ^= this.x0;
        this.x3 = this.x2;
        this.x2 &= this.x4;
        this.x2 ^= this.x1;
        this.x1 |= this.x4;
        this.x1 ^= this.x3;
        this.x3 &= this.x2;
        this.x4 ^= this.x2;
        this.x3 &= this.x0;
        this.x3 ^= this.x4;
        this.x4 &= this.x1;
        this.x4 |= this.x0;
        this.x2 ^= 0xFFFFFFFF;
        this.x4 ^= this.x2;
        this.x0 ^= this.x2;
        this.x0 &= this.x1;
        this.x2 ^= this.x3;
        this.x2 ^= this.x0;
    }

    private void sboxI1() {
        this.x4 = this.x4 >>> 22 | this.x4 << 10;
        this.x1 = this.x1 >>> 5 | this.x1 << 27;
        this.x0 = this.x3;
        this.x4 ^= this.x2;
        this.x0 <<= 7;
        this.x1 ^= this.x2;
        this.x4 ^= this.x0;
        this.x1 ^= this.x3;
        this.x2 = this.x2 >>> 7 | this.x2 << 25;
        this.x3 = this.x3 >>> 1 | this.x3 << 31;
        this.x3 ^= this.x1;
        this.x0 = this.x1 << 3;
        this.x2 ^= this.x0;
        this.x1 = this.x1 >>> 13 | this.x1 << 19;
        this.x3 ^= this.x4;
        this.x2 ^= this.x4;
        this.x4 = this.x4 >>> 3 | this.x4 << 29;
        this.x0 = this.x3;
        this.x3 ^= this.x2;
        this.x2 &= this.x3;
        this.x0 ^= this.x4;
        this.x2 ^= this.x1;
        this.x1 |= this.x3;
        this.x4 ^= this.x2;
        this.x1 ^= this.x0;
        this.x1 |= this.x4;
        this.x3 ^= this.x2;
        this.x1 ^= this.x3;
        this.x3 |= this.x2;
        this.x3 ^= this.x1;
        this.x0 ^= 0xFFFFFFFF;
        this.x0 ^= this.x3;
        this.x3 |= this.x1;
        this.x3 ^= this.x1;
        this.x3 |= this.x0;
        this.x2 ^= this.x3;
    }

    private void sboxI0() {
        this.x2 = this.x2 >>> 22 | this.x2 << 10;
        this.x0 = this.x0 >>> 5 | this.x0 << 27;
        this.x3 = this.x1;
        this.x2 ^= this.x4;
        this.x3 <<= 7;
        this.x0 ^= this.x4;
        this.x2 ^= this.x3;
        this.x0 ^= this.x1;
        this.x4 = this.x4 >>> 7 | this.x4 << 25;
        this.x1 = this.x1 >>> 1 | this.x1 << 31;
        this.x1 ^= this.x0;
        this.x3 = this.x0 << 3;
        this.x4 ^= this.x3;
        this.x0 = this.x0 >>> 13 | this.x0 << 19;
        this.x1 ^= this.x2;
        this.x4 ^= this.x2;
        this.x2 = this.x2 >>> 3 | this.x2 << 29;
        this.x2 ^= 0xFFFFFFFF;
        this.x3 = this.x1;
        this.x1 |= this.x0;
        this.x3 ^= 0xFFFFFFFF;
        this.x1 ^= this.x2;
        this.x2 |= this.x3;
        this.x1 ^= this.x4;
        this.x0 ^= this.x3;
        this.x2 ^= this.x0;
        this.x0 &= this.x4;
        this.x3 ^= this.x0;
        this.x0 |= this.x1;
        this.x0 ^= this.x2;
        this.x4 ^= this.x3;
        this.x2 ^= this.x1;
        this.x4 ^= this.x0;
        this.x4 ^= this.x1;
        this.x2 &= this.x4;
        this.x3 ^= this.x2;
    }

    private void sboxI7() {
        this.x1 = this.x1 >>> 22 | this.x1 << 10;
        this.x0 = this.x0 >>> 5 | this.x0 << 27;
        this.x2 = this.x3;
        this.x1 ^= this.x4;
        this.x2 <<= 7;
        this.x0 ^= this.x4;
        this.x1 ^= this.x2;
        this.x0 ^= this.x3;
        this.x4 = this.x4 >>> 7 | this.x4 << 25;
        this.x3 = this.x3 >>> 1 | this.x3 << 31;
        this.x3 ^= this.x0;
        this.x2 = this.x0 << 3;
        this.x4 ^= this.x2;
        this.x0 = this.x0 >>> 13 | this.x0 << 19;
        this.x3 ^= this.x1;
        this.x4 ^= this.x1;
        this.x2 = this.x1 = this.x1 >>> 3 | this.x1 << 29;
        this.x1 ^= this.x0;
        this.x0 &= this.x4;
        this.x1 ^= 0xFFFFFFFF;
        this.x2 |= this.x4;
        this.x4 ^= this.x3;
        this.x3 |= this.x0;
        this.x0 ^= this.x1;
        this.x1 &= this.x2;
        this.x3 ^= this.x1;
        this.x1 ^= this.x0;
        this.x0 |= this.x1;
        this.x4 &= this.x2;
        this.x0 ^= this.x4;
        this.x2 ^= this.x3;
        this.x4 ^= this.x2;
        this.x2 |= this.x0;
        this.x4 ^= this.x1;
        this.x2 ^= this.x1;
    }

    private void sbox0(int r0, int r1, int r2, int r3) {
        int r4 = r1 ^ r2;
        r1 = r1 & (r3 ^= r0) ^ r0;
        r0 = (r0 | r3) ^ r4;
        r4 ^= r3;
        r3 ^= r2;
        r2 = (r2 | r1) ^ r4;
        r4 = ~r4 | r1;
        r1 ^= r3 ^ r4;
        this.x0 = r1 ^ (r3 |= r0);
        this.x1 = r4 ^ r3;
        this.x2 = r2;
        this.x3 = r0;
    }

    private void sbox1(int r0, int r1, int r2, int r3) {
        int r4 = r0 ^= 0xFFFFFFFF;
        r2 ^= 0xFFFFFFFF;
        r0 |= r3;
        r3 ^= (r2 ^= (r0 &= r1));
        r1 ^= r0;
        r0 ^= r4;
        r4 |= r1;
        r2 = (r2 | r0) & r4;
        this.x0 = r2;
        this.x1 = (r0 ^= (r1 ^= r3)) & r2 ^ r4;
        this.x2 = r3;
        this.x3 = r1 & r2 ^ r0;
    }

    private void sbox2(int r0, int r1, int r2, int r3) {
        int r4 = r0;
        r0 = r0 & r2 ^ r3;
        r2 = r2 ^ r1 ^ r0;
        r3 = (r3 | r4) ^ r1;
        r1 = r3;
        r3 = (r3 | (r4 ^= r2)) ^ r0;
        this.x0 = r2;
        this.x1 = r3;
        this.x2 = r1 ^ r3 ^ (r4 ^= (r0 &= r1));
        this.x3 = ~r4;
    }

    private void sbox3(int r0, int r1, int r2, int r3) {
        int r4 = r0;
        r0 |= r3;
        r3 ^= r1;
        r1 &= r4;
        r4 = r4 ^ r2 | r1;
        r2 ^= r3;
        r3 = r3 & r0 ^ r4;
        r4 = r4 & (r0 ^= r1) ^ r2;
        r1 = (r1 ^ r3 | r0) ^ r2;
        this.x0 = (r1 | r3) ^ (r0 ^= r3);
        this.x1 = r1;
        this.x2 = r3;
        this.x3 = r4;
    }

    private void sbox4(int r0, int r1, int r2, int r3) {
        int r4 = r1 ^= r3;
        r1 = r1 & (r3 ^= r0) ^ (r2 ^= (r3 ^= 0xFFFFFFFF));
        r2 = r2 & r4 ^ (r0 ^= (r4 ^= r3));
        r4 = (r4 | r1) ^ r0;
        this.x0 = r1;
        this.x1 = r4 ^ r2 & (r3 ^= (r0 &= r1));
        this.x2 = ~((r0 | r3) ^ r2);
        this.x3 = r3;
    }

    private void sbox5(int r0, int r1, int r2, int r3) {
        r0 ^= r1;
        int r4 = r1 ^= r3;
        r1 &= r0;
        r2 |= r4;
        r4 ^= r3;
        r3 = r3 & (r1 ^= (r2 ^= (r3 ^= 0xFFFFFFFF))) ^ r0;
        r4 = r4 ^ r1 ^ r2;
        this.x0 = r1;
        this.x1 = r3;
        this.x2 = r0 & r3 ^ r4;
        this.x3 = ~(r2 ^ r0) ^ (r4 | r3);
    }

    private void sbox6(int r0, int r1, int r2, int r3) {
        int r4 = r3;
        r3 = r3 & r0 ^ (r2 ^= 0xFFFFFFFF);
        r2 = (r2 | r4) ^ (r0 ^= r4);
        r4 ^= (r0 |= (r1 ^= r3));
        r0 = (r0 | r3) ^ (r2 ^= r1);
        r4 = r4 ^ r3 ^ r0;
        this.x0 = r0;
        this.x1 = r1;
        this.x2 = r4;
        this.x3 = r2 & r4 ^ ~r3;
    }

    private void sbox7(int r0, int r1, int r2, int r3) {
        int r4 = r1;
        r1 = (r1 | r2) ^ r3;
        r4 ^= r2;
        r3 = (r3 | r4) & r0;
        r4 ^= (r2 ^= r1);
        r3 ^= r1;
        r1 = (r1 | r4) ^ r0;
        r0 = (r0 | r4) ^ r2;
        this.x0 = r4 ^ (~(r2 ^= (r1 ^= r4)) | r0);
        this.x1 = r3;
        this.x2 = r1 & r0 ^ r4;
        this.x3 = r0;
    }

    private class Key
    implements Cloneable {
        int k0;
        int k1;
        int k2;
        int k3;
        int k4;
        int k5;
        int k6;
        int k7;
        int k8;
        int k9;
        int k10;
        int k11;
        int k12;
        int k13;
        int k14;
        int k15;
        int k16;
        int k17;
        int k18;
        int k19;
        int k20;
        int k21;
        int k22;
        int k23;
        int k24;
        int k25;
        int k26;
        int k27;
        int k28;
        int k29;
        int k30;
        int k31;
        int k32;
        int k33;
        int k34;
        int k35;
        int k36;
        int k37;
        int k38;
        int k39;
        int k40;
        int k41;
        int k42;
        int k43;
        int k44;
        int k45;
        int k46;
        int k47;
        int k48;
        int k49;
        int k50;
        int k51;
        int k52;
        int k53;
        int k54;
        int k55;
        int k56;
        int k57;
        int k58;
        int k59;
        int k60;
        int k61;
        int k62;
        int k63;
        int k64;
        int k65;
        int k66;
        int k67;
        int k68;
        int k69;
        int k70;
        int k71;
        int k72;
        int k73;
        int k74;
        int k75;
        int k76;
        int k77;
        int k78;
        int k79;
        int k80;
        int k81;
        int k82;
        int k83;
        int k84;
        int k85;
        int k86;
        int k87;
        int k88;
        int k89;
        int k90;
        int k91;
        int k92;
        int k93;
        int k94;
        int k95;
        int k96;
        int k97;
        int k98;
        int k99;
        int k100;
        int k101;
        int k102;
        int k103;
        int k104;
        int k105;
        int k106;
        int k107;
        int k108;
        int k109;
        int k110;
        int k111;
        int k112;
        int k113;
        int k114;
        int k115;
        int k116;
        int k117;
        int k118;
        int k119;
        int k120;
        int k121;
        int k122;
        int k123;
        int k124;
        int k125;
        int k126;
        int k127;
        int k128;
        int k129;
        int k130;
        int k131;

        Key() {
        }

        private Key(Key that) {
            this.k0 = that.k0;
            this.k1 = that.k1;
            this.k2 = that.k2;
            this.k3 = that.k3;
            this.k4 = that.k4;
            this.k5 = that.k5;
            this.k6 = that.k6;
            this.k7 = that.k7;
            this.k8 = that.k8;
            this.k9 = that.k9;
            this.k10 = that.k10;
            this.k11 = that.k11;
            this.k12 = that.k12;
            this.k13 = that.k13;
            this.k14 = that.k14;
            this.k15 = that.k15;
            this.k16 = that.k16;
            this.k17 = that.k17;
            this.k18 = that.k18;
            this.k19 = that.k19;
            this.k20 = that.k20;
            this.k21 = that.k21;
            this.k22 = that.k22;
            this.k23 = that.k23;
            this.k24 = that.k24;
            this.k25 = that.k25;
            this.k26 = that.k26;
            this.k27 = that.k27;
            this.k28 = that.k28;
            this.k29 = that.k29;
            this.k30 = that.k30;
            this.k31 = that.k31;
            this.k32 = that.k32;
            this.k33 = that.k33;
            this.k34 = that.k34;
            this.k35 = that.k35;
            this.k36 = that.k36;
            this.k37 = that.k37;
            this.k38 = that.k38;
            this.k39 = that.k39;
            this.k40 = that.k40;
            this.k41 = that.k41;
            this.k42 = that.k42;
            this.k43 = that.k43;
            this.k44 = that.k44;
            this.k45 = that.k45;
            this.k46 = that.k46;
            this.k47 = that.k47;
            this.k48 = that.k48;
            this.k49 = that.k49;
            this.k50 = that.k50;
            this.k51 = that.k51;
            this.k52 = that.k52;
            this.k53 = that.k53;
            this.k54 = that.k54;
            this.k55 = that.k55;
            this.k56 = that.k56;
            this.k57 = that.k57;
            this.k58 = that.k58;
            this.k59 = that.k59;
            this.k60 = that.k60;
            this.k61 = that.k61;
            this.k62 = that.k62;
            this.k63 = that.k63;
            this.k64 = that.k64;
            this.k65 = that.k65;
            this.k66 = that.k66;
            this.k67 = that.k67;
            this.k68 = that.k68;
            this.k69 = that.k69;
            this.k70 = that.k70;
            this.k71 = that.k71;
            this.k72 = that.k72;
            this.k73 = that.k73;
            this.k74 = that.k74;
            this.k75 = that.k75;
            this.k76 = that.k76;
            this.k77 = that.k77;
            this.k78 = that.k78;
            this.k79 = that.k79;
            this.k80 = that.k80;
            this.k81 = that.k81;
            this.k82 = that.k82;
            this.k83 = that.k83;
            this.k84 = that.k84;
            this.k85 = that.k85;
            this.k86 = that.k86;
            this.k87 = that.k87;
            this.k88 = that.k88;
            this.k89 = that.k89;
            this.k90 = that.k90;
            this.k91 = that.k91;
            this.k92 = that.k92;
            this.k93 = that.k93;
            this.k94 = that.k94;
            this.k95 = that.k95;
            this.k96 = that.k96;
            this.k97 = that.k97;
            this.k98 = that.k98;
            this.k99 = that.k99;
            this.k100 = that.k100;
            this.k101 = that.k101;
            this.k102 = that.k102;
            this.k103 = that.k103;
            this.k104 = that.k104;
            this.k105 = that.k105;
            this.k106 = that.k106;
            this.k107 = that.k107;
            this.k108 = that.k108;
            this.k109 = that.k109;
            this.k110 = that.k110;
            this.k111 = that.k111;
            this.k112 = that.k112;
            this.k113 = that.k113;
            this.k114 = that.k114;
            this.k115 = that.k115;
            this.k116 = that.k116;
            this.k117 = that.k117;
            this.k118 = that.k118;
            this.k119 = that.k119;
            this.k120 = that.k120;
            this.k121 = that.k121;
            this.k122 = that.k122;
            this.k123 = that.k123;
            this.k124 = that.k124;
            this.k125 = that.k125;
            this.k126 = that.k126;
            this.k127 = that.k127;
            this.k128 = that.k128;
            this.k129 = that.k129;
            this.k130 = that.k130;
            this.k131 = that.k131;
        }

        public Object clone() {
            return new Key(this);
        }
    }
}

