/*
 * Decompiled with CFR 0.152.
 */
package test.hash;

import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.hash.RipeMD128;
import gnu.crypto.util.Util;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOfRipeMD128
extends TestCase {
    static /* synthetic */ Class class$test$hash$TestOfRipeMD128;

    public TestOfRipeMD128(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestOfRipeMD128.suite());
    }

    public static Test suite() {
        return new TestSuite(class$test$hash$TestOfRipeMD128 == null ? (class$test$hash$TestOfRipeMD128 = TestOfRipeMD128.class$("test.hash.TestOfRipeMD128")) : class$test$hash$TestOfRipeMD128);
    }

    public void testSelfTest() {
        try {
            RipeMD128 algorithm = new RipeMD128();
            Assert.assertTrue((String)"selfTest()", (boolean)algorithm.selfTest());
        }
        catch (Exception x) {
            Assert.fail((String)("selfTest(): " + String.valueOf(x)));
        }
    }

    public void testA() {
        try {
            RipeMD128 algorithm = new RipeMD128();
            algorithm.update("a".getBytes(), 0, 1);
            byte[] md = algorithm.digest();
            String exp = "86BE7AFA339D0FC7CFC785E72F578D33";
            Assert.assertTrue((String)"testA()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testA(): " + String.valueOf(x)));
        }
    }

    public void testABC() {
        try {
            RipeMD128 algorithm = new RipeMD128();
            algorithm.update("abc".getBytes(), 0, 3);
            byte[] md = algorithm.digest();
            String exp = "C14A12199C66E4BA84636B0F69144C77";
            Assert.assertTrue((String)"testABC()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testABC(): " + String.valueOf(x)));
        }
    }

    public void testMessageDigest() {
        try {
            RipeMD128 algorithm = new RipeMD128();
            algorithm.update("message digest".getBytes(), 0, 14);
            byte[] md = algorithm.digest();
            String exp = "9E327B3D6E523062AFC1132D7DF9D1B8";
            Assert.assertTrue((String)"testMessageDigest()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testMessageDigest(): " + String.valueOf(x)));
        }
    }

    public void testAlphabet() {
        try {
            RipeMD128 algorithm = new RipeMD128();
            algorithm.update("abcdefghijklmnopqrstuvwxyz".getBytes(), 0, 26);
            byte[] md = algorithm.digest();
            String exp = "FD2AA607F71DC8F510714922B371834E";
            Assert.assertTrue((String)"testAlphabet()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testAlphabet(): " + String.valueOf(x)));
        }
    }

    public void testCloning() {
        try {
            RipeMD128 algorithm = new RipeMD128();
            algorithm.update("a".getBytes(), 0, 1);
            IMessageDigest clone = (IMessageDigest)algorithm.clone();
            byte[] md = algorithm.digest();
            String exp = "86BE7AFA339D0FC7CFC785E72F578D33";
            Assert.assertTrue((String)"testCloning()", (boolean)exp.equals(Util.toString((byte[])md)));
            clone.update("bc".getBytes(), 0, 2);
            md = clone.digest();
            exp = "C14A12199C66E4BA84636B0F69144C77";
            Assert.assertTrue((String)"testCloning()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testCloning(): " + String.valueOf(x)));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

