/* $Revision: 1.2 $ */
/*
 * "gpgp" Gnome/GTK Front for PGP
 * Copyright (C) 1998  Max Valianskiy
 * Copyright (C) 1999 tftp@netscape.net
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 */
#include "../config.h"
#include "../version.h"

#include <gnome.h>

#include "gpgp.h"
#include "pgman.h"

enum 
{
   GNOME_PGP_ERROR_SIGNAL,
   LAST_SIGNAL
};

static gchar* KeyListTitles[] =
{
    N_("type"),
    N_("date"),
    N_("Key ID"),
    N_("User ID")
};

static int keylist_locale=0;

static void gnome_pgp_keyring_properties_class_init(GnomePgpKeyringPropertiesClass *klass);
static void gnome_pgp_keyring_properties_init(GnomePgpKeyringProperties *ttt);

static gint gnome_pgp_keyring_properties_signals[LAST_SIGNAL] = { 0 };

static void ok_cb (GtkWidget* widget, GnomePgpKeyringProperties* page);

guint gnome_pgp_keyring_properties_get_type()
{
    static guint gnome_pgp_keyring_properties_type = 0;

    if (!gnome_pgp_keyring_properties_type)
    {
        GtkTypeInfo gnome_pgp_keyring_properties_info =
        {
            "GnomePgpKeyringProperties",
            sizeof (GnomePgpKeyringProperties),
            sizeof (GnomePgpKeyringPropertiesClass),
            (GtkClassInitFunc) gnome_pgp_keyring_properties_class_init,
            (GtkObjectInitFunc) gnome_pgp_keyring_properties_init,
            (GtkArgSetFunc) NULL,
            (GtkArgGetFunc) NULL
        };
        gnome_pgp_keyring_properties_type = gtk_type_unique(
            gtk_window_get_type(),
            &gnome_pgp_keyring_properties_info);
    }
    return gnome_pgp_keyring_properties_type;
}

static void gnome_pgp_keyring_properties_class_init(GnomePgpKeyringPropertiesClass *class)
{
    GtkObjectClass *object_class;

    object_class = (GtkObjectClass*) class;
    gnome_pgp_keyring_properties_signals[GNOME_PGP_ERROR_SIGNAL] =
        gtk_signal_new ("error",
                        GTK_RUN_FIRST,
                        object_class->type,
                        GTK_SIGNAL_OFFSET (GnomePgpKeyringPropertiesClass,error),
                        gtk_signal_default_marshaller, GTK_TYPE_NONE, 0);
    gtk_object_class_add_signals (object_class, gnome_pgp_keyring_properties_signals, LAST_SIGNAL);
    class->error = NULL;
}

static void gnome_pgp_keyring_properties_init(GnomePgpKeyringProperties *page)
{
    GtkWidget* box;
    GtkWidget  *label2, *label3, *label4, *label5, *label6, *label7;

    GtkWidget *box2, *box3, *box4, *box5;
 
    /* keylist i18n */
    if (!keylist_locale)
    {
        int i;

        for (i=0; i<4; i++)
            KeyListTitles[i]=gettext(KeyListTitles[i]);
        keylist_locale=1;
    }
 
    gtk_window_set_title(GTK_WINDOW(page),_("Key Properties"));

    box = gtk_vbox_new(FALSE,0);
    gtk_container_add(GTK_CONTAINER(page),box);

    page->title = GTK_LABEL(gtk_label_new(_("no information loaded")));
    gtk_box_pack_start(GTK_BOX(box),GTK_WIDGET(page->title), FALSE, FALSE, GNOME_PAD_SMALL);

    box2=gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(box),box2, FALSE,FALSE, GNOME_PAD_SMALL);

    label2 = gtk_label_new(_("PGP fingerprint"));
    gtk_box_pack_start(GTK_BOX(box2),label2, FALSE,FALSE, GNOME_PAD_SMALL);

    page->finger = GTK_ENTRY(gtk_entry_new_with_max_length(48));
    gtk_entry_set_editable(GTK_ENTRY(page->finger),FALSE);
    gtk_box_pack_start(GTK_BOX(box2),GTK_WIDGET(page->finger), TRUE, TRUE, GNOME_PAD_SMALL);

    box3=gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(box),box3, FALSE,FALSE, GNOME_PAD_SMALL);
 
    label3 = gtk_label_new(_("Bits"));
    gtk_box_pack_start(GTK_BOX(box3),label3, FALSE,FALSE, GNOME_PAD_SMALL);

    page->bits = GTK_ENTRY(gtk_entry_new_with_max_length(10));
    gtk_entry_set_editable(GTK_ENTRY(page->bits),FALSE);
    gtk_box_pack_start(GTK_BOX(box3),GTK_WIDGET(page->bits), FALSE, FALSE, GNOME_PAD_SMALL);

    label4 = gtk_label_new(_("KeyId"));
    gtk_box_pack_start(GTK_BOX(box3),label4, FALSE,FALSE, GNOME_PAD_SMALL);
 
    page->keyid = GTK_ENTRY(gtk_entry_new_with_max_length(12));
    gtk_entry_set_editable(GTK_ENTRY(page->keyid),FALSE);
    gtk_box_pack_start(GTK_BOX(box3),GTK_WIDGET(page->keyid), FALSE, FALSE, GNOME_PAD_SMALL);

    label5 = gtk_label_new(_("Date"));
    gtk_box_pack_start(GTK_BOX(box3),label5, FALSE,FALSE, GNOME_PAD_SMALL);
 
    page->date = GTK_ENTRY(gtk_entry_new_with_max_length(40));
    gtk_entry_set_editable(GTK_ENTRY(page->date),FALSE);
    gtk_box_pack_start(GTK_BOX(box3),GTK_WIDGET(page->date), FALSE, FALSE, GNOME_PAD_SMALL);

    box4=gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(box),box4, FALSE,FALSE, GNOME_PAD_SMALL);
 
    label6 = gtk_label_new(_("Trust"));
    gtk_box_pack_start(GTK_BOX(box4),label6, FALSE,FALSE, GNOME_PAD_SMALL);
 
    page->trust = GTK_ENTRY(gtk_entry_new_with_max_length(20));
    gtk_entry_set_editable(GTK_ENTRY(page->trust),FALSE);
    gtk_box_pack_start(GTK_BOX(box4),GTK_WIDGET(page->trust), FALSE, FALSE, GNOME_PAD_SMALL);
 
    label7 = gtk_label_new(_("Validity"));
    gtk_box_pack_start(GTK_BOX(box4),label7, FALSE,FALSE, GNOME_PAD_SMALL);
 
    page->validity = GTK_ENTRY(gtk_entry_new_with_max_length(15));
    gtk_entry_set_editable(GTK_ENTRY(page->validity),FALSE);
    gtk_box_pack_start(GTK_BOX(box4),GTK_WIDGET(page->validity), FALSE, FALSE, GNOME_PAD_SMALL);

    /* signlist */
    page->signedby=GTK_CLIST(gtk_clist_new_with_titles(4, KeyListTitles));
    gtk_clist_set_selection_mode (GTK_CLIST(page->signedby), GTK_SELECTION_BROWSE);
    /* FIXME! but how ? */
    gtk_widget_set_usize( GTK_WIDGET(page->signedby), 100, 200);
    gtk_clist_set_column_width(GTK_CLIST(page->signedby), 0, 80); 
    gtk_clist_set_column_width(GTK_CLIST(page->signedby), 1, 80); 
    gtk_clist_set_column_width(GTK_CLIST(page->signedby), 2, 120); 
    gtk_box_pack_start(GTK_BOX(box), GTK_WIDGET(page->signedby), TRUE, TRUE, 0); 
 
    /* buttons */
 
    box5=gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(box),box5, FALSE,FALSE, GNOME_PAD_SMALL);

    page->bok=GTK_BUTTON(gnome_stock_button(GNOME_STOCK_BUTTON_OK));
    gtk_signal_connect (GTK_OBJECT (page->bok), "clicked",
                        GTK_SIGNAL_FUNC (ok_cb),
                        page);
    gtk_box_pack_start(GTK_BOX(box5),GTK_WIDGET(page->bok), FALSE, FALSE, GNOME_PAD_SMALL);

    page->bdel=GTK_BUTTON(gtk_button_new_with_label(_("Delete")));
    gtk_box_pack_start(GTK_BOX(box5),GTK_WIDGET(page->bdel), FALSE, FALSE, GNOME_PAD_SMALL);
 
    page->bsign=GTK_BUTTON(gtk_button_new_with_label(_("Sign...")));
    gtk_box_pack_start(GTK_BOX(box5),GTK_WIDGET(page->bsign), FALSE, FALSE, GNOME_PAD_SMALL);

    page->bexport=GTK_BUTTON(gtk_button_new_with_label(_("Export...")));
    gtk_box_pack_start(GTK_BOX(box5),GTK_WIDGET(page->bexport), FALSE, FALSE, GNOME_PAD_SMALL);

    gtk_widget_show_all(box);
 
    page->error_info=NULL;
    page->name=NULL;
    page->userid=NULL;
}

static void list_func(char** elm, void* clist)
{
    if (elm)
        gtk_clist_append(GTK_CLIST(clist),elm);
}

void gnome_pgp_keyring_properties_select(GnomePgpKeyringProperties* page, char* ring, char* userid)
{
    struct key_options options;  

    page->name=ring;
    gtk_label_set(page->title, userid);
    get_key_options(page->name, userid, &options);
    if (pgman_error)
    {
        page->error_info=pgman_error;
        gtk_signal_emit(GTK_OBJECT(page), gnome_pgp_keyring_properties_signals[GNOME_PGP_ERROR_SIGNAL]);
        return;
    }
 
    gtk_entry_set_text(page->bits, options.bits);
    gtk_entry_set_text(page->finger, options.fingerprint);
    gtk_entry_set_text(page->keyid, options.keyid);
    gtk_entry_set_text(page->date, options.date);
  
    gtk_clist_clear( GTK_CLIST(page->signedby) );
  
    g_list_foreach(options.signatures, (GFunc) list_func, page->signedby);
    g_list_free(options.signatures);

    gtk_widget_queue_draw(GTK_WIDGET(page));
}

GtkWidget *gnome_pgp_keyring_properties_new (void)
{
    GnomePgpKeyringProperties* page;

    page = gtk_type_new (gnome_pgp_keyring_properties_get_type ());
    return GTK_WIDGET (page);
}

static void ok_cb(GtkWidget* widget, GnomePgpKeyringProperties* page)
{
    gtk_widget_destroy(GTK_WIDGET(page));
}
