/*
 * gaia - opensource 3D interface to the planet
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "gefetch_internal.h"

/**
 * Internal function to authenticate at Google server
 *
 * Mimics Google Earth's behavior (and uses data actually copypasted
 * from tcpdump) - does two HTTP requests and awaits second one to
 * contain 80 byte session ID. This SID is stored in gefetch handle
 * and used in later requests, giving access to imagery and other data.
 */
gefetch_error gefetch_authenticate(gefetch *handle) {
	gefetch_error result;
	long code;

	/* form url */
	char urlbuf[1024];
	if (snprintf(urlbuf, sizeof(urlbuf), "%s/geauth", handle->url) >= sizeof(urlbuf))
		return GEFETCH_SMALL_BUFFER;

	/* first auth POST */
	unsigned char req1[] = {
		0x00,0x00,0x00,0x00,0x01,0x28,0xc9,0x7d,
		0x7b,0x48,0x1a,0x01,0x42,0x82,0xd8,0xca,
		0x56,0x9a,0xdd,0xf1,0x27,0xa8,0x28,0x2f,
		0x12,0xe2,0x31,0x01,0xfd,
	};

	if ((result = gefetch_do_http_request(handle, METHOD_POST, urlbuf, (void*)req1, sizeof(req1), &code)) != GEFETCH_OK)
		return result;
	       
	if (code != 200)
		return GEFETCH_AUTH_FAILED;

	/* second auth POST, get cookie */
	unsigned char req2[] = {
		0x01,0x00,0x00,0x00,0x01,0x28,0xc9,0x7d,
		0x7b,0x48,0x1a,0x01,0x42,0x82,0xd8,0xca,
		0x56,0x9a,0xdd,0xf1,0x27,0x1e,0x37,0x20,
		0x18,0x2b,0x84,0x9d,0x06,0x9c,0x4f,0x00,
		0x00,0xa5,0x15,0x02,0x78,0x00,0x00,0x02,
		0xfa,0x37,0x4a,0x5d,0x0a,0x23,0x6a,0x53,
		0x2e,
	};

	if ((result = gefetch_do_http_request(handle, METHOD_POST, urlbuf, (void*)req2, sizeof(req2), &code)) != GEFETCH_OK)
		return result;
	       
	if (code != 200)
		return GEFETCH_AUTH_FAILED;

	if (handle->currentsize < 88)
		return GEFETCH_CORRUPT_DATA;

	unsigned char *sid;
       
	if ((sid = (unsigned char*)malloc(81)) == 0)
		return GEFETCH_NOMEM;

	memcpy(sid, &handle->currentdata[8], 80);
	sid[80] = '\0';

	handle->sid = sid;

	return GEFETCH_OK;
}
