/* asshelp.h - Helper functions for Assuan
 *	Copyright (C) 2004, 2007 Free Software Foundation, Inc.
 *
 * This file is part of GnuPG.
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of either
 *
 *   - the GNU Lesser General Public License as published by the Free
 *     Software Foundation; either version 3 of the License, or (at
 *     your option) any later version.
 *
 * or
 *
 *   - the GNU General Public License as published by the Free
 *     Software Foundation; either version 2 of the License, or (at
 *     your option) any later version.
 *
 * or both in parallel, as here.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GNUPG_COMMON_ASSHELP_H
#define GNUPG_COMMON_ASSHELP_H

#include <assuan.h>
#include <gpg-error.h>

#include "session-env.h"

/*-- asshelp.c --*/

void setup_libassuan_logging (unsigned int *debug_var_address);
void set_libassuan_log_cats (unsigned int newcats);


gpg_error_t
send_pinentry_environment (assuan_context_t ctx,
                           gpg_err_source_t errsource,
                           const char *opt_lc_ctype,
                           const char *opt_lc_messages,
                           session_env_t session_env);

/* This function is used by the call-agent.c modules to fire up a new
   agent.  */
gpg_error_t
start_new_gpg_agent (assuan_context_t *r_ctx,
                     gpg_err_source_t errsource,
                     const char *homedir,
                     const char *agent_program,
                     const char *opt_lc_ctype,
                     const char *opt_lc_messages,
                     session_env_t session_env,
                     int verbose, int debug,
                     gpg_error_t (*status_cb)(ctrl_t, int, ...),
                     ctrl_t status_cb_arg);

/* This function is used to connect to the dirmngr.  On some platforms
   the function is able starts a dirmngr process if needed.  */
gpg_error_t
start_new_dirmngr (assuan_context_t *r_ctx,
                   gpg_err_source_t errsource,
                   const char *homedir,
                   const char *dirmngr_program,
                   int verbose, int debug,
                   gpg_error_t (*status_cb)(ctrl_t, int, ...),
                   ctrl_t status_cb_arg);


/*-- asshelp2.c --*/

/* Helper function to print an assuan status line using a printf
   format string.  */
gpg_error_t print_assuan_status (assuan_context_t ctx,
                                 const char *keyword,
                                 const char *format,
                                 ...) JNLIB_GCC_A_PRINTF(3,4);
gpg_error_t vprint_assuan_status (assuan_context_t ctx,
                                  const char *keyword,
                                  const char *format,
                                  va_list arg_ptr) JNLIB_GCC_A_PRINTF(3,0);


#endif /*GNUPG_COMMON_ASSHELP_H*/
