;; $Id: dbl1pl.dsl,v 1.6 1999/07/02 17:22:19 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://nwalsh.com/docbook/dsssl/
;;

;; ----------------------------- Localization -----------------------------

;; Polish localization.

;; If you create a new version of this file, please send it to
;; Norman Walsh, ndw@nwalsh.com

;; The generated text for cross references to elements.  See dblink.dsl
;; for a discussion of how substitution is performed on the %x
;; keywords.
;;

(define (pl-appendix-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Appendix; %n"
      "dodatek %t"))

(define (pl-article-xref-string gi-or-name)
  (string-append %gentext-pl-start-quote%
		 "%t"
		 %gentext-pl-end-quote%))

(define (pl-bibliography-xref-string gi-or-name)
  "%t")

(define (pl-book-xref-string gi-or-name)
  "%t")

(define (pl-chapter-xref-string gi-or-name)
  (if %chapter-autolabel%
      "&Chapter; %n"
      "rozdzia&#179; %t"))

(define (pl-equation-xref-string gi-or-name)
  "&Equation; %n")

(define (pl-example-xref-string gi-or-name)
  "&Example; %n")

(define (pl-figure-xref-string gi-or-name)
  "&Figure; %n")

(define (pl-listitem-xref-string gi-or-name)
  "%n")

(define (pl-part-xref-string gi-or-name)
  "&Part; %n")

(define (pl-preface-xref-string gi-or-name)
  "%t")

(define (pl-procedure-xref-string gi-or-name)
  "&Procedure; %n, %t")

(define (pl-section-xref-string gi-or-name)
  (if %section-autolabel% 
      "&Section; %n" 
      "sekcja %t"))

(define (pl-sect1-xref-string gi-or-name)
  (pl-section-xref-string gi-or-name))

(define (pl-sect2-xref-string gi-or-name)
  (pl-section-xref-string gi-or-name))

(define (pl-sect3-xref-string gi-or-name)
  (pl-section-xref-string gi-or-name))

(define (pl-sect4-xref-string gi-or-name)
  (pl-section-xref-string gi-or-name))

(define (pl-sect5-xref-string gi-or-name)
  (pl-section-xref-string gi-or-name))

(define (pl-step-xref-string gi-or-name)
  "&Step; %n")

(define (pl-table-xref-string gi-or-name)
  "&Table; %n")

(define (pl-default-xref-string gi-or-name)
  (let* ((giname (if (string? gi-or-name) gi-or-name (gi gi-or-name)))
	 (msg    (string-append "[&xrefto; "
				(if giname giname "&nonexistantelement;")
				" &unsupported;]"))
	 (err    (node-list-error msg (current-node))))
    msg))

(define (gentext-pl-xref-strings gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
      ((equal? name (normalize "appendix")) (pl-appendix-xref-string gind))
      ((equal? name (normalize "article"))  (pl-article-xref-string gind))
      ((equal? name (normalize "bibliography")) (pl-bibliography-xref-string gind))
      ((equal? name (normalize "book"))     (pl-book-xref-string gind))
      ((equal? name (normalize "chapter"))  (pl-chapter-xref-string gind))
      ((equal? name (normalize "equation")) (pl-equation-xref-string gind))
      ((equal? name (normalize "example"))  (pl-example-xref-string gind))
      ((equal? name (normalize "figure"))   (pl-figure-xref-string gind))
      ((equal? name (normalize "listitem")) (pl-listitem-xref-string gind))
      ((equal? name (normalize "part"))     (pl-part-xref-string gind))
      ((equal? name (normalize "preface"))  (pl-preface-xref-string gind))
      ((equal? name (normalize "procedure")) (pl-procedure-xref-string gind))
      ((equal? name (normalize "sect1"))    (pl-sect1-xref-string gind))
      ((equal? name (normalize "sect2"))    (pl-sect2-xref-string gind))
      ((equal? name (normalize "sect3"))    (pl-sect3-xref-string gind))
      ((equal? name (normalize "sect4"))    (pl-sect4-xref-string gind))
      ((equal? name (normalize "sect5"))    (pl-sect5-xref-string gind))
      ((equal? name (normalize "step"))     (pl-step-xref-string gind))
      ((equal? name (normalize "table"))    (pl-table-xref-string gind))
      (else (pl-default-xref-string gind)))))

(define (pl-auto-xref-indirect-connector before) 
  (literal " &in; "))

;; Should the TOC come first or last?
;;
(define %generate-pl-toc-in-front% #t)

;; gentext-element-name returns the generated text that should be 
;; used to make reference to the selected element.
;;
(define pl-abstract-name	"&Abstract;")
(define pl-appendix-name	"&Appendix;")
(define pl-article-name	"&Article;")
(define pl-bibliography-name	"&Bibliography;")
(define pl-book-name		"&Book;")
(define pl-calloutlist-name   "")
(define pl-caution-name	"&Caution;")
(define pl-chapter-name	"&Chapter;")
(define pl-copyright-name	"&Copyright;")
(define pl-dedication-name	"&Dedication;")
(define pl-edition-name	"&Edition;")
(define pl-equation-name	"&Equation;")
(define pl-example-name	"&Example;")
(define pl-figure-name	"&Figure;")
(define pl-glossary-name	"&Glossary;")
(define pl-glosssee-name	"&GlossSee;")
(define pl-glossseealso-name	"&GlossSeeAlso;")
(define pl-important-name	"&Important;")
(define pl-index-name		"&Index;")
(define pl-setindex-name	"&SetIndex;")
(define pl-isbn-name		"&ISBN;")
(define pl-legalnotice-name	"")
(define pl-msgaud-name	"&MsgAud;")
(define pl-msglevel-name	"&MsgLevel;")
(define pl-msgorig-name	"&MsgOrig;")
(define pl-note-name		"&Note;")
(define pl-part-name		"&Part;")
(define pl-preface-name	"&Preface;")
(define pl-procedure-name	"&Procedure;")
(define pl-pubdate-name	"&Published;")
(define pl-reference-name	"&Reference;")
(define pl-refname-name	"&RefName;")
(define pl-revhistory-name	"&RevHistory;")
(define pl-revision-name	"&Revision;")
(define pl-sect1-name		"&Section;")
(define pl-sect2-name		"&Section;")
(define pl-sect3-name		"&Section;")
(define pl-sect4-name		"&Section;")
(define pl-sect5-name		"&Section;")
(define pl-simplesect-name	"&Section;")
(define pl-seeie-name		"&See;")
(define pl-seealsoie-name	"&Seealso;")
(define pl-set-name		"&Set;")
(define pl-sidebar-name	"&Sidebar;")
(define pl-step-name		"&step;")
(define pl-table-name		"&Table;")
(define pl-tip-name		"&Tip;")
(define pl-toc-name		"&TableofContents;")
(define pl-warning-name	"&Warning;")

(define (gentext-pl-element-name gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract"))	pl-abstract-name)
     ((equal? name (normalize "appendix"))	pl-appendix-name)
     ((equal? name (normalize "article"))	pl-article-name)
     ((equal? name (normalize "bibliography"))	pl-bibliography-name)
     ((equal? name (normalize "book"))		pl-book-name)
     ((equal? name (normalize "calloutlist"))	pl-calloutlist-name)
     ((equal? name (normalize "caution"))	pl-caution-name)
     ((equal? name (normalize "chapter"))	pl-chapter-name)
     ((equal? name (normalize "copyright"))	pl-copyright-name)
     ((equal? name (normalize "dedication"))	pl-dedication-name)
     ((equal? name (normalize "edition"))	pl-edition-name)
     ((equal? name (normalize "equation"))	pl-equation-name)
     ((equal? name (normalize "example"))	pl-example-name)
     ((equal? name (normalize "figure"))	pl-figure-name)
     ((equal? name (normalize "glossary"))	pl-glossary-name)
     ((equal? name (normalize "glosssee"))	pl-glosssee-name)
     ((equal? name (normalize "glossseealso"))	pl-glossseealso-name)
     ((equal? name (normalize "important"))	pl-important-name)
     ((equal? name (normalize "index"))		pl-index-name)
     ((equal? name (normalize "setindex"))	pl-setindex-name)
     ((equal? name (normalize "isbn"))		pl-isbn-name)
     ((equal? name (normalize "legalnotice"))	pl-legalnotice-name)
     ((equal? name (normalize "msgaud"))	pl-msgaud-name)
     ((equal? name (normalize "msglevel"))	pl-msglevel-name)
     ((equal? name (normalize "msgorig"))	pl-msgorig-name)
     ((equal? name (normalize "note"))		pl-note-name)
     ((equal? name (normalize "part"))		pl-part-name)
     ((equal? name (normalize "preface"))	pl-preface-name)
     ((equal? name (normalize "procedure"))	pl-procedure-name)
     ((equal? name (normalize "pubdate"))	pl-pubdate-name)
     ((equal? name (normalize "reference"))	pl-reference-name)
     ((equal? name (normalize "refname"))	pl-refname-name)
     ((equal? name (normalize "revhistory"))	pl-revhistory-name)
     ((equal? name (normalize "revision"))	pl-revision-name)
     ((equal? name (normalize "sect1"))		pl-sect1-name)
     ((equal? name (normalize "sect2"))		pl-sect2-name)
     ((equal? name (normalize "sect3"))		pl-sect3-name)
     ((equal? name (normalize "sect4"))		pl-sect4-name)
     ((equal? name (normalize "sect5"))		pl-sect5-name)
     ((equal? name (normalize "simplesect"))	pl-simplesect-name)
     ((equal? name (normalize "seeie"))		pl-seeie-name)
     ((equal? name (normalize "seealsoie"))	pl-seealsoie-name)
     ((equal? name (normalize "set"))		pl-set-name)
     ((equal? name (normalize "sidebar"))	pl-sidebar-name)
     ((equal? name (normalize "step"))		pl-step-name)
     ((equal? name (normalize "table"))		pl-table-name)
     ((equal? name (normalize "tip"))		pl-tip-name)
     ((equal? name (normalize "toc"))		pl-toc-name)
     ((equal? name (normalize "warning"))	pl-warning-name)
     (else (let* ((msg (string-append "&unexpectedelementname;: " name))
		  (err (node-list-error msg (current-node))))
	     msg)))))

;; gentext-element-name-space returns gentext-element-name with a 
;; trailing space, if gentext-element-name isn't "".
;;
(define (gentext-pl-element-name-space giname)
  (string-with-space (gentext-element-name giname)))

;; gentext-intra-label-sep returns the seperator to be inserted
;; between multiple occurances of a label (or parts of a label)
;; for the specified element.  Most of these are for enumerated
;; labels like "Figure 2-4", but this function is used elsewhere
;; (e.g. REFNAME) with a little abuse.
;;

(define pl-equation-intra-label-sep "-")
(define pl-example-intra-label-sep "-")
(define pl-figure-intra-label-sep "-")
(define pl-procedure-intra-label-sep ".")
(define pl-refentry-intra-label-sep ".")
(define pl-reference-intra-label-sep ".")
(define pl-refname-intra-label-sep ", ")
(define pl-refsect1-intra-label-sep ".")
(define pl-refsect2-intra-label-sep ".")
(define pl-refsect3-intra-label-sep ".")
(define pl-sect1-intra-label-sep ".")
(define pl-sect2-intra-label-sep ".")
(define pl-sect3-intra-label-sep ".")
(define pl-sect4-intra-label-sep ".")
(define pl-sect5-intra-label-sep ".")
(define pl-step-intra-label-sep ".")
(define pl-table-intra-label-sep "-")
(define pl-_pagenumber-intra-label-sep "-")
(define pl-default-intra-label-sep "")

(define (gentext-pl-intra-label-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "equation"))	pl-equation-intra-label-sep)
     ((equal? name (normalize "example"))	pl-example-intra-label-sep)
     ((equal? name (normalize "figure"))	pl-figure-intra-label-sep)
     ((equal? name (normalize "procedure"))	pl-procedure-intra-label-sep)
     ((equal? name (normalize "refentry"))	pl-refentry-intra-label-sep)
     ((equal? name (normalize "reference"))	pl-reference-intra-label-sep)
     ((equal? name (normalize "refname"))	pl-refname-intra-label-sep)
     ((equal? name (normalize "refsect1"))	pl-refsect1-intra-label-sep)
     ((equal? name (normalize "refsect2"))	pl-refsect2-intra-label-sep)
     ((equal? name (normalize "refsect3"))	pl-refsect3-intra-label-sep)
     ((equal? name (normalize "sect1"))		pl-sect1-intra-label-sep)
     ((equal? name (normalize "sect2"))		pl-sect2-intra-label-sep)
     ((equal? name (normalize "sect3"))		pl-sect3-intra-label-sep)
     ((equal? name (normalize "sect4"))		pl-sect4-intra-label-sep)
     ((equal? name (normalize "sect5"))		pl-sect5-intra-label-sep)
     ((equal? name (normalize "step"))		pl-step-intra-label-sep)
     ((equal? name (normalize "table"))		pl-table-intra-label-sep)
     ((equal? name (normalize "_pagenumber"))	pl-_pagenumber-intra-label-sep)
     (else pl-default-intra-label-sep))))

;; gentext-label-title-sep returns the seperator to be inserted
;; between a label and the text following the label for the
;; specified element.  Most of these are for use between
;; enumerated labels and titles like "1. Chapter One Title", but
;; this function is used elsewhere (e.g. NOTE) with a little
;; abuse.
;;

(define pl-abstract-label-title-sep ": ")
(define pl-appendix-label-title-sep ". ")
(define pl-caution-label-title-sep "")
(define pl-chapter-label-title-sep ". ")
(define pl-equation-label-title-sep ". ")
(define pl-example-label-title-sep ". ")
(define pl-figure-label-title-sep ". ")
(define pl-footnote-label-title-sep ". ")
(define pl-glosssee-label-title-sep ": ")
(define pl-glossseealso-label-title-sep ": ")
(define pl-important-label-title-sep ": ")
(define pl-note-label-title-sep ": ")
(define pl-orderedlist-label-title-sep ". ")
(define pl-part-label-title-sep ". ")
(define pl-procedure-label-title-sep ". ")
(define pl-prefix-label-title-sep ". ")
(define pl-refentry-label-title-sep "")
(define pl-reference-label-title-sep ". ")
(define pl-refsect1-label-title-sep ". ")
(define pl-refsect2-label-title-sep ". ")
(define pl-refsect3-label-title-sep ". ")
(define pl-sect1-label-title-sep ". ")
(define pl-sect2-label-title-sep ". ")
(define pl-sect3-label-title-sep ". ")
(define pl-sect4-label-title-sep ". ")
(define pl-sect5-label-title-sep ". ")
(define pl-seeie-label-title-sep " ")
(define pl-seealsoie-label-title-sep " ")
(define pl-step-label-title-sep ". ")
(define pl-table-label-title-sep ". ")
(define pl-tip-label-title-sep ": ")
(define pl-warning-label-title-sep "")
(define pl-default-label-title-sep "")

(define (gentext-pl-label-title-sep gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "abstract")) pl-abstract-label-title-sep)
     ((equal? name (normalize "appendix")) pl-appendix-label-title-sep)
     ((equal? name (normalize "caution")) pl-caution-label-title-sep)
     ((equal? name (normalize "chapter")) pl-chapter-label-title-sep)
     ((equal? name (normalize "equation")) pl-equation-label-title-sep)
     ((equal? name (normalize "example")) pl-example-label-title-sep)
     ((equal? name (normalize "figure")) pl-figure-label-title-sep)
     ((equal? name (normalize "footnote")) pl-footnote-label-title-sep)
     ((equal? name (normalize "glosssee")) pl-glosssee-label-title-sep)
     ((equal? name (normalize "glossseealso")) pl-glossseealso-label-title-sep)
     ((equal? name (normalize "important")) pl-important-label-title-sep)
     ((equal? name (normalize "note")) pl-note-label-title-sep)
     ((equal? name (normalize "orderedlist")) pl-orderedlist-label-title-sep)
     ((equal? name (normalize "part")) pl-part-label-title-sep)
     ((equal? name (normalize "procedure")) pl-procedure-label-title-sep)
     ((equal? name (normalize "prefix")) pl-prefix-label-title-sep)
     ((equal? name (normalize "refentry")) pl-refentry-label-title-sep)
     ((equal? name (normalize "reference")) pl-reference-label-title-sep)
     ((equal? name (normalize "refsect1")) pl-refsect1-label-title-sep)
     ((equal? name (normalize "refsect2")) pl-refsect2-label-title-sep)
     ((equal? name (normalize "refsect3")) pl-refsect3-label-title-sep)
     ((equal? name (normalize "sect1")) pl-sect1-label-title-sep)
     ((equal? name (normalize "sect2")) pl-sect2-label-title-sep)
     ((equal? name (normalize "sect3")) pl-sect3-label-title-sep)
     ((equal? name (normalize "sect4")) pl-sect4-label-title-sep)
     ((equal? name (normalize "sect5")) pl-sect5-label-title-sep)
     ((equal? name (normalize "seeie")) pl-seeie-label-title-sep)
     ((equal? name (normalize "seealsoie")) pl-seealsoie-label-title-sep)
     ((equal? name (normalize "step")) pl-step-label-title-sep)
     ((equal? name (normalize "table")) pl-table-label-title-sep)
     ((equal? name (normalize "tip")) pl-tip-label-title-sep)
     ((equal? name (normalize "warning")) pl-warning-label-title-sep)
     (else pl-default-label-title-sep))))

(define (pl-set-label-number-format gind) "1")
(define (pl-book-label-number-format gind) "1")
(define (pl-prefix-label-number-format gind) "1")
(define (pl-part-label-number-format gind) "I")
(define (pl-chapter-label-number-format gind) "1")
(define (pl-appendix-label-number-format gind) "A")
(define (pl-reference-label-number-format gind) "I")
(define (pl-example-label-number-format gind) "1")
(define (pl-figure-label-number-format gind) "1")
(define (pl-table-label-number-format gind) "1")
(define (pl-procedure-label-number-format gind) "1")
(define (pl-step-label-number-format gind) "1")
(define (pl-refsect1-label-number-format gind) "1")
(define (pl-refsect2-label-number-format gind) "1")
(define (pl-refsect3-label-number-format gind) "1")
(define (pl-sect1-label-number-format gind) "1")
(define (pl-sect2-label-number-format gind) "1")
(define (pl-sect3-label-number-format gind) "1")
(define (pl-sect4-label-number-format gind) "1")
(define (pl-sect5-label-number-format gind) "1")
(define (pl-default-label-number-format gind) "1")

(define (pl-label-number-format gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond
     ((equal? name (normalize "set")) (pl-set-label-number-format gind))
     ((equal? name (normalize "book")) (pl-book-label-number-format gind))
     ((equal? name (normalize "prefix")) (pl-prefix-label-number-format gind))
     ((equal? name (normalize "part")) (pl-part-label-number-format gind))
     ((equal? name (normalize "chapter")) (pl-chapter-label-number-format gind))
     ((equal? name (normalize "appendix")) (pl-appendix-label-number-format gind))
     ((equal? name (normalize "reference")) (pl-reference-label-number-format gind))
     ((equal? name (normalize "example")) (pl-example-label-number-format gind))
     ((equal? name (normalize "figure")) (pl-figure-label-number-format gind))
     ((equal? name (normalize "table")) (pl-table-label-number-format gind))
     ((equal? name (normalize "procedure")) (pl-procedure-label-number-format gind))
     ((equal? name (normalize "step")) (pl-step-label-number-format gind))
     ((equal? name (normalize "refsect1")) (pl-refsect1-label-number-format gind))
     ((equal? name (normalize "refsect2")) (pl-refsect2-label-number-format gind))
     ((equal? name (normalize "refsect3")) (pl-refsect3-label-number-format gind))
     ((equal? name (normalize "sect1")) (pl-sect1-label-number-format gind))
     ((equal? name (normalize "sect2")) (pl-sect2-label-number-format gind))
     ((equal? name (normalize "sect3")) (pl-sect3-label-number-format gind))
     ((equal? name (normalize "sect4")) (pl-sect4-label-number-format gind))
     ((equal? name (normalize "sect5")) (pl-sect5-label-number-format gind))
     (else (pl-default-label-number-format gind)))))

(define ($lot-title-pl$ gind)
  (let* ((giname (if (string? gind) gind (gi gind)))
	 (name   (normalize giname)))
    (cond ((equal? name (normalize "table"))    "&ListofTables;")
	  ((equal? name (normalize "example"))  "&ListofExamples;")
	  ((equal? name (normalize "figure"))   "&ListofFigures;")
	  ((equal? name (normalize "equation")) "&ListofEquations;")
	  (else (let* ((msg (string-append "&ListofUnknown;: " name))
		       (err (node-list-error msg (current-node))))
		  msg)))))

(define %gentext-pl-start-quote%  (dingbat "ldquo"))

(define %gentext-pl-end-quote%  (dingbat "rdquo"))

(define %gentext-pl-start-nested-quote%  (dingbat "lsquo"))

(define %gentext-pl-end-nested-quote%  (dingbat "rsquo"))

(define %gentext-pl-by% "&by;") ;; e.g. Copyright 1997 "by" A. Nonymous
                           ;; Authored "by" Jane Doe

(define %gentext-pl-edited-by% "&Editedby;")
                           ;; "Edited by" Jane Doe

(define %gentext-pl-page% "")

(define %gentext-pl-and% "&and;")

(define %gentext-pl-bibl-pages% "&Pgs;")

(define %gentext-pl-endnotes% "&Notes;")

(define %gentext-pl-table-endnotes% "&TableNotes;:")

(define %gentext-pl-index-see% "&See;")

(define %gentext-pl-index-seealso% "&SeeAlso;")
