#!/usr/bin/bash

#
# Cygwin SWIG build script
#

# Show all the steps taken:
set -x

# Go to the directory above this one, if not already there:
cd ${PWD%/CYGWIN}

#
# Determine version information from the directory name and verify that it is
# valid. The name should be of this form (e.g., "swig-1.3.13-1"):
#
#   swig-<SWIG VERSION NUMBER>-<CYGWIN SWIG BUILD NUMBER>
#
# <CYGWIN SWIG BUILD NUMBER> cannot contain any dashes, although dashes in
# <SWIG VERSION NUMBER> are supported if present.
#
dist=${PWD##*/}
tool=${dist%%-*}
pkg=${dist%-*}
pkg_version=${pkg#*-}
build_number=${dist##*-}
[[ $tool == swig ]] || exit 1
[[ $pkg_version != '' ]] || exit 1
[[ $build_number != '' ]] || exit 1
[[ $tool-$pkg_version-$build_number == $dist ]] || exit 1

# Build a temporary destination directory:
DESTDIR=$(mktemp -d) || exit 1

#
# This assumes that autogen.sh was already run, as it is in the 1.3.11 dist.
#

# Configure, specifying all rules from the Cygwin Package Contributor's Guide
# in case they are ever used:
./configure \
   --prefix=/usr \
   --sysconfdir=/etc \
   --libexecdir='$(sbindir)' \
   --localstatedir=/var \
   --datadir='$(prefix)/share'

# Build the package and strip any executables:
make
find . -name '*.exe' -o -name '*.dll' | xargs strip

# Note that some of the example tests may fail at any given point in time,
# especially for Cygwin. The various "make check" commands can be run now,
# though...

# Install the package into the temporary directory:
make DESTDIR=$DESTDIR install

# Install the extra documentation:
mkdir -p $DESTDIR/usr/doc/Cygwin
cp CYGWIN/README $DESTDIR/usr/doc/Cygwin/$dist.README
mkdir -p $DESTDIR/usr/doc/$pkg
cp CYGWIN/README $DESTDIR/usr/doc/$pkg/$dist.README
cp {ANNOUNCE,CHANGES,FUTURE,INSTALL,LICENSE,NEW,README,TODO} $DESTDIR/usr/doc/$pkg
cp -r Doc $DESTDIR/usr/doc/$pkg

tar -C $DESTDIR -jcf $dist.tar.bz2 usr

rm -rf $DESTDIR
