#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e "s/${PKG}-//" -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e "s/${PKG}-${VER}-//"`
export FULLPKG=${PKG}-${VER}-${REL}
export  suite3270PKG=suite3270
export  suite3270FULLPKG=${suite3270PKG}-${VER}-${REL}
export src_orig_pkg_name=${PKG}-${VER}.tar.bz2
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
host=i686-pc-cygwin
target=i686-pc-cygwin
prefix=/usr/X11R6
pnoslash=`echo $prefix | sed -e 's#^/##'`
sysconfdir=/etc
snoslash=`echo $sysconfdir | sed -e 's#^/##'`
datadir=${prefix}/share
infodir=${datadir}/info
mandir=${datadir}/man
MY_CFLAGS=
MY_LDFLAGS=

mkdirs() {
  (cd ${topdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} )
}
prepcp() {
  (cp ${srcdir}/mkversion.sh ${objdir} && \
   cp ${srcdir}/version.txt ${objdir} && \
   cp ${srcdir}/*.man ${objdir} ) 
# NB: copy *.man to .build because imake rules for doing manpages are screwed!
}
prep() {
  (mkdirs && \
  cd ${topdir} && \
  if [ -f ${src_patch} ] ; then \
    patch -p0 < ${src_patch} ; \
  fi && \
  prepcp )
}
conf() {
  (cd ${objdir} && \
  ${srcdir}/configure --host=${host} --target=${target} \
  --srcdir=${srcdir} --prefix=${prefix} \
  --sysconfdir=${sysconfdir} \
  --localstatedir=/var \
  --infodir=${infodir} \
  --mandir=${mandir} \
  --enable-symlinks \
  --with-install-prefix=${instdir} )
}
build() {
# (cd ${objdir} && \
# CFLAGS="${MY_CFLAGS}" LDFLAGS="${MY_LDFLAGS}" make ) 
  (cd ${objdir} && \
  make all ) 
}
check() {
  (cd ${objdir} && \
  make check | tee ${checkfile} 2>&1 )
}
clean() {
  (cd ${objdir} && \
  make clean )
}
install() {
  (cd ${objdir} && \
  for dirn in \
    ${prefix}/bin ${datadir} \
    ${datadir}/doc/Cygwin ${datadir}/doc/${PKG}-${VER} \
    ${sysconfdir}/postinstall ; do \
    if [ ! -d ${instdir}${dirn} ]; then \
      mkdir -p ${instdir}${dirn} ; \
    fi ; \
  done && \
  cd ${objdir} && \
  make install install.man DESTDIR=${instdir} && \
  for f in \
    ${instdir}${infodir}/dir \
    ${instdir}${prefix}/lib/X11/fonts/misc/fonts.dir ; do \
    [ -f ${f} ] && rm -f ${f} ; \
  done && \
  if [ -d ${srcdir}/html ]; then \
    [ -d ${instdir}/${datadir}/doc/${PKG}-${VER}/html ] && \
    rm -rf ${instdir}/${datadir}/doc/${PKG}-${VER}/html && \
    cp -a ${srcdir}/html ${instdir}/${datadir}/doc/${PKG}-${VER} ; \
  fi && \
  templist=""; \
  for f in ${srcdir}/README ${srcdir}/INSTALL ${srcdir}/LICENSE \
           ${srcdir}/META-FAQ ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -c -m 644 $templist \
         ${instdir}${datadir}/doc/${PKG}-${VER} ; \
  fi && \
  /usr/bin/install -c -m 755 ${srcdir}/CYGWIN-PATCHES/postinstall.sh \
    ${instdir}${sysconfdir}/postinstall/${PKG}.sh && \
  echo "Invoking ${topdir}/${suite3270FULLPKG}.sh promote ${instdir}" && \
  ${topdir}/${suite3270FULLPKG}.sh promote ${instdir} && \
  echo "Generating ${PKG}-${VER}.README" && \
  /usr/bin/install -c -m 644 ${srcdir}/CYGWIN-PATCHES/${PKG}.README \
    ${instdir}${datadir}/doc/Cygwin/${PKG}-${VER}.README && \
  (cd ${instdir} && \
  (find . -type f | sort | sed 's/^\./  /' > /tmp/.inst.lis) && \
  sed -f ${srcdir}/CYGWIN-PATCHES/${PKG}.README.sed < ${srcdir}/CYGWIN-PATCHES/${PKG}.README > /tmp/.inst.README && \
  /usr/bin/install -c -m 644 /tmp/.inst.README ${instdir}${datadir}/doc/Cygwin/${PKG}-${VER}.README && \
  rm -f /tmp/.inst.lis /tmp/.inst.README ) )
}
mkpatch() {
  (cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${PKG}-${VER}-orig ${PKG}-${VER} > \
    ${srcinstdir}/${src_patch_name} )
}
strip() {
  (cd ${instdir}
  find . -name "*.exe" | xargs strip > /dev/null 2>&1
  find . -name "*.dll" | xargs strip > /dev/null 2>&1
  return 0 )
}
pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} * )
}
spkg() {
  ( \
  echo "Do spkg from main" \
  )
}
finish() {
  rm -rf ${srcdir}
}
case $1 in
  prep)	prep ; STATUS=$? ;;
  mkdirs)	mkdirs ; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  mkpatch) mkpatch ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && strip && \
     pkg && spkg && finish ; STATUS=$? ;;
  *) echo "Error: bad arguments" ; STATUS=1 ;;
esac
exit ${STATUS}
