#! /bin/bash

# $Id: build.sh,v 1.2 2003/09/17 12:14:39 jt Exp $

# vim: tabstop=4

# parse arguments
version=$1
port=$2

# constants
pkg=proftpd

# file variables
ConfigFile=proftpd.conf

# dir variables
Prefix=/usr
TmpDir=/tmp/$pkg.$$
InstallPrefix=$TmpDir$Prefix

EtcDir=$TmpDir/etc
DataDir=$InstallPrefix/share
ManDir=$DataDir/man
PostInstallDir=$EtcDir/postinstall
DocDir=$DataDir/doc/$pkg-$version
CygDocDir=$DataDir/doc/Cygwin
PatchDir=CYGWIN-PATCHES
SrcDocDir=doc

# configure
configure --prefix=/usr --sysconfdir=/etc --libexecdir=/usr/sbin \
	--localstatedir=/var --datadir=/usr/share --mandir=/usr/share/man \
	--infodir=/usr/share/info

# make
make

# make install
make DESTDIR=$TmpDir install

# rename proftpd configuration file
mv $EtcDir/$ConfigFile $EtcDir/$ConfigFile.default

# edit proftpd configuration file as appropriate for Cygwin
sed -e 's/^User/#&/' -e 's/^Group/#&/' -e 's/nobody$/SYSTEM/' \
	-e 's/nogroup$/Administrators/' $EtcDir/$ConfigFile.default \
	>$EtcDir/$ConfigFile.tmp
mv $EtcDir/$ConfigFile.tmp $EtcDir/$ConfigFile.default

# copy Cygwin proftpd postinstall script
mkdir -p $PostInstallDir
cp $PatchDir/$pkg.sh $PostInstallDir

# create man cat dirs
mkdir $ManDir/{cat1,cat5,cat8}

# copy Cygwin proftpd README file
mkdir -p $CygDocDir
cp $PatchDir/README $CygDocDir/$pkg-$version.README

# create doc dir
mkdir -p $DocDir

# copy proftpd top-level README files
TopFiles=(ChangeLog COPYING CREDITS INSTALL NEWS README*)
cp ${TopFiles[*]} $DocDir

# copy proftpd doc tree
(cd $SrcDocDir; find | cpio -pdmv $DocDir)

# copy proftpd sample configurations
find sample-configurations | cpio -pdmv $DocDir

# create package
tar -C $TmpDir -cjf $pkg-$version-$port.tar.bz2 usr etc

# remove temporary directory
rm -fr $TmpDir
