#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e 's/^[^\-]*\-//' -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e 's/^[^\-]*\-[^\-]*\-//'`
# Note that ncurses generates THREE different binary packages:
# 1) ncurses          -- executables and documentation
# 1) libncurses-devel -- includes static libs, import libs, header files
# 2) libncurses7      -- includes only the DLLs
# 3) terminfo -- not the REAL cygwin terminfo package. For cygwin, the 
#                terminfo database has been forked for easier updating.
export PKG2=lib${PKG}7
export PKG3=lib${PKG}-devel
export PKG4=${PKG}-demo
export PKG5=terminfo-temp
export FULLPKG=${PKG}-${VER}-${REL}
export FULLPKG2=${PKG2}-${VER}-${REL}
export FULLPKG3=${PKG3}-${VER}-${REL}
export FULLPKG4=${PKG4}-${VER}-${REL}
export FULLPKG5=${PKG5}

export src_orig_pkg_name=${PKG}-${VER}.tar.gz
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2
export bin_pkg_name2=${FULLPKG2}.tar.bz2
export bin_pkg_name3=${FULLPKG3}.tar.bz2
export bin_pkg_name4=${FULLPKG4}.tar.bz2
export bin_pkg_name5=${FULLPKG5}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export bin_pkg2=${topdir}/${bin_pkg_name2}
export bin_pkg3=${topdir}/${bin_pkg_name3}
export bin_pkg4=${topdir}/${bin_pkg_name4}
export bin_pkg5=${topdir}/${bin_pkg_name5}
export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
# run on 
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin
prefix=/usr
pnoslash=`echo $prefix | sed -e 's#^/##'`
sysconfdir=/etc
snoslash=`echo $sysconfdir | sed -e 's#^/##'`
includedir=${prefix}/include/ncurses
terminfodir=${prefix}/share/terminfo
CFLAGS="-O2"

mkdirs() {
  (cd ${topdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} )
}

prep() {
  (cd ${topdir} && \
  tar xvzf ${src_orig_pkg} && \
  cd ${topdir} && \
  patch -p0 < ${src_patch} 
  && mkdirs
)}

conf() {
  (cd ${objdir} && \
  cf_cv_abi_version=7 ${srcdir}/configure \
  --srcdir=${srcdir} --prefix=${prefix} \
  --exec-prefix=${prefix} --sysconfdir=${sysconfdir} \
  --libdir=${prefix}/lib --includedir=${includedir} \
  --with-shared --with-normal --without-debug \
  --enable-symlinks --enable-sigwinch --enable-colorfgbg \
  --enable-tcap-names --with-manpage-symlinks \
  --disable-termcap --enable-broken-linker \
  --with-default-terminfo-dir=${terminfodir} \
  --with-install-prefix=${instdir} \
  --enable-echo
)}

build() {
  (cd ${objdir} && \
  make CFLAGS=${CFLAGS}
)}

check() {
  (cd ${objdir} && \
  make check | tee ${checkfile} 2>&1
)}

clean() {
  (cd ${objdir} && \
  make clean && \
  rm -f config.cache
)}

instextra1 () {
  (cd ${objdir} && \
  mkdir -p ${instdir}${prefix}/bin/ncurses-test-dll && \
  /usr/bin/install -m 755 -s test/*.exe ${instdir}${prefix}/bin/ncurses-test-dll && \
  /usr/bin/install -m 755 -s c++/demo.exe ${instdir}${prefix}/bin/ncurses-test-dll
)}

install () {
  (cd ${objdir} && \
  make install INSTALL=install && \
  (cd ${instdir}${prefix}/bin ; chmod +x *.dll) && \
  instextra1 && \
  instextra2
)}

instextra2 () {
  (cd ${objdir} && \
  if [ -f ${instdir}${prefix}/info/dir ] ; then \
    rm ${instdir}${prefix}/info/dir ; \
  fi && \
  for dirn in ${prefix}/doc/${PKG}-${VER} ${prefix}/doc/Cygwin \
    ${sysconfdir}/postinstall ; do \
    if [ ! -d ${instdir}${dirn} ] ; then \
      mkdir -p ${instdir}${dirn} ; \
    fi ;\
  done && \
  templist=""; \
  for f in ${srcdir}/README ${srcdir}/NEWS ${srcdir}/ANNOUNCE \
  ${srcdir}/COPYING ${srcdir}/TO-DO ${srcdir}/doc/html/index.html \
  ${srcdir}/doc/html/ncurses-intro.html ${srcdir}/doc/html/announce.html \
  ${srcdir}/doc/html/hackguide.html ${srcdir}/doc/html/Ada95.html; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
	 ${instdir}${prefix}/doc/${PKG}-${VER} ;
  fi && \
  cat ${srcdir}/CYGWIN-PATCHES/${PKG}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
    ${instdir}${prefix}/doc/Cygwin/${PKG}-${VER}.README && \
  cat ${srcdir}/CYGWIN-PATCHES/${PKG3}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
    ${instdir}${prefix}/doc/Cygwin/${PKG3}-${VER}.README 
  cat ${srcdir}/CYGWIN-PATCHES/${PKG4}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
    ${instdir}${prefix}/doc/Cygwin/${PKG4}-${VER}.README && \
  mv ${instdir}${includedir}/termcap.h ${instdir}${includedir}/termcapn.h && \
  for fn in ${instdir}${includedir}/ncurses.h ${instdir}${prefix}/lib/terminfo \
    ${instdir}${prefix}/lib/libcurses.a ${instdir}${prefix}/lib/libcurses.dll.a \
    ${instdir}${prefix}/info/dir ; do \
    if [ -e $fn ] ; then \
      rm -f $fn ;\
    fi ;\
  done && \
  /usr/bin/install -m 755 ${srcdir}/CYGWIN-PATCHES/${PKG3}.postinstall \
    ${instdir}${sysconfdir}/postinstall/${PKG3}.sh
)}

mkpatch() {
  (cd ${srcdir} && \
  tar xvzf ${src_orig_pkg} && \
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${PKG}-${VER}-orig ${PKG}-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}-${VER}-orig
)}

strip() {
  (cd ${instdir} && \
  find . -name "*.exe" | xargs strip > /dev/null 2>&1 ;
  find . -name "*.dll" | xargs strip > /dev/null 2>&1
)}

pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} usr/ \
    --exclude="${pnoslash}/share/terminfo" --exclude="${pnoslash}/include" \
    --exclude="${pnoslash}/bin/ncurses-test-dll" --exclude="${pnoslash}/lib" \
    --exclude="${pnoslash}/share/tabset" --exclude="${pnoslash}/bin/*.dll" && \
  tar cvjf ${bin_pkg2} ${pnoslash}/bin/*.dll && \
  tar cvjf ${bin_pkg3} ${pnoslash}/lib/ ${pnoslash}/include ${snoslash} && \
  tar cvjf ${bin_pkg4} ${pnoslash}/bin/ncurses-test-dll/
  tar cvjf ${bin_pkg5} ${pnoslash}/share/terminfo ${pnoslash}/share/tabset
)}

spkg() {
  (mkpatch && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * 
)}

finish() {
  rm -rf ${srcdir}
}
case $1 in
  prep)		prep ; STATUS=$? ;;
  conf)		conf ; STATUS=$? ;;
  build)	build; STATUS=$? ;;
  check)	check; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  instextra1)	instextra1; STATUS=$? ;;
  instextra2)	instextra2; STATUS=$? ;;
  install)	install; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  mkpatch) mkdirs ; mkpatch; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
       strip && pkg && spkg && finish && STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
