#!/bin/sh
# This script will create symbolic links to the versioned 
# include files and libraries, with unversioned names.  By default,
# it takes action ONLY if the version number encoded below, in LIBNAME,
# is greater or equal to the largest version number of an installed
# library from the same family -- or if the '--force' option is given.
#
# Thus, if this file is "libpng12", and you have libpng10, libpng12,
# and libpng13 installed -- then this script takes no action without
# --force.  OTOH, if only libpng10 is installed, then this file will
# update the symlinks to point to the newly-installed libpng12 versions.
prefix=/usr
bindir=${prefix}/bin
libdir=${prefix}/lib
incdir=${prefix}/include
# note: this must end with a numeric sequence...and contain no other
# numerals.  lib2ps23 BAD.  libps BAD.
LIBNAME=libpng12

do_core() {
  for fn in ${bindir}/libpng-config ${libdir}/libpng.a \
    ${libdir}/libpng.dll.a ${libdir}/pkgconfig/libpng.pc \
    ${incdir}/libpng ${incdir}/png.h ${incdir}/pngconf.h ; do
    if [ -e ${fn} ] ; then
      rm -f ${fn} ;
    fi
  done
  (cd ${bindir}
    ln -fs ${LIBNAME}-config    libpng-config )
  (cd ${libdir}
    ln -fs ${LIBNAME}.a         libpng.a 
    ln -fs ${LIBNAME}.dll.a     libpng.dll.a )
  (cd ${libdir}/pkgconfig
    ln -fs ${LIBNAME}.pc        libpng.pc )
  (cd ${incdir}
    ln -fs ${LIBNAME}           libpng
    ln -fs ${LIBNAME}/png.h     png.h
    ln -fs ${LIBNAME}/pngconf.h pngconf.h )
}

findver() {
  echo $1 | sed -n -e 's/^[^0-9]*\([0-9]*\)$/\1/p'
}
nover() {
  echo $1 | sed -n -e 's/^\([^0-9]*\)[0-9]*$/\1/p'
}

installed_maxver() {
  maxVER=
  for fn in "$@" ; do
    if [ -e $fn ] ; then
      name=`basename $fn .a`
      ver=`findver $name`
      if [ -n "$ver" ] ; then
        if [ -z "$maxVER" ] ; then
          maxVER=$ver
        elif [ $ver -gt $maxVER ] ; then
          maxVER=$ver
        fi
      fi
    fi
  done
  echo $maxVER
}

doREPLACE="no"
myVER=`findver $LIBNAME`
FAMILY=`nover $LIBNAME`
maxVER=`installed_maxver ${prefix}/lib/${FAMILY}*.a`
if [ -z $maxVER ] ; then
  doREPLACE="yes"
elif [ $myVER -ge $maxVER ] ; then
  doREPLACE="yes"
elif [ "x$1" = "x--force" ] ; then
  doREPLACE="yes"
fi

if [ "x$doREPLACE" = "xyes" ] ; then
  do_core
fi

