#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export PKG2=libgdbm
export PKG3=libgdbm-devel
export VER=`echo $tscriptname | sed -e 's/^[^\-]*\-//' -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e 's/^[^\-]*\-[^\-]*\-//'`
export FULLPKG=${PKG}-${VER}-${REL}
export FULLPKG2=${PKG2}-${VER}-${REL}
export FULLPKG3=${PKG3}-${VER}-${REL}
export src_orig_pkg_name=${PKG}-${VER}.tar.gz
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2
export bin_pkg_name2=${FULLPKG2}.tar.bz2
export bin_pkg_name3=${FULLPKG3}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export bin_pkg2=${topdir}/${bin_pkg_name2}
export bin_pkg3=${topdir}/${bin_pkg_name3}
export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
# run on
host=i686-pc-cygwin
# if this package creates binaries, they run on
target=i686-pc-cygwin
prefix=/usr
pnoslash=`echo $prefix | sed -e 's#^/##'`
sysconfdir=/etc
snoslash=`echo $sysconfdir | sed -e 's#^/##'`
CFLAGS="-O2"
MY_LDFLAGS=

mkdirs() {
  (cd ${topdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir}
)}

prep() {
  (cd ${topdir} && \
  tar xvzf ${src_orig_pkg} ; \
  cd ${topdir} && \
  patch -p0 < ${src_patch} \
  && mkdirs
)}

conf() {
  (cd ${objdir} && \
  ${srcdir}/configure \
  --srcdir=${srcdir} --prefix=${prefix} \
  --exec-prefix=${prefix} --sysconfdir=${sysconfdir} \
  --libdir=${prefix}/lib --includedir=${includedir}
)}

build() {
  (cd ${objdir} && \
  make CFLAGS="${CFLAGS}" && \
  make progs CFLAGS="${CFLAGS}" && \
  make info CFLAGS="${CFLAGS}"
)}

check() {
  (cd ${objdir} && \
  make test | tee ${checkfile} 2>&1
)}

clean() {
  (cd ${objdir} && \
  make clean
)}

install() {
  (cd ${objdir} && \
  make install DESTDIR=${instdir} && \
  make install-compat DESTDIR=${instdir} && \
  if [ -f ${instdir}${prefix}/info/dir ] ; then \
    rm ${instdir}${prefix}/info/dir ; \
  fi && \
  for dirn in ${prefix}/doc/${PKG}-${VER} ${prefix}/doc/${PKG3}-${VER} \
    ${prefix}/doc/Cygwin ${sysconfdir}/postinstall; do \
    if [ ! -d ${instdir}${dirn} ] ; then \
      mkdir -p ${instdir}${dirn} ; \
    fi ;\
  done && \
  templist=""; \
  for f in ${srcdir}/COPYING ${srcdir}/README ${srcdir}/NEWS ; do\
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/doc/${PKG}-${VER} ;
    /usr/bin/install -m 644 $templist \
         ${instdir}${prefix}/doc/${PKG3}-${VER} ;
  fi && \
  cat ${srcdir}/CYGWIN-PATCHES/${PKG}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
    ${instdir}${prefix}/doc/Cygwin/${PKG}-${VER}.README && \
  cat ${srcdir}/CYGWIN-PATCHES/${PKG3}.frag \
    ${srcdir}/CYGWIN-PATCHES/README.frag > \
   ${instdir}${prefix}/doc/Cygwin/${PKG3}-${VER}.README && \
  /usr/bin/install -m 755 ${srcdir}/CYGWIN-PATCHES/${PKG3}.postinstall \
    ${instdir}${sysconfdir}/postinstall/${PKG3}.sh
)}

strip() {
  (cd ${instdir} && \
  find . -name "*.exe" | xargs strip >/dev/null 2>&1 && \
  find . -name "*.dll" | xargs strip >/dev/null 2>&1
)}

mkpatch() {
  (cd ${srcdir} && \
  tar xvzf ${src_orig_pkg} ; \
  mv ${PKG}-${VER} ../${PKG}-${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${PKG}-${VER}-orig/ ${PKG}-${VER}/ > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf ${PKG}-${VER}-orig
)}

pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} --exclude="${pnoslash}/bin/*.dll" \
    --exclude="${pnoslash}/include" \
    --exclude="${pnoslash}/lib" \
    --exclude="${pnoslash}/doc/${PKG3}*" \
    --exclude="${pnoslash}/doc/Cygwin/${PKG3}*" \
    --exclude="${pnoslash}/info" \
    --exclude="${pnoslash}/man" \
    --exclude="${snoslash}" \
    * ;
  tar cvjf ${bin_pkg2} ${pnoslash}/bin/*.dll ;
  tar cvjf ${bin_pkg3} ${pnoslash}/lib \
    ${pnoslash}/include \
    ${pnoslash}/doc/${PKG3}* \
    ${pnoslash}/doc/Cygwin/${PKG3}* \
    ${pnoslash}/info/* \
    ${pnoslash}/man/* \
    ${snoslash}/postinstall/*
)}

spkg() {
  (mkpatch && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} *
)}

finish() {
  rm -rf ${srcdir} 
}
case $1 in
  prep)	prep ; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  mkpatch)	mkpatch ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     strip && pkg && spkg && finish ; \
	  STATUS=$? ;;
  *) echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
