module std.c.mach.mach;

private import std.c.mach.mach_extern;

extern(C):

// sem_init is not supported; use mach semaphores
version (BitsPerWord32)
{
    private alias uint natural_t;
}
else version (BitsPerWord64)
{
    private alias ulong natural_t;
}

enum {
    SYNC_POLICY_FIFO =		0x0,
    SYNC_POLICY_FIXED_PRIORITY =	0x1,
    SYNC_POLICY_REVERSED =		0x2,
    SYNC_POLICY_ORDER_MASK =		0x3,
    SYNC_POLICY_LIFO =		(SYNC_POLICY_FIFO|SYNC_POLICY_REVERSED)
}

enum {
    KERN_SUCCESS =			0
}

alias natural_t semaphore_t; // TODO: natural_t
alias natural_t task_t; // TODO: natural_t
alias natural_t mach_port_t; // TODO: natural_t
alias int kern_return_t;
kern_return_t semaphore_create
(
	task_t task,
	semaphore_t *semaphore,
	int policy,
	int value
);
kern_return_t semaphore_destroy
(
	task_t task,
	semaphore_t semaphore
);
kern_return_t	semaphore_signal     	(semaphore_t semaphore);
kern_return_t	semaphore_wait       	(semaphore_t semaphore);

// just in case this actually gets defined..
extern(D) mach_port_t current_task() { return mach_task_self_; }
