module gcc.builtins;

// These are magically replaced with compiler/library builtins
// Need to automatically generate this file... the types need
// to match builtins.def

// %% Considering making these all __builtin_XX -- already caused problem
// in math2.d.  'private' doesn't seem to help

version (BitsPerWord32) { // -- need this
alias uint buns;
alias int  bint;
alias int  blng;
}
version (BitsPerWord64) {
alias ulong buns;
alias long  bint;
alias long  blng; // %% ?
}

alias void * bptr;
alias real bldb;
alias ubyte * bvalist; // TODO: use __builtin_va_list; front-end needs to know the type...

extern(C):

// wanted have have the names w/o '__builtin', but this caused problems
// with phobos moduels that needed to import this and a std.c module.

// .. the compiler can handle identifiers either with our without the
// '__builtin_' prefix

double __builtin_acos(double);
float __builtin_acosf(float);
double __builtin_acosh(double);
float __builtin_acoshf(float);
real __builtin_acoshl(real);
real __builtin_acosl(real);
double __builtin_asin(double);
float __builtin_asinf(float);
double __builtin_asinh(double);
float __builtin_asinhf(float);
real __builtin_asinhl(real);
real __builtin_asinl(real);
double __builtin_atan(double);
double __builtin_atan2(double, double);
float __builtin_atan2f(float, float);
real __builtin_atan2l(real, real);
float __builtin_atanf(float);
double __builtin_atanh(double);
float __builtin_atanhf(float);
real __builtin_atanhl(real);
real __builtin_atanl(real);
double __builtin_cbrt(double);
float __builtin_cbrtf(float);
real __builtin_cbrtl(real);
double __builtin_ceil(double);
float __builtin_ceilf(float);
real __builtin_ceill(real);
double __builtin_copysign(double, double);
float __builtin_copysignf(float, float);
real __builtin_copysignl(real, real);
double __builtin_cos(double);
float __builtin_cosf(float);
double __builtin_cosh(double);
float __builtin_coshf(float);
real __builtin_coshl(real);
real __builtin_cosl(real);
double __builtin_drem(double, double);
float __builtin_dremf(float, float);
real __builtin_dreml(real, real);
double __builtin_erf(double);
double __builtin_erfc(double);
float __builtin_erfcf(float);
real __builtin_erfcl(real);
float __builtin_erff(float);
real __builtin_erfl(real);
double __builtin_exp(double);
double __builtin_exp10(double);
float __builtin_exp10f(float);
real __builtin_exp10l(real);
double __builtin_exp2(double);
float __builtin_exp2f(float);
real __builtin_exp2l(real);
float __builtin_expf(float);
real __builtin_expl(real);
double __builtin_expm1(double);
float __builtin_expm1f(float);
real __builtin_expm1l(real);
double __builtin_fabs(double);
float __builtin_fabsf(float);
real __builtin_fabsl(real);
double __builtin_fdim(double, double);
float __builtin_fdimf(float, float);
real __builtin_fdiml(real, real);
double __builtin_floor(double);
float __builtin_floorf(float);
real __builtin_floorl(real);
double __builtin_fma(double, double, double);
float __builtin_fmaf(float, float, float);
real __builtin_fmal(real, real, real);
double __builtin_fmax(double, double);
float __builtin_fmaxf(float, float);
real __builtin_fmaxl(real, real);
double __builtin_fmin(double, double);
float __builtin_fminf(float, float);
real __builtin_fminl(real, real);
double __builtin_fmod(double, double);
float __builtin_fmodf(float, float);
real __builtin_fmodl(real, real);
double __builtin_frexp(double, bint*);
float __builtin_frexpf(float, bint*);
real __builtin_frexpl(real, bint*);
double __builtin_gamma(double);
float __builtin_gammaf(float);
real __builtin_gammal(real);
double __builtin_huge_val();
float __builtin_huge_valf();
real __builtin_huge_vall();
double __builtin_hypot(double, double);
float __builtin_hypotf(float, float);
real __builtin_hypotl(real, real);
bint __builtin_ilogb(double);
bint __builtin_ilogbf(float);
bint __builtin_ilogbl(real);
double __builtin_inf();
float __builtin_inff();
real __builtin_infl();
double __builtin_j0(double);
float __builtin_j0f(float);
real __builtin_j0l(real);
double __builtin_j1(double);
float __builtin_j1f(float);
real __builtin_j1l(real);
double __builtin_jn(bint, double);
float __builtin_jnf(bint, float);
real __builtin_jnl(bint, real);
double __builtin_ldexp(double, bint);
float __builtin_ldexpf(float, bint);
real __builtin_ldexpl(real, bint);
double __builtin_lgamma(double);
float __builtin_lgammaf(float);
real __builtin_lgammal(real);
long __builtin_llrint(double);
long __builtin_llrintf(float);
long __builtin_llrintl(real);
long __builtin_llround(double);
long __builtin_llroundf(float);
long __builtin_llroundl(real);
double __builtin_log(double);
double __builtin_log10(double);
float __builtin_log10f(float);
real __builtin_log10l(real);
double __builtin_log1p(double);
float __builtin_log1pf(float);
real __builtin_log1pl(real);
double __builtin_log2(double);
float __builtin_log2f(float);
real __builtin_log2l(real);
double __builtin_logb(double);
float __builtin_logbf(float);
real __builtin_logbl(real);
float __builtin_logf(float);
real __builtin_logl(real);
blng __builtin_lrint(double);
blng __builtin_lrintf(float);
blng __builtin_lrintl(real);
blng __builtin_lround(double);
blng __builtin_lroundf(float);
blng __builtin_lroundl(real);
double __builtin_modf(double, double*);
float __builtin_modff(float, float*);
real __builtin_modfl(real, real*);
double __builtin_nan(char*);
float __builtin_nanf(char*);
real __builtin_nanl(char*);
double __builtin_nans(char*);
float __builtin_nansf(char*);
real __builtin_nansl(char*);
double __builtin_nearbyint(double);
float __builtin_nearbyintf(float);
real __builtin_nearbyintl(real);
double __builtin_nextafter(double, double);
float __builtin_nextafterf(float, float);
real __builtin_nextafterl(real, real);
double __builtin_nexttoward(double, real);
float __builtin_nexttowardf(float, real);
real __builtin_nexttowardl(real, real);
double __builtin_pow(double, double);
double __builtin_pow10(double);
float __builtin_pow10f(float);
real __builtin_pow10l(real);
float __builtin_powf(float, float);
real __builtin_powl(real, real);
double __builtin_remainder(double, double);
float __builtin_remainderf(float, float);
real __builtin_remainderl(real, real);
double __builtin_remquo(double, double, bint*);
float __builtin_remquof(float, float, bint*);
real __builtin_remquol(real, real, bint*);
double __builtin_rint(double);
float __builtin_rintf(float);
real __builtin_rintl(real);
double __builtin_round(double);
float __builtin_roundf(float);
real __builtin_roundl(real);
double __builtin_scalb(double, double);
float __builtin_scalbf(float, float);
real __builtin_scalbl(real, real);
double __builtin_scalbln(double, blng);
float __builtin_scalblnf(float, blng);
real __builtin_scalblnl(real, blng);
double __builtin_scalbn(double, bint);
float __builtin_scalbnf(float, bint);
real __builtin_scalbnl(real, bint);
double __builtin_significand(double);
float __builtin_significandf(float);
real __builtin_significandl(real);
double __builtin_sin(double);
void __builtin_sincos(double, double*, double*);
void __builtin_sincosf(float, float*, float*);
void __builtin_sincosl(real, real*, real*);
float __builtin_sinf(float);
double __builtin_sinh(double);
float __builtin_sinhf(float);
real __builtin_sinhl(real);
real __builtin_sinl(real);
double __builtin_sqrt(double);
float __builtin_sqrtf(float);
real __builtin_sqrtl(real);
double __builtin_tan(double);
float __builtin_tanf(float);
double __builtin_tanh(double);
float __builtin_tanhf(float);
real __builtin_tanhl(real);
real __builtin_tanl(real);
double __builtin_tgamma(double);
float __builtin_tgammaf(float);
real __builtin_tgammal(real);
double __builtin_trunc(double);
float __builtin_truncf(float);
real __builtin_truncl(real);
double __builtin_y0(double);
float __builtin_y0f(float);
real __builtin_y0l(real);
double __builtin_y1(double);
float __builtin_y1f(float);
real __builtin_y1l(real);
double __builtin_yn(bint, double);
float __builtin_ynf(bint, float);
real __builtin_ynl(bint, real);
double __builtin_cabs(cdouble);
float __builtin_cabsf(cfloat);
real __builtin_cabsl(creal);
cdouble __builtin_cacos(cdouble);
cfloat __builtin_cacosf(cfloat);
cdouble __builtin_cacosh(cdouble);
cfloat __builtin_cacoshf(cfloat);
creal __builtin_cacoshl(creal);
creal __builtin_cacosl(creal);
double __builtin_carg(cdouble);
float __builtin_cargf(cfloat);
real __builtin_cargl(creal);
cdouble __builtin_casin(cdouble);
cfloat __builtin_casinf(cfloat);
cdouble __builtin_casinh(cdouble);
cfloat __builtin_casinhf(cfloat);
creal __builtin_casinhl(creal);
creal __builtin_casinl(creal);
cdouble __builtin_catan(cdouble);
cfloat __builtin_catanf(cfloat);
cdouble __builtin_catanh(cdouble);
cfloat __builtin_catanhf(cfloat);
creal __builtin_catanhl(creal);
creal __builtin_catanl(creal);
cdouble __builtin_ccos(cdouble);
cfloat __builtin_ccosf(cfloat);
cdouble __builtin_ccosh(cdouble);
cfloat __builtin_ccoshf(cfloat);
creal __builtin_ccoshl(creal);
creal __builtin_ccosl(creal);
cdouble __builtin_cexp(cdouble);
cfloat __builtin_cexpf(cfloat);
creal __builtin_cexpl(creal);
double __builtin_cimag(cdouble);
float __builtin_cimagf(cfloat);
real __builtin_cimagl(creal);
cdouble __builtin_conj(cdouble);
cfloat __builtin_conjf(cfloat);
creal __builtin_conjl(creal);
cdouble __builtin_cpow(cdouble, cdouble);
cfloat __builtin_cpowf(cfloat, cfloat);
creal __builtin_cpowl(creal, creal);
cdouble __builtin_cproj(cdouble);
cfloat __builtin_cprojf(cfloat);
creal __builtin_cprojl(creal);
double __builtin_creal(cdouble);
float __builtin_crealf(cfloat);
real __builtin_creall(creal);
cdouble __builtin_csin(cdouble);
cfloat __builtin_csinf(cfloat);
cdouble __builtin_csinh(cdouble);
cfloat __builtin_csinhf(cfloat);
creal __builtin_csinhl(creal);
creal __builtin_csinl(creal);
cdouble __builtin_csqrt(cdouble);
cfloat __builtin_csqrtf(cfloat);
creal __builtin_csqrtl(creal);
cdouble __builtin_ctan(cdouble);
cfloat __builtin_ctanf(cfloat);
cdouble __builtin_ctanh(cdouble);
cfloat __builtin_ctanhf(cfloat);
creal __builtin_ctanhl(creal);
creal __builtin_ctanl(creal);
bint __builtin_bcmp(void*, void*, size_t);
void __builtin_bcopy(void*, void*, size_t);
void __builtin_bzero(void*, size_t);
bint __builtin_ffs(bint);
bint __builtin_ffsl(blng);
bint __builtin_ffsll(long);
char* __builtin_index(char*, bint);
bint __builtin_memcmp(void*, void*, size_t);
void* __builtin_memcpy(void*, void*, size_t);
void* __builtin_memmove(void*, void*, size_t);
void* __builtin_mempcpy(void*, void*, size_t);
void* __builtin_memset(void*, bint, size_t);
char* __builtin_rindex(char*, bint);
char* __builtin_stpcpy(char*, char*);
char* __builtin_strcat(char*, char*);
char* __builtin_strchr(char*, bint);
bint __builtin_strcmp(char*, char*);
char* __builtin_strcpy(char*, char*);
size_t __builtin_strcspn(char*, char*);
char* __builtin_strdup(char*);
size_t __builtin_strlen(char*);
char* __builtin_strncat(char*, char*, size_t);
bint __builtin_strncmp(char*, char*, size_t);
char* __builtin_strncpy(char*, char*, size_t);
char* __builtin_strpbrk(char*, char*);
char* __builtin_strrchr(char*, bint);
size_t __builtin_strspn(char*, char*);
char* __builtin_strstr(char*, char*);
bint __builtin_fprintf(void*, char*, ...);
bint __builtin_fprintf_unlocked(void*, char*, ...);
bint __builtin_fputc(bint, void*);
bint __builtin_fputc_unlocked(bint, void*);
bint __builtin_fputs(char*, void*);
bint __builtin_fputs_unlocked(char*, void*);
bint __builtin_fscanf(void*, char*, ...);
size_t __builtin_fwrite(void*, size_t, size_t, void*);
size_t __builtin_fwrite_unlocked(void*, size_t, size_t, void*);
bint __builtin_printf(char*, ...);
bint __builtin_printf_unlocked(char*, ...);
bint __builtin_putchar(bint);
bint __builtin_putchar_unlocked(bint);
bint __builtin_puts(char*);
bint __builtin_puts_unlocked(char*);
bint __builtin_scanf(char*, ...);
bint __builtin_snprintf(char*, size_t, char*, ...);
bint __builtin_sprintf(char*, char*, ...);
bint __builtin_sscanf(char*, char*, ...);
bint __builtin_vfprintf(void*, char*, bvalist);
bint __builtin_vfscanf(void*, char*, bvalist);
bint __builtin_vprintf(char*, bvalist);
bint __builtin_vscanf(char*, bvalist);
bint __builtin_vsnprintf(char*, size_t, char*, bvalist);
bint __builtin_vsprintf(char*, char*, bvalist);
bint __builtin_vsscanf(char*, char*, bvalist);
void __builtin_abort();
bint __builtin_abs(bint);
void* __builtin_aggregate_incoming_address(...);
void* __builtin_alloca(size_t);
void* __builtin_apply_args(...);
bint __builtin_args_info(bint);
void* __builtin_calloc(size_t, size_t);
bint __builtin_classify_type(...);
bint __builtin_clz(bint);
bint __builtin_clzl(blng);
bint __builtin_clzll(long);
bint __builtin_constant_p(...);
bint __builtin_ctz(bint);
bint __builtin_ctzl(blng);
bint __builtin_ctzll(long);
char* __builtin_dcgettext(char*, char*, bint);
char* __builtin_dgettext(char*, char*);
void* __builtin_dwarf_cfa();
buns __builtin_dwarf_sp_column();
void __builtin_eh_return(void*, void*);
bint __builtin_eh_return_data_regno(bint);
void __builtin_exit(bint);
blng __builtin_expect(blng, blng);
void* __builtin_extract_return_addr(void*);
void* __builtin_frame_address(buns);
void* __builtin_frob_return_addr(void*);
char* __builtin_gettext(char*);
void __builtin_init_dwarf_reg_size_table(void*);
bint __builtin_isgreater(...);
bint __builtin_isgreaterequal(...);
bint __builtin_isless(...);
bint __builtin_islessequal(...);
bint __builtin_islessgreater(...);
bint __builtin_isunordered(...);
blng __builtin_labs(blng);
long __builtin_llabs(long);
void __builtin_longjmp(void*, bint);
void* __builtin_malloc(size_t);
void* __builtin_next_arg(...);
bint __builtin_parity(bint);
bint __builtin_parityl(blng);
bint __builtin_parityll(long);
bint __builtin_popcount(bint);
bint __builtin_popcountl(blng);
bint __builtin_popcountll(long);
void __builtin_prefetch(void*, ...);
void __builtin_return(void*);
void* __builtin_return_address(buns);
void* __builtin_saveregs(...);
bint __builtin_setjmp(void*);
void __builtin_stdarg_start(inout bvalist, ...);
size_t __builtin_strftime(char*, size_t, char*, void*);
void __builtin_trap();
void __builtin_unwind_init();
void __builtin_va_copy(inout bvalist, bvalist);
void __builtin_va_end(inout bvalist);
void __builtin_va_start(inout bvalist, ...);
void __builtin__exit(bint);
void __builtin__Exit(bint);
