#ifndef GCC_DCMPLR_IRSTATE_H
#define GCC_DCMPLR_IRSTATE_H

// Due to the inlined functions, "dc-gcc-includes.h" needs to
// be included before this header is included.

#include "mars.h"
#include "root.h"
#include "lexer.h"
#include "declaration.h"
#include "statement.h"
#include "expression.h"
#include "mtype.h"
#include "aggregate.h"
#include "symbol.h"


// IRBase contains the core functionality of IRState.  The actual IRState class
// extends this with lots of code generation utilities.
//
// Currently, each function gets its own IRState when emitting code.  There is
// also a global IRState.
//
// Most toElem calls don't actually need the IRState because they create GCC
// expression trees rather than emit instructions.

struct IRBase : Object
{
    IRBase * parentIRState;

    IRBase();

    // ** Functions
    
    // This is used by LabelStatement to find the LabelDsymbol that
    // GotoStatements refer to.
    FuncDeclaration * thisFunction; // %% make this a stack

    FuncDeclaration * getCurrentFunction() { return thisFunction; }
    IRState * startFunction(FuncDeclaration * decl);
    IRState * endFunction();
    Array deferedFuncDecls;
    bool shouldDeferFunction(FuncDeclaration * decl);

    static void initFunctionStart(tree fn_decl, const Loc & loc)
#if D_GCC_VER >= 34
    { init_function_start (fn_decl); }
#else
    { init_function_start (fn_decl, loc.filename, loc.linnum); } // %% loc of the f. or 1st stmt.? 
#endif

    // ** Labels

    // It is only valid to call this while the function in which the label is defined
    // is being compiled.
    tree getLabelTree(LabelDsymbol * label);

    // ** Loops

    Array * loops; // array of [ Statement 1, nesting 1, Satement 2, nesting 2 ... ]
    
    // These routines don't generate code.  They are for tracking labeled loops.
    nesting * getCurrentLoop() { return getLoopForLabel( (Identifier *) 0 ); }
    // ident == 0 means current loop
    nesting * getLoopForLabel(Identifier * ident);
    void      beginLoop(Statement * stmt, nesting * loop);
    void      endLoop();


    // ** DECL_CONTEXT support

    // TODO: separate stacks for variables, functions, blocks, etc.
    Array declContextStack;

    bool isToplevelDeclContext() { return getDeclContext() ? false : true; }
    tree getDeclContext(); 
    void pushDeclContext(tree context);
    void popDeclContext();

    // ** "Binding contours"

    void startBindings();
    void endBindings();

    // ** Temporaries (currently just SAVE_EXPRs)

    // Create a SAVE_EXPR if it is not safe (or effecient*) to reevaluate
    // the expression. * -- Actually can product inefficient code because
    // it prevents cse.
    Expression * maybeMakeTemp(Expression * e);
    tree maybeMakeTemp(tree t);

    // ** Volatile state

    // %%ISSUE: are the bodies of nested functions declared in a volatile block
    // also volatile?  For now: No.
    
    unsigned volatileDepth;
    bool inVolatile() { return volatileDepth != 0; }
    void pushVolatile() { ++volatileDepth; }
    void popVolatile() { --volatileDepth; }

};


#endif
