/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.registry;

import gnu.java.rmi.server.UnicastServerRef;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;

public class RegistryImpl
extends UnicastRemoteObject
implements Registry {
    private Hashtable bindings;

    private /* synthetic */ void finit$() {
        this.bindings = new Hashtable();
    }

    public RegistryImpl(int port) throws RemoteException {
        this(port, RMISocketFactory.getSocketFactory(), RMISocketFactory.getSocketFactory());
    }

    public RegistryImpl(int port, RMIClientSocketFactory cf, RMIServerSocketFactory sf) throws RemoteException {
        super(new UnicastServerRef(new ObjID(0), port, sf));
        this.finit$();
    }

    public Remote lookup(String name) throws RemoteException, NotBoundException, AccessException {
        Object obj = this.bindings.get(name);
        if (obj == null) {
            throw new NotBoundException(name);
        }
        return (Remote)obj;
    }

    public void bind(String name, Remote obj) throws RemoteException, AlreadyBoundException, AccessException {
        if (this.bindings.containsKey(name)) {
            throw new AlreadyBoundException(name);
        }
        this.bindings.put(name, obj);
    }

    public void unbind(String name) throws RemoteException, NotBoundException, AccessException {
        Object obj = this.bindings.remove(name);
        if (obj == null) {
            throw new NotBoundException(name);
        }
    }

    public void rebind(String name, Remote obj) throws RemoteException, AccessException {
        this.bindings.put(name, obj);
    }

    public String[] list() throws RemoteException, AccessException {
        int size = this.bindings.size();
        String[] strings = new String[size];
        Enumeration e = this.bindings.keys();
        for (int i = 0; i < size; ++i) {
            strings[i] = (String)e.nextElement();
        }
        return strings;
    }

    public static void version() {
        System.out.println("rmiregistry (" + System.getProperty("java.vm.name") + ") " + System.getProperty("java.vm.version"));
        System.out.println("Copyright 2002 Free Software Foundation, Inc.");
        System.out.println("This is free software; see the source for copying conditions.  There is NO");
        System.out.println("warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.");
        System.exit(0);
    }

    public static void help() {
        System.out.println("Usage: rmiregistry [OPTION | PORT]\n\n    --help                Print this help, then exit\n    --version             Print version number, then exit\n");
        System.exit(0);
    }

    public static void main(String[] args) {
        int port = 1099;
        if (args.length > 0) {
            if (args[0].equals("--version")) {
                RegistryImpl.version();
            } else if (args[0].equals("--help")) {
                RegistryImpl.help();
            }
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException _) {
                System.err.println("Bad port number - using default");
            }
        }
        try {
            Registry impl = LocateRegistry.createRegistry(port);
        }
        catch (RemoteException _) {
            System.err.println("Registry failed");
        }
    }
}

