/*
 * colorized_text.cpp
 *
 * Copyright (C) 2003 Ed Cogburn <ecogburn@xtn.net>
 *
 * This file is part of the program "d: The Directory Lister".
 *
 * "d: The Directory Lister" is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
 *
 * "d: The Directory Lister" is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with "d: The Directory Lister" in a file named "COPYING".
 * If not, visit their website at http://www.gnu.org for a copy, or request a copy by writing to:
 *     Free Software Foundation, Inc.
 *     59 Temple Place, Suite 330
 *     Boston, MA 02111-1307 USA
*/



#include "globals.hpp"



namespace ct
{



	//-----------------------------------------------------------------------------
	string colorized_text::set(Color cf, Color cb, Attr a)
	{
		string s;

		s = "\x1B[";

		switch (a)	{
			case Normal:
				s += "00;";
				break;

			case Bold:
				s += "01;";
				break;

			case Underline:
				s += "04;";
				break;

			case Blink:
				s += "05;";
				break;

			case Reverse:
				s += "07;";
				break;

			default:
				throw runtime_error("colorized_text():  Unknown attribute!");
		}

		switch (cf)	{
			case Black:
				s += "30;";
				break;

			case Red:
				s += "31;";
				break;

			case Green:
				s += "32;";
				break;

			case Yellow:
				s += "33;";
				break;

			case Blue:
				s += "34;";
				break;

			case Magenta:
				s += "35;";
				break;

			case Cyan:
				s += "36;";
				break;

			case White:
				s += "37;";
				break;

			default:
				throw runtime_error("colorized_text():  Unknown foreground color!");
		}

		switch (cb)	{
			case Black:
				s += "40";
				break;

			case Red:
				s += "41";
				break;

			case Green:
				s += "42";
				break;

			case Yellow:
				s += "43";
				break;

			case Blue:
				s += "44";
				break;

			case Magenta:
				s += "45";
				break;

			case Cyan:
				s += "46";
				break;

			case White:
				s += "47";
				break;

			default:
				throw runtime_error("colorized_text():  Unknown background color!");
		}

		s += "m";
		return s;
	}



	//-----------------------------------------------------------------------------
	string colorized_text::setstr(string& output, Color cf, Color cb, Attr a)
	{
		string s;

		s += set(cf, cb, a);

		s += output;

		s += reset();

		return s;
	}



	//-----------------------------------------------------------------------------
	string colorized_text::reset()
	{
		return "\x1B[0m";
	}



} // namespace ct
