#!/bin/sh
# 2003 Mar 15 JDF
# This script SHOULD get all the sgml files needed 
# It may not. :)
#
if [ $# -lt 1 ]; then
	echo "usage: $0 /path/to/cygwin/src"
	exit 1;
fi

SRCPATH="$1"
OUTDIR="$PWD"

if [ ! -d "$SRCPATH/winsup" ]; then
	echo "usage: $0 /path/to/cygwin/src"
	echo "(Don't include winsup)"
	exit 1;
fi

if [ ! -f "$SRCPATH/winsup/doc/cygwin-ug-net.sgml" ]; then
	echo "New cygwin-ug-net.sgml file not found!"
	echo "You must build the CVS cygwin doc before running 'make upgrade'"
	echo "Read '../cygwin-users-guide/README' for instructions"
	exit 1;
fi 

cp "$SRCPATH/winsup/doc/cygwin-ug-net.sgml" .
echo -n "New ug : " && ls -lG cygwin-ug-net.sgml

if [ ! -f "$SRCPATH/winsup/doc/cygwin-api.sgml" ]; then
	echo "New cygwin-api.sgml file not found!"
	echo "You must build the CVS cygwin doc before running 'make upgrade'"
	echo "Read '../cygwin-users-guide/README' for instructions"
	exit 1;
fi 

cp "$SRCPATH/winsup/doc/cygwin-api.sgml" .
echo -n "New api: " && ls -lG cygwin-api.sgml
