/* $Id: strace.c,v 1.6 2001/02/10 23:50:01 administrator Exp $ */

/*
 *   IPC package for CygWin
 *
 *   Copyright (C) 1997 Philippe CHAPUY
 *   Copyright (C) 1998 Ludovic LANGE
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *   HISTORY:
 *   --------
 *
 *   13/05/1998 : Version 1.00 released
 *                First public release
 *                adress any comments to llange@capgemini.fr
 *
 */

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <windows.h>
#include <syslog.h>
#include <sys/ipctrace.h>

int default_err_handler(FILE *stream, int severity, const char *fmt, ...);

err_handlerP err_handler = default_err_handler;
void cygipc_set_err_handler(err_handlerP new_val)
{
  err_handler = new_val;
}
err_handlerP cygipc_get_err_handler(void)
{
  return err_handler;
}

#ifdef TRACE
static int debug = 1;
#else
static int debug = 0;
#endif

int cygipc_get_debug(void)
{
  return debug;
}
void cygipc_set_debug(int new_val)
{
  debug = new_val;
}

int
cygipc_tracing_enabled(void)
{
#ifdef TRACE
  return 1;
#else
  return 0;
#endif
}

int default_err_handler(FILE *stream, int severity, const char *fmt, ...)
{
  char buf[2000];
  va_list ap;
  int count;

  if(cygipc_get_debug() || (severity < LOG_DEBUG))
  {
    count = snprintf (buf, 2000, "(libcygipc) ");
    va_start (ap, fmt);
    count += vsnprintf (buf + count, 2000 - count, fmt, ap);
    va_end (ap);
    snprintf(buf + count, 2000 - count, "\n");
    fprintf(stream, buf);
  }
  return 0;
}
