/* $Id: IpcNtStr.h,v 1.3 2000/09/17 01:00:40 cwilson Exp $ */

/*	
 *   IPC package for CygWin
 *
 *   Copyright (C) 1997 Philippe CHAPUY
 *   Copyright (C) 1998 Ludovic LANGE
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *   HISTORY:
 *   --------
 *
 *   13/05/1998 : Version 1.00 released
 *                First public release
 *                adress any comments to llange@capgemini.fr
 *
 */
 
 


/************************************************************************/
/*									*/
/************************************************************************/

#ifndef CYGWIN_IPCNT_STR
#define CYGWIN_IPCNT_STR

/************************************************************************/
/* MESSAGE QUEUE							*/
/************************************************************************/

typedef struct
{

 struct msqid_ds *msgque[MSGMNI];

 int msgbytes ;
 int msghdrs ;
 unsigned short msg_seq ;
 int used_queues ;
 int max_msqid ;

 struct msqid_ds msg[MSGMNI] ;

} CYGWIN_IPCNT_MSGSTR ;


/************************************************************************/
/* SEMAPHORE								*/
/************************************************************************/

typedef struct
{

 struct semid_ds *semary[SEMMNI];
 int state[SEMMNI] ;
 struct current_nb_struct {
  int current_nb[SEMOPM];
 } current_nb[SEMMNI];

 int used_sems ;
 int used_semids ;
 int max_semid ;

 unsigned short sem_seq ;
  
 struct semid_ds sem[SEMMNI] ;

} CYGWIN_IPCNT_SEMSTR ;


/************************************************************************/
/* SHARE MEMORY 							*/
/************************************************************************/
typedef struct
{

 struct shmid_ds *shm_segs[SHMMNI];

 int shm_rss ; /* number of shared memory pages that are in memory */
 int shm_swp ; /* number of shared memory pages that are in swap */
 int max_shmid ; /* every used id is <= max_shmid */

 unsigned short shm_seq ; /* incremented, for recognizing stale ids */

 struct shmid_ds shm[SHMMNI] ;

} CYGWIN_IPCNT_SHMSTR ;


#endif	/* CYGWIN_IPCNT_STR */
