#!perl
# $Id: test_filter1.pl,v 1.4 2004/09/30 07:34:13 jlinoff Exp $
use strict;

&Main;

# ================================================
# MAIN
# ================================================
sub Main {
  if( $#ARGV < 1 ) {
    print STDERR "ERROR: missing arguments [ifile] [ofile]\n";
    exit 1;
  }

  my $ifile = shift @ARGV;
  my $ofile = shift @ARGV;

  if( ! -e $ifile ) {
    print STDERR "ERROR: can't read $ifile\n";
    exit 1;
  }

  open IFP,"$ifile" || die "ERROR: Can't read '$ifile'.\n";
  open OFP,">$ofile" || die "ERROR: Can't write '$ofile'.\n";
  while(<IFP>) {
    chop;
    my $line = $_;
    next if ( $line =~ /ccdoc v0.8 r\d+/ );
    next if ( $line =~ /ccdoc v08r\d+/ );
    next if ( $line =~ /ccdoc_creation_date/ );
    next if ( $line =~ /Created\s/ );
    print OFP "$line\n";
  }
  close IFP;
  close OFP;
}
