//@copyright_begin
// ================================================================
// Copyright Notice
// Copyright (C) 1998-2004 by Joe Linoff
// 
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL JOE LINOFF BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
// 
// Comments and suggestions are always welcome.
// Please report bugs to http://ccdoc.sourceforge.net/ccdoc
// ================================================================
//@copyright_end

// MULTIPLE INCLUSION GUARD
#ifndef ccdoc_strmgr_h
#define ccdoc_strmgr_h

/**
 * This variable allows the header version
 * to be queried at runtime.
 */
namespace {
   char ccdoc_strmgr_h_rcsid[] = "$Id: strmgr.h,v 1.6 2004/09/30 04:16:07 jlinoff Exp $";
}

#include "exceptions.h"
#include <map>
#include <string>

namespace ccdoc {
  /**
   * String manager. This function keeps track of all strings
   * used in the system so that there is only one physical
   * copy (with a reference count).
   * @author Joe Linoff
   * @version $Id: strmgr.h,v 1.6 2004/09/30 04:16:07 jlinoff Exp $
   */
  class strmgr {
  public:
    typedef map<string,unsigned,less<string> > str_coll;
    typedef map<string,unsigned,less<string> >::iterator str_coll_itr;
    typedef map<unsigned,const string*,less<unsigned> > idx_coll;
    typedef map<unsigned,const string*,less<unsigned> >::iterator idx_coll_itr;
  public:
    /**
     * Constructor.
     */
    strmgr();
    /**
     * Destructor.
     */
    ~strmgr();
  private:
    /**
     * Private copy constructor.
     */
    strmgr(const strmgr&);
  public:
    /**
     * Get the reference to the single copy of the string.
     * @param v The value to make a reference copy of.
     * @returns A reference copy of the string.
     */
    const string& get(const string& v);
    /**
     * Get the index associated with a string.
     * This method is used to generate output records.
     * @param v The value to make a reference copy of.
     * @returns The idx associated with a string.
     */
    unsigned get_idx(const string v);
  public:
    /**
     * Get a string by it's id. This method is used when
     * reading persistent data.
     * @param id The string idx.
     * @returns The string.
     */
    const string& get_by_idx(unsigned idx);
  public:
    unsigned size() const {return m_strmap.size();}
    str_coll_itr begin() {return m_strmap.begin();}
    str_coll_itr end() {return m_strmap.end();}
  public:
    /**
     * Create the xref maps.
     */
    void gen_maps();
  private:
    str_coll m_strmap;
    idx_coll m_idxmap;
    bool m_mapped;
  };
};

#endif

