// ================================================================
// Copyright Notice
// Copyright (C) 1998-2001 by Joe Linoff (joe@joelinoff.com)
// 
// This software is distributed in the hope that it will be useful, but
// without WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// 
// Permission is granted to anyone to make or distribute altered copies
// of this software provided that the copyright notice and this
// permission notice are preserved, that the distributor grants the
// recipent permission for further distribution as permitted by this
// notice and that the origin of the software is represented correctly.
// 
// Comments and suggestions are always welcome.
// Please report bugs to joe@joelinoff.com
// ================================================================
//@copyright_end

// MULTIPLE INCLUSION GUARD
#ifndef ccdoc_phase1_file_h
#define ccdoc_phase1_file_h

/**
 * This variable allows the header version
 * to be queried at runtime.
 */
namespace {
   char ccdoc_phase1_file_h_rcsid[] = "$Id: phase1_file.h,v 1.3 2003/02/26 18:46:19 jlinoff Exp $";
}

#include "database.h"
#include "statement.h"

namespace ccdoc {
  namespace phase1 {
    // ================================================================
    //@{
    // File object.
    // @author Joe Linoff
    // @version $Id: phase1_file.h,v 1.3 2003/02/26 18:46:19 jlinoff Exp $
    //@}
    // ================================================================
    class file {
    public:
      file(switches& sw,
	   database& db,
	   const string& name);
      ~file();
      void compile();
    public:
      bool get_debug() const {return m_debug;}
      void set_debug(bool f) {m_debug=f;}
    private:
      switches& m_sw;
      database& m_db;
      const string& m_name;
      bool m_debug;
    };
  }
}

#endif
