#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e "s/${PKG}\-//" -e 's/\-[^\-]*$//'`
export VERMAJ=`echo $VER | sed -e 's/^\([[:alnum:]]*\)\..*$/\1/'`
export VERMIN=`echo $VER | sed -e 's/^.*\.\([[:alnum:]]*\)\p.*$/\1/'`
export VER2=`echo $VER | sed -e "s/p/-p/"`
export REL=`echo $tscriptname | sed -e "s/${PKG}\-${VER}\-//"`
export FULLPKG=${PKG}-${VER}-${REL}

# determine correct decompression option and tarball filename
if [ -e automake-${VER2}.tar.gz ] ; then
  export opt_decomp=z
  export src_orig_pkg_ext=gz
elif [ -e automake-${VER2}.tar.bz2 ] ; then
  export opt_decomp=j
  export src_orig_pkg_ext=bz2
fi

export src_orig_pkg_name=automake-${VER2}.tar.${src_orig_pkg_ext}
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export srcdir=${topdir}/automake-${VER2}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
host=i686-pc-cygwin
target=i686-pc-cygwin
prefix=/usr/autotool/stable
docprefix=/usr
sysconfdir=${prefix}/etc
path_old="${PATH}"

mkdirs() {
  (cd ${topdir} && \
  rm -fr ${objdir} ${instdir} ${srcinstdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${srcinstdir} 
)}

prep() {
  (export PATH="${prefix}/bin:${path_old}" && \
  cd ${topdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} && \
  cd ${topdir} && \
  patch -p0 < ${src_patch} && \
  mkdirs
  export PATH="${path_old}"
)}

conf() {
  (export PATH="${prefix}/bin:${path_old}" && \
  cd ${objdir} && \
  ${srcdir}/configure --build=${host} --target=${target} \
  --srcdir=${srcdir} --prefix=${prefix} \
  --exec-prefix=${prefix} --sysconfdir=${sysconfdir} \
  --libdir=${prefix}/lib --includedir=${prefix}/include \
  --mandir=${prefix}/share/man --infodir=${prefix}/share/info && \
  export PATH="${path_old}"
)}

build() {
  (export PATH="${prefix}/bin:${path_old}" && \
  cd ${objdir} && \
  make CFLAGS=-O2 && make info && \
  export PATH="${path_old}"
)}

check() {
  (export PATH="${prefix}/bin:${path_old}" && \
  cd ${objdir} && \
  make check | tee ${checkfile} 2>&1 && \
  export PATH="${path_old}"
)}

clean() {
  (export PATH="${prefix}/bin:${path_old}" && \
  cd ${objdir} && \
  make clean && \
  export PATH="${path_old}"
)}

install() {
  (export PATH="${prefix}/bin:${path_old}" && \
  cd ${objdir} && \
  make install INSTALL=install \
  prefix=${instdir}${prefix} \
  exec_prefix=${instdir}${prefix} \
  bindir=${instdir}${prefix}/bin \
  libdir=${instdir}${prefix}/lib \
  mandir=${instdir}${prefix}/share/man \
  infodir=${instdir}${prefix}/share/info \
  sysconfdir=${instdir}${sysconfdir} \
  includedir=${instdir}${prefix}/include \
  tooldir=${instdir}${prefix} && \
  for f in ${prefix}/share/info/dir ${prefix}/info/dir ; do
    if [ -f ${instdir}${f} ] ; then \
      rm -f ${instdir}${f} ; \
    fi ;\
  done &&\
  for d in ${docprefix}/share/doc/${PKG}-${VER} \
           ${docprefix}/share/doc/Cygwin \
           ${docprefix}/bin \
           ${prefix}/share/aclocal ; do
    if [ ! -d ${instdir}${d} ] ; then
      mkdir -p ${instdir}${d} ;\
    fi ;\
  done &&\
  /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/${PKG}.README \
    ${instdir}${docprefix}/share/doc/Cygwin/${PKG}-${VER}.README && \
  /usr/bin/install -m 644 ${srcdir}/README \
    ${srcdir}/AUTHORS ${srcdir}/COPYING ${srcdir}/NEWS ${srcdir}/TODO \
    ${srcdir}/THANKS ${instdir}${docprefix}/share/doc/${PKG}-${VER} && \
  /usr/bin/install -m 644 ${srcdir}/CYGWIN-PATCHES/dirlist \
    ${instdir}${prefix}/share/aclocal/dirlist && \
  (cd ${instdir}${prefix}/bin && \
    rm -f automake && \
    rm -f aclocal && \
    ln -s automake-${VERMAJ}.${VERMIN} automake && \
    ln -s aclocal-${VERMAJ}.${VERMIN} aclocal ) && \
  (cd ${instdir}${docprefix}/bin && \
    rm -f automake-${VERMAJ}.${VERMIN} && \
    rm -f aclocal-${VERMAJ}.${VERMIN} && \
    ln -s ../autotool/stable/bin/automake-${VERMAJ}.${VERMIN} automake-${VERMAJ}.${VERMIN} && \
    ln -s ../autotool/stable/bin/aclocal-${VERMAJ}.${VERMIN} aclocal-${VERMAJ}.${VERMIN} ) && \
  export PATH="${path_old}"
)}

strip() {
  (export PATH="${prefix}/bin:${path_old}" && \
  cd ${instdir} && \
  find . -name "*.exe" | xargs strip >/dev/null 2>&1 ;
  find . -name "*.dll" | xargs strip >/dev/null 2>&1 ;
  /bin/true
  export PATH="${path_old}"
)}

list() {
  (export PATH="${prefix}/bin:${path_old}" && \
  cd ${instdir} && \
  find . -name "*" ! -type d | sed 's/\.\/\(.*\)/\1/'
  /bin/true
  export PATH="${path_old}"
)}

pkg() {
  (export PATH="${prefix}/bin:${path_old}" && \
  cd ${instdir} && \
  tar cvjf ${bin_pkg} * && \
  export PATH="${path_old}"
)}

mkpatch() {
  (export PATH="${prefix}/bin:${path_old}" && \
  cd ${srcdir} && \
  tar xv${opt_decomp}f ${src_orig_pkg} && \
  mv automake-${VER2} ../automake-${VER2}-orig && \
  cd ${topdir} && \
  (find . -type d -name "autom4te" | xargs rm -rf) && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    automake-${VER2}-orig automake-${VER2} > \
    ${srcinstdir}/${src_patch_name} ; \
  rm -rf automake-${VER2}-orig && \
  export PATH="${path_old}"
)}

spkg() {
  (mkpatch && \
  export PATH="${prefix}/bin:${path_old}" && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * && \
  export PATH="${path_old}"
)}

finish() {
  (export PATH="${prefix}/bin:${path_old}" && \
  rm -rf ${srcdir}
  export PATH="${path_old}"
)}

case $1 in
  prep)	prep ; STATUS=$? ;;
  mkdirs)	mkdirs ; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  list) list ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  mkpatch) mkpatch ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && \
     pkg && spkg && finish ; STATUS=$? ;;
  *) echo "Error: bad arguments" ; STATUS=1 ;;
esac
export PATH="${path_old}" 
exit ${STATUS}
