#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# If scriptdir ends in hw/xwin, then topdir is the directory below xc/
# Otherwise, we assume that topdir = scriptdir
case "$scriptdir" in
  */SPECS)
    topdir=`cd ${scriptdir}/..; pwd`
    patchdir=xc/CYGWIN-PATCHES
    ;;
  */CYGWIN-PATCHES)
    topdir=`cd ${scriptdir}/../..; pwd`
    patchdir=xc/CYGWIN-PATCHES
    ;;
  */programs/Xserver/hw/xwin/packaging)
    topdir=`cd ${scriptdir}/../../../../../..; pwd`
    patchdir=xc/programs/Xserver/hw/xwin/packaging
    ;;
  *)
    topdir=`cd ${scriptdir}; pwd`
    patchdir=xc/CYGWIN-PATCHES
    ;;
esac

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e "s/${PKG}\-//" -e 's/\-[^\-]*$//'`

# Note that we generate the following binary packages:
#  base
#  bin
#  bin-dlls
#  bin-lndir
#  devel
#  etc
#  f100
#  fcyr
#  fenc
#  fnts
#  fscl
#  fsrv
#  html
#  libs-data
#  man-pages
#  man-pages-html
#  nest
#  vfb
#  xwin

export FULLPKG=${PKG}-${VER}

# setup.hint package category name
export CATEGORY=X11

# Release numbers
# NOTE: Indented release numbers are dependent on the release number
# of another package because of an external source package reference
# in that packages setup.hint.  These release numbers must always match,
# so the child is set to the value of the parent.
export PKG_BASE_REL=1
export PKG_BIN_REL=2
export PKG_BIN_DLLS_REL=1
export PKG_BIN_LNDIR_REL=1
export PKG_DEVEL_REL=1
export PKG_ETC_REL=1
export PKG_FENC_REL=1
export PKG_FNTS_REL=1
  export PKG_F100_REL=${PKG_FNTS_REL}
  export PKG_FCYR_REL=${PKG_FNTS_REL}
export PKG_FSCL_REL=1
export PKG_FSRV_REL=1
export PKG_LIBS_DATA_REL=1
export PKG_MAN_PAGES_REL=1
  export PKG_MAN_PAGES_HTML_REL=${PKG_MAN_PAGES_REL}
export PKG_NEST_REL=1
export PKG_VFB_REL=1
export PKG_XWIN_REL=1

# base
export PKG_BASE=${PKG}-base
export FULLPKG_BASE=${PKG_BASE}-${VER}-${PKG_BASE_REL}
export bin_pkg_name_base=${FULLPKG_BASE}.tar.bz2
export bin_pkg_base=${topdir}/${bin_pkg_name_base}
export src_pkg_base_name=${FULLPKG_BASE}-src.tar.bz2
export src_pkg_base=${topdir}/${src_pkg_base_name}

# bin
export PKG_BIN=${PKG}-bin
export FULLPKG_BIN=${PKG_BIN}-${VER}-${PKG_BIN_REL}
export bin_pkg_name_bin=${FULLPKG_BIN}.tar.bz2
export bin_pkg_bin=${topdir}/${bin_pkg_name_bin}
export src_pkg_bin_name=${FULLPKG_BIN}-src.tar.bz2
export src_pkg_bin=${topdir}/${src_pkg_bin_name}

# bin-dlls
export PKG_BIN_DLLS=${PKG}-bin-dlls
export FULLPKG_BIN_DLLS=${PKG_BIN_DLLS}-${VER}-${PKG_BIN_DLLS_REL}
export bin_pkg_name_bin_dlls=${FULLPKG_BIN_DLLS}.tar.bz2
export bin_pkg_bin_dlls=${topdir}/${bin_pkg_name_bin_dlls}
export src_pkg_bin_dlls_name=${FULLPKG_BIN_DLLS}-src.tar.bz2
export src_pkg_bin_dlls=${topdir}/${src_pkg_bin_dlls_name}

# bin-lndir
export PKG_BIN_LNDIR=${PKG}-bin-lndir
export FULLPKG_BIN_LNDIR=${PKG_BIN_LNDIR}-${VER}-${PKG_BIN_LNDIR_REL}
export bin_pkg_name_bin_lndir=${FULLPKG_BIN_LNDIR}.tar.bz2
export bin_pkg_bin_lndir=${topdir}/${bin_pkg_name_bin_lndir}
export src_pkg_bin_lndir_name=${FULLPKG_BIN_LNDIR}-src.tar.bz2
export src_pkg_bin_lndir=${topdir}/${src_pkg_bin_lndir_name}

# devel
export PKG_DEVEL=${PKG}-devel
export FULLPKG_DEVEL=${PKG_DEVEL}-${VER}-${PKG_DEVEL_REL}
export bin_pkg_name_devel=${FULLPKG_DEVEL}.tar.bz2
export bin_tar_name_devel=${FULLPKG_DEVEL}.tar
export bin_pkg_devel=${topdir}/${bin_pkg_name_devel}
export bin_tar_devel=${topdir}/${bin_tar_name_devel}
export src_pkg_devel_name=${FULLPKG_DEVEL}-src.tar.bz2
export src_pkg_devel=${topdir}/${src_pkg_devel_name}

# etc
export PKG_ETC=${PKG}-etc
export FULLPKG_ETC=${PKG_ETC}-${VER}-${PKG_ETC_REL}
export bin_pkg_name_etc=${FULLPKG_ETC}.tar.bz2
export bin_pkg_etc=${topdir}/${bin_pkg_name_etc}

# f100
export PKG_F100=${PKG}-f100
export FULLPKG_F100=${PKG_F100}-${VER}-${PKG_F100_REL}
export bin_pkg_name_f100=${FULLPKG_F100}.tar.bz2
export bin_pkg_f100=${topdir}/${bin_pkg_name_f100}

# fcyr
export PKG_FCYR=${PKG}-fcyr
export FULLPKG_FCYR=${PKG_FCYR}-${VER}-${PKG_FCYR_REL}
export bin_pkg_name_fcyr=${FULLPKG_FCYR}.tar.bz2
export bin_pkg_fcyr=${topdir}/${bin_pkg_name_fcyr}

# fenc
export PKG_FENC=${PKG}-fenc
export FULLPKG_FENC=${PKG_FENC}-${VER}-${PKG_FENC_REL}
export bin_pkg_name_fenc=${FULLPKG_FENC}.tar.bz2
export bin_pkg_fenc=${topdir}/${bin_pkg_name_fenc}
export src_pkg_fenc_name=${FULLPKG_FENC}-src.tar.bz2
export src_pkg_fenc=${topdir}/${src_pkg_fenc_name}

# fnts
export PKG_FNTS=${PKG}-fnts
export FULLPKG_FNTS=${PKG_FNTS}-${VER}-${PKG_FNTS_REL}
export bin_pkg_name_fnts=${FULLPKG_FNTS}.tar.bz2
export bin_pkg_fnts=${topdir}/${bin_pkg_name_fnts}
export src_pkg_fnts_name=${FULLPKG_FNTS}-src.tar.bz2
export src_pkg_fnts=${topdir}/${src_pkg_fnts_name}

# fscl
export PKG_FSCL=${PKG}-fscl
export FULLPKG_FSCL=${PKG_FSCL}-${VER}-${PKG_FSCL_REL}
export bin_pkg_name_fscl=${FULLPKG_FSCL}.tar.bz2
export bin_pkg_fscl=${topdir}/${bin_pkg_name_fscl}
export src_pkg_fscl_name=${FULLPKG_FSCL}-src.tar.bz2
export src_pkg_fscl=${topdir}/${src_pkg_fscl_name}

# fsrv
export PKG_FSRV=${PKG}-fsrv
export FULLPKG_FSRV=${PKG_FSRV}-${VER}-${PKG_FSRV_REL}
export bin_pkg_name_fsrv=${FULLPKG_FSRV}.tar.bz2
export bin_pkg_fsrv=${topdir}/${bin_pkg_name_fsrv}

# libs-data
export PKG_LIBS_DATA=${PKG}-libs-data
export FULLPKG_LIBS_DATA=${PKG_LIBS_DATA}-${VER}-${PKG_LIBS_DATA_REL}
export bin_pkg_name_libs_data=${FULLPKG_LIBS_DATA}.tar.bz2
export bin_pkg_libs_data=${topdir}/${bin_pkg_name_libs_data}

# man-pages
export PKG_MAN_PAGES=${PKG}-man-pages
export FULLPKG_MAN_PAGES=${PKG_MAN_PAGES}-${VER}-${PKG_MAN_PAGES_REL}
export bin_pkg_name_man_pages=${FULLPKG_MAN_PAGES}.tar.bz2
export bin_pkg_man_pages=${topdir}/${bin_pkg_name_man_pages}
export src_pkg_man_pages_name=${FULLPKG_MAN_PAGES}-src.tar.bz2
export src_pkg_man_pages=${topdir}/${src_pkg_man_pages_name}

# man-pages-html
export PKG_MAN_PAGES_HTML=${PKG}-man-pages-html
export FULLPKG_MAN_PAGES_HTML=${PKG_MAN_PAGES_HTML}-${VER}-${PKG_MAN_PAGES_HTML_REL}
export bin_pkg_name_man_pages_html=${FULLPKG_MAN_PAGES_HTML}.tar.bz2
export bin_pkg_man_pages_html=${topdir}/${bin_pkg_name_man_pages_html}

# nest
export PKG_NEST=${PKG}-nest
export FULLPKG_NEST=${PKG_NEST}-${VER}-${PKG_NEST_REL}
export bin_pkg_name_nest=${FULLPKG_NEST}.tar.bz2
export bin_pkg_nest=${topdir}/${bin_pkg_name_nest}

# vfb
export PKG_VFB=${PKG}-vfb
export FULLPKG_VFB=${PKG_VFB}-${VER}-${PKG_VFB_REL}
export bin_pkg_name_vfb=${FULLPKG_VFB}.tar.bz2
export bin_pkg_vfb=${topdir}/${bin_pkg_name_vfb}

# xwin
export PKG_XWIN=${PKG}-xwin
export FULLPKG_XWIN=${PKG_XWIN}-${VER}-${PKG_XWIN_REL}
export bin_pkg_name_xwin=${FULLPKG_XWIN}.tar.bz2
export bin_pkg_xwin=${topdir}/${bin_pkg_name_xwin}
export src_pkg_xwin_name=${FULLPKG_XWIN}-src.tar.bz2
export src_pkg_xwin=${topdir}/${src_pkg_xwin_name}

# xwin-gl
export PKG_XWIN_GL=${PKG}-xwin-gl
export FULLPKG_XWIN_GL=${PKG_XWIN_GL}-${VER}-${PKG_XWIN_REL}
export bin_pkg_name_xwin_gl=${FULLPKG_XWIN_GL}.tar.bz2
export bin_pkg_xwin_gl=${topdir}/${bin_pkg_name_xwin_gl}

export srcdir=${topdir}/xc
export objdir=${topdir}/.build
export instdir=${topdir}/.inst
export srcinstdir=${topdir}/.sinst

if test "x$prefix" = "x" ; then
  prefix=/usr/X11R6
fi
pnoslash=`echo $prefix | sed -e 's#^/##'`
if test "x$sysconfdir" = "x" ; then
  sysconfdir=/etc
fi
sysconfx11dir=${sysconfdir}/X11
sx11noslash=`echo $sysconfx11dir | sed -e 's#^/##'`
snoslash=`echo $sysconfdir | sed -e 's#^/##'`
MY_CFLAGS="-O2"
MY_LDFLAGS=

EXCLUDE_SPKG="--exclude=CVS \
              --exclude=*~ \
              --exclude=.#* \
              --exclude=*.stackdump"
    

mkdirs() {
  (cd ${topdir} && \
  mkdir -p ${instdir} && \
  mkdir -p ${objdir} && \
  mkdir -p ${srcinstdir} )
}
conf() {
  (cd ${objdir} && \
  lndir -silent ${srcdir} && \
  rm -rf .sinst .inst .build )
}
mk_host_def() {
  (cd ${objdir} && \
  if test -L config/cf/host.def ; then \
    rm -f config/cf/host.def ; \
  fi ; && \
  sed \
    -e "s%@prefix@%${prefix}%g" \
    -e "s%@sysconfx11dir@%${sysconfx11dir}%g" \
    -e "s%@PKG_XWIN_REL@%${PKG_XWIN_REL}%g" \
     ${scriptdir}/host.def.in > config/cf/host.def
  )  
}
build() {
  (cd ${objdir} && \
  mk_host_def && \
  CFLAGS="${MY_CFLAGS}" make Makefile.boot && \
  CFLAGS="${MY_CFLAGS}" make VerifyOS && \
  CFLAGS="${MY_CFLAGS}" make Everything
  )
}
build_xwin() {
  (cd ${objdir} && \
  mk_host_def && \ 
  make -C ${objdir}/programs/Xserver Makefile && \
  make -C ${objdir}/programs/Xserver Makefiles && \
  cd ${objdir}/programs/Xserver && \
  make XWin.exe XWin_GL.exe && \
  strip XWin.exe XWin_GL.exe
  )
}
check() {
  echo 'This package has no check routine' 
}
quickclean() {
  (cd ${topdir} && \
  rm -rf ${instdir}/ && \
  rm -rf ${objdir}/ && \
  rm -rf ${srcinstdir}/ )
}
clean() {
  (cd ${objdir} && \
  make clean )
}
install() {
  (cd ${objdir} && \
  make install install.man DESTDIR=${instdir} )
}
install_xwin() {
  (cd ${objdir}/programs/Xserver && \
  make install install.man DESTDIR=${instdir} )
}
install_local() {
  (cd ${objdir} && \
  for d in ${prefix}/share/doc/Cygwin \
           /etc/postinstall /etc/profile.d \
           /usr/bin /usr/lib /usr/include \
           ${prefix}/share/doc/${PKG_XWIN}; do
    if [ ! -d ${instdir}${d} ] ; then
      mkdir -p ${instdir}${d} ;\
    fi ;\
  done
  mv ${topdir}/*.lst ${scriptdir}/
  mkdir -p ${objdir}/CYGWIN-PATCHES/xwin-changelog
  for p in base bin bin-dlls bin-lndir devel etc \
           f100 fcyr fenc fnts fscl fsrv libs-data \
           man-pages man-pages-html nest vfb xwin xwin-gl ; do
    if test -L ${objdir}/CYGWIN-PATCHES/${p}.hint ; then
      rm -f ${objdir}/CYGWIN-PATCHES/${p}.hint ; \
    fi ; && \
    if test -e ${scriptdir}/${p}.hint.in ; then
      sed -e "s%@PKG@%${PKG}%g" \
        -e "s%@CATEGORY@%${CATEGORY}%g" \
        ${scriptdir}/${p}.hint.in \
        > ${objdir}/CYGWIN-PATCHES/${p}.hint ; \
    fi ; && \
    if test -e ${scriptdir}/${p}.lst ; then
      mv ${scriptdir}/${p}.lst \
        ${scriptdir}/${p}.lst.in && \
      sort ${scriptdir}/${p}.lst.in \
        > ${scriptdir}/${p}.lst && \
      rm -f ${scriptdir}/${p}.lst.in && \
      sed -i -e "/\/$/d" ${scriptdir}/${p}.lst ; \
    fi ; && \
    if test -e ${scriptdir}/${p}.frag ; then
      cat ${scriptdir}/${p}.frag \
        ${scriptdir}/README.frag.top \
        ${scriptdir}/${p}.lst \
        ${scriptdir}/README.frag.bottom > \
        ${instdir}${prefix}/share/doc/Cygwin/${PKG}-${p}-${VER}.README ; \
    fi ; \
  done 
  for p in base devel fonts libs-data man-pages xwin ; do
    for suffix in profile_d.csh profile_d.sh postinstall ; do
      if test -e ${scriptdir}/${p}.${suffix}.in ; then
	file=${p}.${suffix} ; \
      else
	continue ; \
      fi ; && \
      if test -L ${objdir}/CYGWIN-PATCHES/${file} ; then
	rm ${objdir}/CYGWIN-PATCHES/${file} ; \
      fi ; && \
      sed -e "s%@prefix@%${prefix}%g" -e "s%@sysconfx11dir@%${sysconfx11dir}%g" \
        ${scriptdir}/$file.in \
        > ${objdir}/CYGWIN-PATCHES/${file} ; \
    done ; \
  done && \
  sed -e "s%@prefix@%${prefix}%g" -e "s%@sysconfx11dir@%${sysconfx11dir}%g" \
    ${scriptdir}/font-update.in \
    > ${objdir}/CYGWIN-PATCHES/font-update && \
  /usr/bin/install -m 755 ${objdir}/CYGWIN-PATCHES/font-update \
  ${instdir}${prefix}/bin/font-update ; && \
  /usr/bin/install -m 755 ${objdir}/CYGWIN-PATCHES/devel.postinstall \
       ${instdir}/etc/postinstall/${PKG_DEVEL}.sh && \
  if test -e ${objdir}/CYGWIN-PATCHES/fonts.postinstall ; then
    /usr/bin/install -m 755 ${objdir}/CYGWIN-PATCHES/fonts.postinstall \
         ${instdir}/etc/postinstall/${PKG_F100}.sh && \
    /usr/bin/install -m 755 ${objdir}/CYGWIN-PATCHES/fonts.postinstall \
         ${instdir}/etc/postinstall/${PKG_FCYR}.sh && \
    /usr/bin/install -m 755 ${objdir}/CYGWIN-PATCHES/fonts.postinstall \
         ${instdir}/etc/postinstall/${PKG_FENC}.sh && \
    /usr/bin/install -m 755 ${objdir}/CYGWIN-PATCHES/fonts.postinstall \
         ${instdir}/etc/postinstall/${PKG_FNTS}.sh && \
    /usr/bin/install -m 755 ${objdir}/CYGWIN-PATCHES/fonts.postinstall \
         ${instdir}/etc/postinstall/${PKG_FSCL}.sh ; \
  fi ; && \
  /usr/bin/install -m 755 ${objdir}/CYGWIN-PATCHES/libs-data.postinstall \
       ${instdir}/etc/postinstall/${PKG_LIBS_DATA}.sh && \
  /usr/bin/install -m 755 ${objdir}/CYGWIN-PATCHES/xwin.postinstall \
       ${instdir}/etc/postinstall/${PKG_XWIN}.sh && \
  /usr/bin/install -m 755 ${objdir}/CYGWIN-PATCHES/base.profile_d.csh \
       ${instdir}/etc/profile.d/00${PKG_BASE}.csh && \
  /usr/bin/install -m 755 ${objdir}/CYGWIN-PATCHES/base.profile_d.sh \
       ${instdir}/etc/profile.d/00${PKG_BASE}.sh && \
  /usr/bin/install -m 755 ${objdir}/CYGWIN-PATCHES/devel.profile_d.csh \
       ${instdir}/etc/profile.d/${PKG_DEVEL}.csh && \
  /usr/bin/install -m 755 ${objdir}/CYGWIN-PATCHES/devel.profile_d.sh \
       ${instdir}/etc/profile.d/${PKG_DEVEL}.sh && \
  if test -e ${objdir}/CYGWIN-PATCHES/man-pages.profile_d.csh ; then
    /usr/bin/install -m 755 ${objdir}/CYGWIN-PATCHES/man-pages.profile_d.csh \
       ${instdir}/etc/profile.d/${PKG_MAN_PAGES}.csh ; \
  fi ; && \
  if test -e ${objdir}/CYGWIN-PATCHES/man-pages.profile_d.sh ; then
  /usr/bin/install -m 755 ${objdir}/CYGWIN-PATCHES/man-pages.profile_d.sh \
       ${instdir}/etc/profile.d/${PKG_MAN_PAGES}.sh ; \
  fi ; && \
  sed -e "/<\!--#include.*leftbar\.html\" -->$/r ${scriptdir}/xwin-changelog/leftbar.html" \
    -e "/<\!--#include.*leftbar\.html\" -->$/d" \
    ${scriptdir}/xwin-changelog/header.html.in > \
    ${objdir}/CYGWIN-PATCHES/xwin-changelog/header.html && \
  sed -e "/<\!--#include.*header\.html\" -->$/r ${objdir}/CYGWIN-PATCHES/xwin-changelog/header.html" \
    -e "/<\!--#include.*header\.html\" -->$/d" \
    -e "/<\!--#include.*footer\.html\" -->$/r ${scriptdir}/xwin-changelog/footer.html" \
    -e "/<\!--#include.*footer\.html\" -->$/d" \
    -e "/<\!--#include.*entries-150\.html\" -->$/r ${scriptdir}/xwin-changelog/entries-150.html" \
    -e "/<\!--#include.*entries-150\.html\" -->$/d" \
    -e "/<\!--#include.*entries-125\.html\" -->$/r ${scriptdir}/xwin-changelog/entries-125.html" \
    -e "/<\!--#include.*entries-125\.html\" -->$/d" \
    -e "/<\!--#include.*entries-100\.html\" -->$/r ${scriptdir}/xwin-changelog/entries-100.html" \
    -e "/<\!--#include.*entries-100\.html\" -->$/d" \
    -e "/<\!--#include.*entries-075\.html\" -->$/r ${scriptdir}/xwin-changelog/entries-075.html" \
    -e "/<\!--#include.*entries-075\.html\" -->$/d" \
    -e "/<\!--#include.*entries-050\.html\" -->$/r ${scriptdir}/xwin-changelog/entries-050.html" \
    -e "/<\!--#include.*entries-050\.html\" -->$/d" \
    -e "/<\!--#include.*entries-025\.html\" -->$/r ${scriptdir}/xwin-changelog/entries-025.html" \
    -e "/<\!--#include.*entries-025\.html\" -->$/d" \
    -e "/<\!--#include.*entries-001\.html\" -->$/r ${scriptdir}/xwin-changelog/entries-001.html" \
    -e "/<\!--#include.*entries-001\.html\" -->$/d" \
    ${scriptdir}/xwin-changelog/changelog.html.in > \
    ${objdir}/CYGWIN-PATCHES/xwin-changelog/changelog.html && \
  /usr/bin/install -m644 \
       ${objdir}/CYGWIN-PATCHES/xwin-changelog/changelog.html \
       ${instdir}${prefix}/share/doc/${PKG_XWIN}/changelog.html && \
  /usr/bin/install -m644 \
       ${scriptdir}/xwin-changelog/changelog.css \
       ${instdir}${prefix}/share/doc/${PKG_XWIN}/changelog.css && \
  /usr/bin/install -m 644 \
       ${scriptdir}/xwin-changelog/valid-xhtml10.png \
       ${instdir}${prefix}/share/doc/${PKG_XWIN}/valid-xhtml10.png & \
  /usr/bin/install -m 644 \
       ${scriptdir}/xwin-changelog/vcss.png \
       ${instdir}${prefix}/share/doc/${PKG_XWIN}/vcss.png
  # create symlink /usr/bin/X11 -> /usr/X11R6/bin, from LSB
  ln -vnsf ../X11R6/bin ${instdir}/usr/bin/X11
  # create symlink /usr/lib/X11 -> /usr/X11R6/lib/X11, from LSB
  ln -vnsf ../X11R6/lib/X11 ${instdir}/usr/lib/X11
  # create symlink /usr/include/X11 -> /usr/X11R6/include/X11, from LSB
  ln -vnsf ../X11R6/include/X11 ${instdir}/usr/include/X11
  )
}
list() {
  (cd ${topdir} && \
  find . -maxdepth 1 -name "*.lst" | xargs sed -i -e 's/\.\/\(.*\)/\1/' -e '/.*\/$/d' && \
  find . -maxdepth 1 -name "*.lst" | xargs -i cp {} {}.in && \
  find . -maxdepth 1 -name "*.lst" | xargs -i sort -o {} {}.in && \
  rm -f *.lst.in && \
  cp *.lst ${scriptdir}/ )
}
strip() {
  (cd ${instdir} && \
  find . -name "*.exe" -o -name "*.dll" | xargs strip > /dev/null 2>&1
  true )
}
pkg() {
  (pkg_base && \
  pkg_bin && \
  pkg_bin_dlls && \
  pkg_bin_lndir && \
  pkg_devel && \
  pkg_etc && \
  pkg_f100 && \
  pkg_fcyr && \
  pkg_fenc && \
  pkg_fnts && \
  pkg_fscl && \
  pkg_fsrv && \
  pkg_libs_data && \
  pkg_man_pages && \
  pkg_man_pages_html && \
  pkg_nest && \
  pkg_vfb && \
  pkg_xwin
  )
}
pkg_base() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg_base} \
    ${pnoslash}/share/doc/Cygwin/${PKG_BASE}-${VER}.README \
    etc/profile.d/00${PKG_BASE}.csh \
    etc/profile.d/00${PKG_BASE}.sh \
    > ${topdir}/base.lst
  )
}
pkg_bin() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg_bin} \
    ${pnoslash}/share/doc/Cygwin/${PKG_BIN}-${VER}.README \
    ${pnoslash}/bin/ \
    --exclude="${pnoslash}/bin/*.dll" \
    --exclude="${pnoslash}/bin/*-config" \
    --exclude=${pnoslash}/bin/lndir.exe \
    --exclude=${pnoslash}/bin/startx \
    --exclude=${pnoslash}/bin/X \
    --exclude=${pnoslash}/bin/xfs.exe \
    --exclude=${pnoslash}/bin/Xnest.exe \
    --exclude=${pnoslash}/bin/Xvfb.exe \
    --exclude=${pnoslash}/bin/XWin.exe \
    --exclude=${pnoslash}/bin/XWin_GL.exe \
    > ${topdir}/bin.lst
  )
}
pkg_bin_dlls() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg_bin_dlls} \
    ${pnoslash}/share/doc/Cygwin/${PKG_BIN_DLLS}-${VER}.README \
    ${pnoslash}/bin/*.dll \
    usr/bin/X11 \
    --exclude=${pnoslash}/bin/cygXft-1.dll \
    --exclude=${pnoslash}/bin/cygXft-2.dll \
    > ${topdir}/bin-dlls.lst
  )
}
pkg_bin_lndir() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg_bin_lndir} \
    ${pnoslash}/share/doc/Cygwin/${PKG_BIN_LNDIR}-${VER}.README \
    ${pnoslash}/bin/lndir.exe \
    > ${topdir}/bin-lndir.lst
  )
}
pkg_devel() {
  (cd ${instdir} && \
  rm -f ${bin_pkg_devel} && \
  tar cvf ${bin_tar_devel} \
    ${pnoslash}/share/doc/Cygwin/${PKG_DEVEL}-${VER}.README \
    etc/postinstall/${PKG_DEVEL}.sh \
    etc/profile.d/${PKG_DEVEL}.csh \
    etc/profile.d/${PKG_DEVEL}.sh \
    ${pnoslash}/bin/*-config \
    ${pnoslash}/include/ \
    ${pnoslash}/lib/ \
    usr/include/X11 \
    --exclude=${pnoslash}/bin/xft-config \
    --exclude=${pnoslash}/include/X11/Xft \
    --exclude="${pnoslash}/lib/libXft*" \
    --exclude=${pnoslash}/lib/pkgconfig/xft.pc \
    --exclude=${pnoslash}/lib/X11 \
    --exclude=${pnoslash}/include/X11/bitmaps \
    > ${topdir}/devel.lst.in && \
  tar rvf ${bin_tar_devel} \
    ${pnoslash}/lib/X11/config/ \
    >> ${topdir}/devel.lst.in && \
  bzip2 ${bin_tar_devel} && \
  sort -i ${topdir}/devel.lst.in -o ${topdir}/devel.lst && \
  rm -f ${topdir}/devel.lst.in
  )
}
pkg_etc() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg_etc} \
    ${pnoslash}/share/doc/Cygwin/${PKG_ETC}-${VER}.README \
    ${sx11noslash}/ \
    --exclude=${sx11noslash}/xinit \
    > ${topdir}/etc.lst
  )
}
pkg_f100() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg_f100} \
    ${pnoslash}/share/doc/Cygwin/${PKG_F100}-${VER}.README \
    etc/postinstall/${PKG_F100}.sh \
    ${pnoslash}/lib/X11/fonts/100dpi \
    > ${topdir}/f100.lst
  )
}
pkg_fcyr() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg_fcyr} \
    ${pnoslash}/share/doc/Cygwin/${PKG_FCYR}-${VER}.README \
    etc/postinstall/${PKG_FCYR}.sh \
    ${pnoslash}/lib/X11/fonts/cyrillic \
    > ${topdir}/fcyr.lst
  )
}
pkg_fenc() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg_fenc} \
    ${pnoslash}/share/doc/Cygwin/${PKG_FENC}-${VER}.README \
    etc/postinstall/${PKG_FENC}.sh \
    ${pnoslash}/lib/X11/fonts/encodings \
    > ${topdir}/fenc.lst
  )
}
pkg_fnts() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg_fnts} \
    ${pnoslash}/share/doc/Cygwin/${PKG_FNTS}-${VER}.README \
    etc/postinstall/${PKG_FNTS}.sh \
    ${pnoslash}/lib/X11/fonts/75dpi \
    ${pnoslash}/lib/X11/fonts/misc \
    ${pnoslash}/lib/X11/fonts/util \
    > ${topdir}/fnts.lst
  )
}
pkg_fscl() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg_fscl} \
    ${pnoslash}/share/doc/Cygwin/${PKG_FSCL}-${VER}.README \
    etc/postinstall/${PKG_FSCL}.sh \
    ${pnoslash}/lib/X11/fonts/Type1 \
    ${pnoslash}/lib/X11/fonts/TTF \
    > ${topdir}/fscl.lst
  )
}
pkg_fsrv() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg_fsrv} \
    ${pnoslash}/share/doc/Cygwin/${PKG_FSRV}-${VER}.README \
    ${pnoslash}/bin/xfs.exe \
    ${pnoslash}/man/man1/xfs.1 \
    ${pnoslash}/lib/X11/doc/html/xfs.1.html \
    > ${topdir}/fsrv.lst
  )
}
pkg_libs_data() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg_libs_data} \
    ${pnoslash}/share/doc/Cygwin/${PKG_LIBS_DATA}-${VER}.README \
    etc/postinstall/${PKG_LIBS_DATA}.sh \
    usr/lib/X11 \
    ${pnoslash}/lib/X11/ \
    ${pnoslash}/include/X11/bitmaps/ \
    --exclude=${pnoslash}/lib/X11/config \
    --exclude=${pnoslash}/lib/X11/doc \
    --exclude=${pnoslash}/lib/X11/fonts \
    --exclude=${pnoslash}/lib/X11/app-defaults \
    --exclude=${pnoslash}/lib/X11/fs \
    --exclude=${pnoslash}/lib/X11/lbxproxy \
    --exclude=${pnoslash}/lib/X11/proxymngr \
    --exclude=${pnoslash}/lib/X11/rstart \
    --exclude=${pnoslash}/lib/X11/twm \
    --exclude=${pnoslash}/lib/X11/xdm \
    --exclude=${pnoslash}/lib/X11/xinit \
    --exclude=${pnoslash}/lib/X11/xkb \
    --exclude=${pnoslash}/lib/X11/xserver \
    --exclude=${pnoslash}/lib/X11/xsm \
    > ${topdir}/libs-data.lst
  )
}
pkg_man_pages() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg_man_pages} \
    ${pnoslash}/share/doc/Cygwin/${PKG_MAN_PAGES}-${VER}.README \
    etc/profile.d/${PKG_MAN_PAGES}.csh \
    etc/profile.d/${PKG_MAN_PAGES}.sh \
    ${pnoslash}/man/ \
    --exclude=${pnoslash}/man/man1/xfs.1 \
    --exclude=${pnoslash}/man/man1/Xnest.1 \
    --exclude=${pnoslash}/man/man1/Xvfb.1 \
    --exclude=${pnoslash}/man/man1/XWin.1 \
    --exclude=${pnoslash}/man/man1/XWinrc.1 \
    --exclude=${pnoslash}/man/man3/Xft.3 \
    > ${topdir}/man-pages.lst
  )
}
pkg_man_pages_html() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg_man_pages_html} \
    ${pnoslash}/share/doc/Cygwin/${PKG_MAN_PAGES_HTML}-${VER}.README \
    ${pnoslash}/lib/X11/doc/html/ \
    --exclude=${pnoslash}/lib/X11/doc/html/xfs.1.html \
    --exclude=${pnoslash}/lib/X11/doc/html/Xnest.1.html \
    --exclude=${pnoslash}/lib/X11/doc/html/Xvfb.1.html \
    --exclude=${pnoslash}/lib/X11/doc/html/XWin.1.html \
    --exclude=${pnoslash}/lib/X11/doc/html/XWinrc.1.html \
    --exclude=${pnoslash}/lib/X11/doc/html/Xft.3.html \
    > ${topdir}/man-pages-html.lst
  )
}
pkg_nest() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg_nest} \
    ${pnoslash}/share/doc/Cygwin/${PKG_NEST}-${VER}.README \
    ${pnoslash}/bin/Xnest.exe \
    ${pnoslash}/man/man1/Xnest.1 \
    ${pnoslash}/lib/X11/doc/html/Xnest.1.html \
    > ${topdir}/nest.lst
  )
}
pkg_vfb() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg_vfb} \
    ${pnoslash}/share/doc/Cygwin/${PKG_VFB}-${VER}.README \
    ${pnoslash}/bin/Xvfb.exe \
    ${pnoslash}/man/man1/Xvfb.1 \
    ${pnoslash}/lib/X11/doc/html/Xvfb.1.html \
    > ${topdir}/vfb.lst
  )
}
pkg_xwin() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg_xwin} \
    ${pnoslash}/share/doc/Cygwin/${PKG_XWIN}-${VER}.README \
    ${pnoslash}/share/doc/${PKG_XWIN}/ \
    etc/postinstall/${PKG_XWIN}.sh \
    ${pnoslash}/bin/XWin.exe \
    ${pnoslash}/man/man1/XWin.1 \
    ${pnoslash}/man/man1/XWinrc.1 \
    ${pnoslash}/lib/X11/doc/html/XWin.1.html \
    ${pnoslash}/lib/X11/doc/html/XWinrc.1.html \
    > ${topdir}/xwin.lst
  )
  (cd ${instdir} && \
  tar cvjf ${bin_pkg_xwin_gl} \
    ${pnoslash}/share/doc/Cygwin/${PKG_XWIN_GL}-${VER}.README \
    ${pnoslash}/bin/XWin_GL.exe \
    > ${topdir}/xwin-gl.lst
  )
}
spkg() {
  (spkg_base && \
  spkg_bin && \
  spkg_bin_dlls && \
  spkg_devel && \
  spkg_fenc && \
  spkg_fnts && \
  spkg_fscl && \
  spkg_man_pages && \
  spkg_xwin
  )
}
spkg_base() {
  (cd ${topdir} && \
  test -e $0 && cp $0 ${patchdir}/ 
  tar cvjf ${src_pkg_base} \
    ${patchdir}/$0 \
    ${patchdir}/base* \
    ${patchdir}/etc* \
    ${patchdir}/host.def.in \
    ${patchdir}/lib* \
    ${patchdir}/README.frag.* \
    ${patchdir}/font-update.in \
    xc/config/ \
    xc/doc/ \
    xc/extras/ \
    xc/nls/ \
    xc/BUILD \
    xc/ChangeLog \
    xc/Imakefile \
    xc/LABEL \
    xc/README \
    xc/Makefile \
    xc/registry \
    xc/RELNOTES \
    $EXCLUDE_SPKG \
    --exclude=xc/doc/hardcopy \
    --exclude=xc/doc/man \
    --exclude=xc/doc/specs \
    --exclude=xc/extras/expat \
    --exclude=xc/extras/fontconfig \
    --exclude=xc/extras/freetype2 \
    --exclude=xc/extras/regex \
    --exclude=xc/extras/x86emu \
    --exclude=xc/extras/zlib
  )
}
spkg_bin() {
  (cd ${topdir} && \
  tar cvjf ${src_pkg_bin} \
    ${patchdir}/bin* \
    ${patchdir}/fsrv* \
    xc/programs/ \
    $EXCLUDE_SPKG \
    --exclude="${patchdir}/bin-dlls*" \
    --exclude=xc/programs/Xserver \
    --exclude=xc/programs/beforelight \
    --exclude=xc/programs/xf86dga \
    --exclude=xc/programs/xieperf \
    --exclude=xc/programs/xrx \
    --exclude=xc/programs/xterm
  )
}
spkg_bin_dlls() {
  (cd ${topdir} && \
  tar cvjf ${src_pkg_bin_dlls} \
    ${patchdir}/bin-dlls* \
    xc/lib/ \
    $EXCLUDE_SPKG \
    --exclude=xc/lib/fontconfig \
    --exclude=xc/lib/GL/mesa/src/drv \
    --exclude=xc/lib/PEX5 \
    --exclude=xc/lib/regex \
    --exclude=xc/lib/XIE \
    --exclude=xc/lib/XvMC \
    --exclude=xc/lib/Xxf86dga \
    --exclude=xc/lib/Xxf86misc \
    --exclude=xc/lib/Xxf86rush \
    --exclude=xc/lib/Xxf86vm \
    --exclude=xc/lib/zlib
  )
}
spkg_devel() {
  (cd ${topdir} && \
  tar cvjf ${src_pkg_devel} \
    ${patchdir}/devel* \
    xc/include/ \
    $EXCLUDE_SPKG 
  )
}
spkg_fenc() {
  (cd ${topdir} && \
  tar cvjf ${src_pkg_fenc} \
    ${patchdir}/fenc* \
    xc/fonts/encodings/ \
    $EXCLUDE_SPKG 
  )
}
spkg_fnts() {
  (cd ${topdir} && \
  tar cvjf ${src_pkg_fnts} \
    ${patchdir}/f100* \
    ${patchdir}/fcyr* \
    ${patchdir}/fonts* \
    ${patchdir}/fnts* \
    xc/fonts/ \
    $EXCLUDE_SPKG \
    --exclude=xc/fonts/encodings \
    --exclude=xc/fonts/scaled
  )
}
spkg_fscl() {
  (cd ${topdir} && \
  tar cvjf ${src_pkg_fscl} \
    ${patchdir}/fscl* \
    xc/fonts/scaled/ \
    $EXCLUDE_SPKG 
  )
}
spkg_man_pages() {
  (cd ${topdir} && \
  tar cvjf ${src_pkg_man_pages} \
    ${patchdir}/man-pages* \
    ${patchdir}/man-pages-html* \
    xc/doc/man/ \
    $EXCLUDE_SPKG 
  )
}
spkg_xwin() {
  (cd ${topdir} && \
  tar cvjf ${src_pkg_xwin} \
    ${patchdir}/nest* \
    ${patchdir}/vfb* \
    ${patchdir}/xwin* \
    xc/programs/Xserver/ \
    $EXCLUDE_SPKG \
    --exclude=xc/programs/Xserver/afb \
    --exclude=xc/programs/Xserver/dixlbx \
    --exclude=xc/programs/Xserver/ilbm \
    --exclude=xc/programs/Xserver/iplan2p2 \
    --exclude=xc/programs/Xserver/iplan2p4 \
    --exclude=xc/programs/Xserver/iplan2p8 \
    --exclude=xc/programs/Xserver/lmfcfb \
    --exclude=xc/programs/Xserver/PEX5 \
    --exclude=xc/programs/Xserver/hw/darwin \
    --exclude=xc/programs/Xserver/hw/dec \
    --exclude=xc/programs/Xserver/hw/hp \
    --exclude=xc/programs/Xserver/hw/ibm \
    --exclude=xc/programs/Xserver/hw/kdrive \
    --exclude=xc/programs/Xserver/hw/macII \
    --exclude=xc/programs/Xserver/hw/omron \
    --exclude=xc/programs/Xserver/hw/sun \
    --exclude=xc/programs/Xserver/hw/sunAmoeba \
    --exclude=xc/programs/Xserver/hw/sunLynx \
    --exclude=xc/programs/Xserver/hw/svga \
    --exclude=xc/programs/Xserver/hw/wvfb \
    --exclude=xc/programs/Xserver/hw/xfree68 \
    --exclude=xc/programs/Xserver/hw/xfree86 \
    --exclude=xc/programs/Xserver/hw/xfree98 \
    --exclude="xc/programs/Xserver/hw/xwin-*" \
    --exclude=xc/programs/Xserver/oslbx \
    --exclude=xc/programs/Xserver/pandix \
    --exclude=xc/programs/Xserver/panmi \
    --exclude=xc/programs/Xserver/XIE \
    --exclude=xc/programs/Xserver/XpConfig \
    --exclude=xc/programs/Xserver/Xst
  )
}
huge_spkg() {
  (cd ${topdir} && \
  tar cvjf ${src_pkg} \
    xc/ \
    $EXCLUDE_SPKG \
    --exclude=xc/.build \
    --exclude=xc/.inst \
    --exclude=xc/.sinst \
    --exclude=xc/doc/specs \
    --exclude=xc/doc/hardcopy \
    --exclude=xc/extras/expat \
    --exclude=xc/extras/freetype2 \
    --exclude=xc/extras/regex \
    --exclude=xc/extras/x86emu \
    --exclude=xc/lib/fontconfig \
    --exclude=xc/lib/PEX5 \
    --exclude=xc/lib/regex \
    --exclude=xc/lib/XIE \
    --exclude=xc/lib/XvMC \
    --exclude=xc/lib/Xxf86dga \
    --exclude=xc/lib/Xxf86misc \
    --exclude=xc/lib/Xxf86rush \
    --exclude=xc/lib/Xxf86vm \
    --exclude=xc/lib/zlib \
    --exclude=xc/programs/beforelight \
    --exclude=xc/programs/xf86dga \
    --exclude=xc/programs/xieperf \
    --exclude=xc/programs/xrx \
    --exclude=xc/programs/Xserver/afb \
    --exclude=xc/programs/Xserver/ilbm \
    --exclude=xc/programs/Xserver/iplan2p2 \
    --exclude=xc/programs/Xserver/iplan2p4 \
    --exclude=xc/programs/Xserver/iplan2p8 \
    --exclude=xc/programs/Xserver/lmfcfb \
    --exclude=xc/programs/Xserver/PEX5 \
    --exclude=xc/programs/Xserver/hw/darwin \
    --exclude=xc/programs/Xserver/hw/kdrive \
    --exclude=xc/programs/Xserver/hw/sun \
    --exclude=xc/programs/Xserver/hw/sunLynx \
    --exclude=xc/programs/Xserver/hw/xfree86 \
    --exclude="xc/programs/Xserver/hw/xwin-*" \
    --exclude=xc/programs/Xserver/XIE \
    --exclude=xc/programs/Xserver/XpConfig \
    --exclude=xc/util
  )
}
case $1 in
  mkdirs)		mkdirs; STATUS=$? ;;
  conf)			conf ; STATUS=$? ;;
  build)		build ; STATUS=$? ;;
  build-xwin)		build_xwin ; STATUS=$? ;;
  check)		check ; STATUS=$? ;;
  clean)		clean ; STATUS=$? ;;
  install)		install && install_local ; STATUS=$? ;;
  install-xwin)		install_xwin ; STATUS=$? ;;
  install-local)	install_local ; STATUS=$? ;;
  list)			list ; STATUS=$? ;;
  strip)		strip ; STATUS=$? ;;
  mkpatch)		mkpatch ; STATUS=$? ;;
  mkpatch-base)		mkpatch_base ; STATUS=$? ;;
  mkpatch-bin)		mkpatch_bin ; STATUS=$? ;;
  package)		pkg ; STATUS=$? ;;
  pkg)			pkg ; STATUS=$? ;;
  pkg-base)		pkg_base ; STATUS=$? ;;
  pkg-bin)		pkg_bin ; STATUS=$? ;;
  pkg-bin-dlls)		pkg_bin_dlls ; STATUS=$? ;;
  pkg-bin-lndir)	pkg_bin_lndir ; STATUS=$? ;;
  pkg-devel)		pkg_devel ; STATUS=$? ;;
  pkg-etc)		pkg_etc ; STATUS=$? ;;
  pkg-f100)		pkg_f100 ; STATUS=$? ;;
  pkg-fcyr)		pkg_fcyr ; STATUS=$? ;;
  pkg-fenc)		pkg_fenc ; STATUS=$? ;;
  pkg-fnts)		pkg_fnts ; STATUS=$? ;;
  pkg-fscl)		pkg_fscl ; STATUS=$? ;;
  pkg-fsrv)		pkg_fsrv ; STATUS=$? ;;
  pkg-libs-data)	pkg_libs_data ; STATUS=$? ;;
  pkg-man-pages)	pkg_man_pages ; STATUS=$? ;;
  pkg-man-pages-html)	pkg_man_pages_html ; STATUS=$? ;;
  pkg-nest)		pkg_nest ; STATUS=$? ;;
  pkg-vfb)		pkg_vfb ; STATUS=$? ;;
  pkg-xwin)		pkg_xwin ; STATUS=$? ;;
  quickclean)		quickclean ; STATUS=$? ;;
  src-package)		spkg ; STATUS=$? ;;
  spkg)			spkg ; STATUS=$? ;;
  spkg-base)		spkg_base ; STATUS=$? ;;
  spkg-bin)		spkg_bin ; STATUS=$? ;;
  spkg-bin-dlls)	spkg_bin_dlls ; STATUS=$? ;;
  spkg-devel)		spkg_devel ; STATUS=$? ;;
  spkg-fenc)		spkg_fenc ; STATUS=$? ;;
  spkg-fnts)		spkg_fnts ; STATUS=$? ;;
  spkg-fscl)		spkg_fscl ; STATUS=$? ;;
  spkg-man-pages)	spkg_man_pages ; STATUS=$? ;;
  spkg-xwin)		spkg_xwin ; STATUS=$? ;;
  huge-spkg)		huge_spkg ; STATUS=$? ;;
  all)			quickclean && mkdirs && conf && build 2>&1 | tee build.log && \
			install 2>&1 | tee install.log && strip && \
			install_local && pkg && install_local && pkg && \
			spkg ; STATUS=$? ;;
  *)			echo "Error: bad arguments" ; exit 1 ;;
esac
exit ${STATUS}
