'\"
'\" Copyright 1991-1997 by Bell Labs Innovations for Lucent Technologies.
'\"
'\" Permission to use, copy, modify, and distribute this software and its
'\" documentation for any purpose and without fee is hereby granted, provided
'\" that the above copyright notice appear in all copies and that both that the
'\" copyright notice and warranty disclaimer appear in supporting documentation,
'\" and that the names of Lucent Technologies any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the software
'\" without specific, written prior permission.
'\"
'\" Lucent Technologies disclaims all warranties with regard to this software,
'\" including all implied warranties of merchantability and fitness.  In no event
'\" shall Lucent Technologies be liable for any special, indirect or
'\" consequential damages or any damages whatsoever resulting from loss of use,
'\" data or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or performance
'\" of this software.  
'\"
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.3 2001/02/17 07:46:19 ghowlett Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
.ft CW
.sp
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
.ft R
.sp
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH watch n 3.0 BLT "BLT Built-In Commands"
.BS
.SH NAME
watch \- call Tcl procedures before and after each command
.SH SYNOPSIS
\fBwatch create\fR \fIwatchName\fR ?\fIoptions\fR?
.sp
\fBwatch activate\fR \fIwatchName\fR
.sp
\fBwatch deactivate\fR \fIwatchName\fR
.sp
\fBwatch delete\fR \fIwatchName\fR
.sp
\fBwatch configure\fR \fIwatchName\fR ?\fIoptions\fR
.sp
\fBwatch info\fR \fIwatchName\fR
.sp
\fBwatch names\fR 
.BE
.SH DESCRIPTION
The \fBwatch\fR command arranges for Tcl procedures to be invoked
before and after the execution of each Tcl command.
.SH INTRODUCTION
When an error occurs in Tcl, the global variable \fIerrorInfo\fR will
contain a stack-trace of the active procedures when the error occured.
Sometimes, however, the stack trace is insufficient.  You may need to
know exactly where in the program's execution the error occured.  In
cases like this, a more general tracing facility would be useful.
.PP
The \fBwatch\fR command lets you designate Tcl procedures to be
invoked before and after the execution of each Tcl command.  This
means you can display the command line and its results for each
command as it executes.  Another use is to profile your Tcl commands.
You can profile any Tcl command (like \fBif\fR and \fBset\fR), not just
Tcl procedures.
.SH EXAMPLE
The following example use \fBwatch\fR to trace Tcl commands 
(printing to standard error) both before and after they are executed. 
.CS 
proc preCmd { level command argv } {
    set name [lindex $argv 0]
    puts stderr "$level $name => $command"
}

proc postCmd { level command argv retcode results } {
    set name [lindex $argv 0]
    puts stderr "$level $name => $argv\n<= ($retcode) $results"
}
watch create trace \\
	-postcmd postCmd -precmd preCmd
.CE
.SH "OPERATIONS"
The following operations are available for the \fBwatch\fR command:
.TP
\fBwatch activate \fIwatchName\fR 
Activates the watch, causing Tcl commands the be traced to the
maximum depth selected.
.TP
\fBwatch create \fIwatchName\fR ?\fIoptions\fR?...
Creates a new watch \fIwatchName\fR. It's an error if another watch 
\fIwatchName\fR already exists and an error message will be returned.
\fIOptions\fR may have any of the values accepted by the 
\fBwatch configure\fR command.
This command returns the empty string.  
.TP
\fBwatch configure \fIwatchName\fR ?\fIoptions...\fR?
Queries or modifies the configuration options of the watch \fIwatchName\fR.
\fIWatchName\fR is the name of a watch.
\fIOptions\fR may have any of the following values:
.RS
.TP
\fB\-active \fIboolean\fR
Specifies if the watch is active.
By default, watches are active when created.
.TP
\fB\-postcmd \fIstring\fR
Specifies a Tcl procedure to be called immediately after each Tcl
command.  \fIString\fR is name of a Tcl procedure and any extra
arguments to be passed to it.  Before \fIstring\fR is invoked, five
more arguments are appended: 1) the current level 2) the current
command line 3) a list containing the command after substitutions and
split into words 4) the return code of the command, and 5) the results
of the command.  The return status of the postcmd procedure is always
ignored.
.TP
\fB\-precmd \fIstring\fR 
Specifies a Tcl procedure to be called immediately before each Tcl
command.  \fIString\fR is name of a Tcl procedure and any extra
arguments to be passed to it.  Before \fIstring\fR is invoked, three
arguments are appended: 1) the current level 2) the current command
line, and 3) a list containing the command after substitutions and
split into words.  The return status of the \fB\-precmd\fR procedure
is always ignored.
.TP
\fB\-maxlevel \fInumber\fR
Specifies the maximum evaluation depth to watch Tcl commands.
The default maximum level is 10000.
.RE
.TP
\fBwatch deactivate \fIwatchName\fR 
Deactivates the watch.  The \fB\-precmd\fR and \fB\-postcmd\fR procedures
will no longer be invoked.
.TP
\fBwatch info \fIwatchName\fR 
Returns the configuration information associated with the 
watch \fIwatchName\fR.  \fIWatchName\fR is the name of a watch.
.TP
\fBwatch names\fR ?\fIstate\fR?
Lists the names of the watches for a given state.  \fIState\fR may be
one of the following: \f(CWactive\fR, \f(CWidle\fR, or \f(CWignore\fR.  If a
\fIstate\fR argument isn't specified,
 all watches are
listed.
.RE
.SH KEYWORDS
debug, profile
