#!/bin/sh
# find out where the build script is located
tdir=`echo "$0" | sed 's%[\\/][^\\/][^\\/]*$%%'`
test "x$tdir" = "x$0" && tdir=.
scriptdir=`cd $tdir; pwd`
# find src directory.  
# If scriptdir ends in SPECS, then topdir is $scriptdir/.. 
# If scriptdir ends in CYGWIN-PATCHES, then topdir is $scriptdir/../..
# Otherwise, we assume that topdir = scriptdir
topdir1=`echo ${scriptdir} | sed 's%/SPECS$%%'`
topdir2=`echo ${scriptdir} | sed 's%/CYGWIN-PATCHES$%%'`
if [ "x$topdir1" != "x$scriptdir" ] ; then # SPECS
  topdir=`cd ${scriptdir}/..; pwd`
else
  if [ "x$topdir2" != "x$scriptdir" ] ; then # CYGWIN-PATCHES
    topdir=`cd ${scriptdir}/../..; pwd`
  else
    topdir=`cd ${scriptdir}; pwd`
  fi
fi

tscriptname=`basename $0 .sh`
export PKG=`echo $tscriptname | sed -e 's/\-[^\-]*\-[^\-]*$//'`
export VER=`echo $tscriptname | sed -e "s/${PKG}-//" -e 's/\-[^\-]*$//'`
export REL=`echo $tscriptname | sed -e "s/${PKG}-${VER}-//"`
export FULLPKG=${PKG}-${VER}-${REL}
export  c3270PKG=c3270
export  pr3287PKG=pr3287
export  s3270PKG=s3270
export  tcl3270PKG=tcl3270
export  x3270PKG=x3270
export  c3270FULLPKG=${c3270PKG}-${VER}-${REL}
export  pr3287FULLPKG=${pr3287PKG}-${VER}-${REL}
export  s3270FULLPKG=${s3270PKG}-${VER}-${REL}
export  tcl3270FULLPKG=${tcl3270PKG}-${VER}-${REL}
export  x3270FULLPKG=${x3270PKG}-${VER}-${REL}
export src_orig_pkg_name=${PKG}-${VER}.tar.bz2
export src_pkg_name=${FULLPKG}-src.tar.bz2
export src_patch_name=${FULLPKG}.patch
export bin_pkg_name=${FULLPKG}.tar.bz2

export src_orig_pkg=${topdir}/${src_orig_pkg_name}
export src_pkg=${topdir}/${src_pkg_name}
export src_patch=${topdir}/${src_patch_name}
export bin_pkg=${topdir}/${bin_pkg_name}
export srcdir=${topdir}/${PKG}-${VER}
export objdir=${srcdir}/.build
export instdir=${srcdir}/.inst
export srcinstdir=${srcdir}/.sinst
export checkfile=${topdir}/${FULLPKG}.check
host=i686-pc-cygwin
target=i686-pc-cygwin
prefix=/usr
pnoslash=`echo $prefix | sed -e 's#^/##'`
sysconfdir=/etc
snoslash=`echo $sysconfdir | sed -e 's#^/##'`
datadir=${prefix}/share
infodir=${datadir}/info
mandir=${datadir}/man
MY_CFLAGS=
MY_LDFLAGS=

mkdirs() {
  (cd ${topdir} && \
  echo "Creating ${PKG} dirs" && \
  for dirn in \
    ${srcdir} ${objdir} ${instdir} ${srcinstdir} \
    ${instdir}${prefix}/bin ${instdir}${datadir} ${instdir}${infodir} \
    ${instdir}${mandir}/man1 ${instdir}${mandir}/man5 \
    ${instdir}${sysconfdir}/x3270 ; do \
    if [ ! -d ${dirn} ]; then \
      mkdir -p ${dirn} ; \
    fi ; \
  done &&
  echo "Invoking ./${c3270FULLPKG}.sh mkdirs" && \
  ./${c3270FULLPKG}.sh mkdirs && \
  echo "Invoking ./${pr3287FULLPKG}.sh mkdirs" && \
  ./${pr3287FULLPKG}.sh mkdirs && \
  echo "Invoking ./${s3270FULLPKG}.sh mkdirs" && \
  ./${s3270FULLPKG}.sh mkdirs && \
  echo "Invoking ./${tcl3270FULLPKG}.sh mkdirs" && \
  ./${tcl3270FULLPKG}.sh mkdirs && \
  echo "Invoking ./${x3270FULLPKG}.sh mkdirs" && \
  ./${x3270FULLPKG}.sh mkdirs )
}
prep() {
  (cd ${topdir} && \
  tar xvjf ${src_orig_pkg} && \
  cd ${topdir} && \
  mkdir -p ${srcdir} && \
  if [ -f ${src_patch} ] ; then \
    patch -p0 < ${src_patch} ; \
  fi && \
  mkdirs && \
  echo "Invoking ./${c3270FULLPKG}.sh prep" && \
  ./${c3270FULLPKG}.sh prep && \
  echo "Invoking ./${pr3287FULLPKG}.sh prep" && \
  ./${pr3287FULLPKG}.sh prep && \
  echo "Invoking ./${s3270FULLPKG}.sh prep" && \
  ./${s3270FULLPKG}.sh prep && \
  echo "Invoking ./${tcl3270FULLPKG}.sh prep" && \
  ./${tcl3270FULLPKG}.sh prep && \
  echo "Invoking ./${x3270FULLPKG}.sh prep" && \
  ./${x3270FULLPKG}.sh prep )
}
conf() {
  (cd ${topdir} && \
  echo "Invoking ./${c3270FULLPKG}.sh conf" && \
  ./${c3270FULLPKG}.sh conf && \
  echo "Invoking ./${pr3287FULLPKG}.sh conf" && \
  ./${pr3287FULLPKG}.sh conf && \
  echo "Invoking ./${s3270FULLPKG}.sh conf" && \
  ./${s3270FULLPKG}.sh conf && \
  echo "Invoking ./${tcl3270FULLPKG}.sh conf" && \
  ./${tcl3270FULLPKG}.sh conf && \
  echo "Invoking ./${x3270FULLPKG}.sh conf" && \
  ./${x3270FULLPKG}.sh conf )
}
build() {
  (cd ${topdir} && \
  echo "Invoking ./${c3270FULLPKG}.sh build" && \
  ./${c3270FULLPKG}.sh build && \
  echo "Invoking ./${pr3287FULLPKG}.sh build" && \
  ./${pr3287FULLPKG}.sh build && \
  echo "Invoking ./${s3270FULLPKG}.sh build" && \
  ./${s3270FULLPKG}.sh build && \
  echo "Invoking ./${tcl3270FULLPKG}.sh build" && \
  ./${tcl3270FULLPKG}.sh build && \
  echo "Invoking ./${x3270FULLPKG}.sh build" && \
  ./${x3270FULLPKG}.sh build )
}
promote() {
  (cd ${objdir} ; \
   promotearg2="$2" ; \
   if [ "X${promotearg2}" = "X" ] ; then \
     promotearg2="${instdir}" ; \
   fi ; \
   echo "Calling promote for $1 to ${promotearg2}" && \
   sh ${srcdir}/promotecommon.sh $1 ${promotearg2} )
}
check() {
  (cd ${topdir} && \
  echo "Invoking ./${c3270FULLPKG}.sh check" && \
  ./${c3270FULLPKG}.sh check && \
  echo "Invoking ./${pr3287FULLPKG}.sh check" && \
  ./${pr3287FULLPKG}.sh check && \
  echo "Invoking ./${s3270FULLPKG}.sh check" && \
  ./${s3270FULLPKG}.sh check && \
  echo "Invoking ./${tcl3270FULLPKG}.sh check" && \
  ./${tcl3270FULLPKG}.sh check && \
  echo "Invoking ./${x3270FULLPKG}.sh check" && \
  ./${x3270FULLPKG}.sh check )
}
clean() {
  (cd ${topdir} && \
  echo "Invoking ./${c3270FULLPKG}.sh clean" && \
  ./${c3270FULLPKG}.sh clean && \
  echo "Invoking ./${pr3287FULLPKG}.sh clean" && \
  ./${pr3287FULLPKG}.sh clean && \
  echo "Invoking ./${s3270FULLPKG}.sh clean" && \
  ./${s3270FULLPKG}.sh clean && \
  echo "Invoking ./${tcl3270FULLPKG}.sh clean" && \
  ./${tcl3270FULLPKG}.sh clean && \
  echo "Invoking ./${x3270FULLPKG}.sh clean" && \
  ./${x3270FULLPKG}.sh clean )
}
install() {
  (cd ${topdir} && \
  for dirn in \
    ${prefix}/bin ${datadir} \
    ${datadir}/doc/Cygwin ${datadir}/doc/${PKG}-${VER} \
    ${sysconfdir}/postinstall ; do \
    if [ ! -d ${instdir}${dirn} ]; then \
      mkdir -p ${instdir}${dirn} ; \
    fi ; \
  done && \
  cd ${objdir} && \
  if [ -f ${instdir}${infodir}/dir ] ; then \
    rm ${instdir}${infodir}/dir ; \
  fi && \
  templist=""; \
  for f in ${srcdir}/README ${srcdir}/INSTALL ${srcdir}/LICENSE \
           ${srcdir}/META-FAQ ; do \
    if [ -f $f ] ; then \
      templist="$templist $f"; \
    fi ; \
  done && \
  if [ ! "x$templist" = "x" ]; then \
    /usr/bin/install -c -m 644 $templist \
         ${instdir}${datadir}/doc/${PKG}-${VER} ; \
  fi && \
  cd ${topdir} && \
  echo "Invoking ./${c3270FULLPKG}.sh install" && \
  ./${c3270FULLPKG}.sh install && \
  echo "Invoking ./${pr3287FULLPKG}.sh install" && \
  ./${pr3287FULLPKG}.sh install && \
  echo "Invoking ./${s3270FULLPKG}.sh install" && \
  ./${s3270FULLPKG}.sh install && \
  echo "Invoking ./${tcl3270FULLPKG}.sh install" && \
  ./${tcl3270FULLPKG}.sh install && \
  echo "Invoking ./${x3270FULLPKG}.sh install" && \
  ./${x3270FULLPKG}.sh install && \
  echo "Generating ${PKG}-${VER}.README" && \
  /usr/bin/install -c -m 644 ${srcdir}/CYGWIN-PATCHES/${PKG}.README \
    ${instdir}${datadir}/doc/Cygwin/${PKG}-${VER}.README && \
  (cd ${instdir} && \
  (find . -type f | sort | sed 's/^\./  /' > /tmp/.inst.lis) && \
  sed -f ${srcdir}/CYGWIN-PATCHES/${PKG}.README.sed < ${srcdir}/CYGWIN-PATCHES/${PKG}.README > /tmp/.inst.README && \
  /usr/bin/install -c -m 644 /tmp/.inst.README ${instdir}${datadir}/doc/Cygwin/${PKG}-${VER}.README && \
  rm -f /tmp/.inst.lis /tmp/.inst.README ) )
}
mkpatch() {
  (cd ${srcdir} && \
  tar xvjf ${src_orig_pkg} && \
  mv ${c3270PKG}-${VER}   ../${c3270PKG}-${VER}-orig && \
  mv ${pr3287PKG}-${VER}  ../${pr3287PKG}-${VER}-orig && \
  mv ${s3270PKG}-${VER}   ../${s3270PKG}-${VER}-orig && \
  mv ${tcl3270PKG}-${VER} ../${tcl3270PKG}-${VER}-orig && \
  mv ${x3270PKG}-${VER}   ../${x3270PKG}-${VER}-orig && \
  cd ${topdir} && \
  mkdir -p ${PKG}-${VER}-orig && \
  cd ${topdir} && \
  diff -urN -x '.build' -x '.inst' -x '.sinst' \
    ${PKG}-${VER}-orig ${PKG}-${VER} > \
    ${srcinstdir}/${src_patch_name} ; \
  echo "Invoking ./${c3270FULLPKG}.sh mkpatch" && \
  ./${c3270FULLPKG}.sh mkpatch ; \
  echo "Invoking ./${pr3287FULLPKG}.sh mkpatch" && \
  ./${pr3287FULLPKG}.sh mkpatch ; \
  echo "Invoking ./${s3270FULLPKG}.sh mkpatch" && \
  ./${s3270FULLPKG}.sh mkpatch ; \
  echo "Invoking ./${tcl3270FULLPKG}.sh mkpatch" && \
  ./${tcl3270FULLPKG}.sh mkpatch ; \
  echo "Invoking ./${x3270FULLPKG}.sh mkpatch" && \
  ./${x3270FULLPKG}.sh mkpatch ; \
  cd ${topdir} && \
  rm -rf \
  ${c3270PKG}-${VER}-orig \
  ${pr3287PKG}-${VER}-orig \
  ${s3270PKG}-${VER}-orig \
  ${tcl3270PKG}-${VER}-orig \
  ${x3270PKG}-${VER}-orig \
  ${PKG}-${VER}-orig )
}
strip() {
  (cd ${instdir} && \
  echo "stripping ${PKG}"
  find . -name "*.exe" | xargs strip > /dev/null 2>&1
  find . -name "*.dll" | xargs strip > /dev/null 2>&1
  cd ${topdir} && \
  echo "Invoking ./${c3270FULLPKG}.sh strip" && \
  ./${c3270FULLPKG}.sh strip && \
  echo "Invoking ./${pr3287FULLPKG}.sh strip" && \
  ./${pr3287FULLPKG}.sh strip && \
  echo "Invoking ./${s3270FULLPKG}.sh strip" && \
  ./${s3270FULLPKG}.sh strip && \
  echo "Invoking ./${tcl3270FULLPKG}.sh strip" && \
  ./${tcl3270FULLPKG}.sh strip && \
  echo "Invoking ./${x3270FULLPKG}.sh strip" && \
  ./${x3270FULLPKG}.sh strip )
}
pkg() {
  (cd ${instdir} && \
  tar cvjf ${bin_pkg} * ; \
  cd ${topdir} && \
  echo "Invoking ./${c3270FULLPKG}.sh pkg" && \
  ./${c3270FULLPKG}.sh pkg && \
  echo "Invoking ./${pr3287FULLPKG}.sh pkg" && \
  ./${pr3287FULLPKG}.sh pkg && \
  echo "Invoking ./${s3270FULLPKG}.sh pkg" && \
  ./${s3270FULLPKG}.sh pkg && \
  echo "Invoking ./${tcl3270FULLPKG}.sh pkg" && \
  ./${tcl3270FULLPKG}.sh pkg && \
  echo "Invoking ./${x3270FULLPKG}.sh pkg" && \
  ./${x3270FULLPKG}.sh pkg )
}
spkg() {
  (mkpatch && \
  cp ${src_orig_pkg} ${srcinstdir}/${src_orig_pkg_name} && \
  cp ${topdir}/${c3270PKG}-${VER}/.sinst/* ${srcinstdir} && \
  cp ${topdir}/${pr3287PKG}-${VER}/.sinst/* ${srcinstdir} && \
  cp ${topdir}/${s3270PKG}-${VER}/.sinst/* ${srcinstdir} && \
  cp ${topdir}/${tcl3270PKG}-${VER}/.sinst/* ${srcinstdir} && \
  cp ${topdir}/${x3270PKG}-${VER}/.sinst/* ${srcinstdir} && \
  cp $0 ${srcinstdir}/`basename $0` && \
  cp ${topdir}/${c3270FULLPKG}.sh ${srcinstdir} && \
  cp ${topdir}/${pr3287FULLPKG}.sh ${srcinstdir} && \
  cp ${topdir}/${s3270FULLPKG}.sh ${srcinstdir} && \
  cp ${topdir}/${tcl3270FULLPKG}.sh ${srcinstdir} && \
  cp ${topdir}/${x3270FULLPKG}.sh ${srcinstdir} && \
  cd ${srcinstdir} && \
  tar cvjf ${src_pkg} * )
}
finish() {
  (cd ${topdir} && \
  rm -rf ${srcdir} && \
  echo "Invoking ./${c3270FULLPKG}.sh finish" && \
  ./${c3270FULLPKG}.sh finish ; \
  echo "Invoking ./${pr3287FULLPKG}.sh finish" && \
  ./${pr3287FULLPKG}.sh finish ; \
  echo "Invoking ./${s3270FULLPKG}.sh finish" && \
  ./${s3270FULLPKG}.sh finish ; \
  echo "Invoking ./${tcl3270FULLPKG}.sh finish" && \
  ./${tcl3270FULLPKG}.sh finish && \
  echo "Invoking ./${x3270FULLPKG}.sh finish" && \
  ./${x3270FULLPKG}.sh finish )
}
case $1 in
  prep)	prep ; STATUS=$? ;;
  mkdirs)	mkdirs ; STATUS=$? ;;
  conf)	conf ; STATUS=$? ;;
  build)	build ; STATUS=$? ;;
  promote)	promote $2 $3 ; STATUS=$? ;;
  check)	check ; STATUS=$? ;;
  clean)	clean ; STATUS=$? ;;
  install)	install ; STATUS=$? ;;
  strip)	strip ; STATUS=$? ;;
  mkpatch) mkpatch ; STATUS=$? ;;
  package)	pkg ; STATUS=$? ;;
  pkg)	pkg ; STATUS=$? ;;
  src-package)	spkg ; STATUS=$? ;;
  spkg)	spkg ; STATUS=$? ;;
  finish) finish ; STATUS=$? ;;
  all) prep && conf && build && install && strip && \
     pkg && spkg && finish ; STATUS=$? ;;
  *) echo "Error: bad arguments" ; STATUS=1 ;;
esac
exit ${STATUS}
