/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.postgresql.PGStatement;

public class basic {
    Connection db;
    Statement st;

    public basic(String[] args) throws ClassNotFoundException, FileNotFoundException, IOException, SQLException {
        String url = args[0];
        String usr = args[1];
        String pwd = args[2];
        Class.forName("org.postgresql.Driver");
        System.out.println("Connecting to Database URL = " + url);
        this.db = DriverManager.getConnection(url, usr, pwd);
        System.out.println("Connected...Now creating a statement");
        this.st = this.db.createStatement();
        this.cleanup();
        this.doexample();
        this.cleanup();
        System.out.println("Now closing the connection");
        this.st.close();
        this.db.close();
    }

    public void cleanup() {
        try {
            this.st.executeUpdate("drop table basic");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doexample() throws SQLException {
        int b;
        int a;
        System.out.println("\nRunning tests:");
        this.st.executeUpdate("create table basic (a int2, b int2)");
        this.st.executeUpdate("insert into basic values (1,1)");
        this.st.executeUpdate("insert into basic values (2,1)");
        this.st.executeUpdate("insert into basic values (3,1)");
        this.st.executeUpdate("insert into basic values (4,1)");
        long insertedOID = ((PGStatement)this.st).getLastOID();
        System.out.println("Inserted row with oid " + insertedOID);
        this.st.executeUpdate("update basic set b=8");
        System.out.println("Updated " + this.st.getUpdateCount() + " rows");
        this.st.executeUpdate("delete from basic where a<3");
        System.out.println("deleted " + this.st.getUpdateCount() + " rows");
        PreparedStatement ps = this.db.prepareStatement("insert into basic values (?,?)");
        for (int i = 2; i < 5; ++i) {
            ps.setInt(1, 4);
            ps.setInt(2, i);
            ps.executeUpdate();
        }
        ps.close();
        System.out.println("performing a query");
        ResultSet rs = this.st.executeQuery("select a, b from basic");
        if (rs != null) {
            while (rs.next()) {
                a = rs.getInt("a");
                b = rs.getInt(2);
                System.out.println("  a=" + a + " b=" + b);
            }
            rs.close();
        }
        System.out.println("performing another query");
        rs = this.st.executeQuery("select * from basic where b>1");
        if (rs != null) {
            int col_a = rs.findColumn("a");
            int col_b = rs.findColumn("b");
            while (rs.next()) {
                int a2 = rs.getInt(col_a);
                int b2 = rs.getInt(col_b);
                System.out.println("  a=" + a2 + " b=" + b2);
            }
            rs.close();
        }
        this.st.setMaxRows(3);
        System.out.println("performing a query limited to " + this.st.getMaxRows());
        rs = this.st.executeQuery("select a, b from basic");
        while (rs.next()) {
            a = rs.getInt("a");
            b = rs.getInt(2);
            System.out.println("  a=" + a + " b=" + b);
        }
        rs.close();
    }

    public static void instructions() {
        System.out.println("\nThis example tests the basic components of the JDBC driver, demonstrating\nhow to build simple queries in java.\n");
        System.out.println("Useage:\n java example.basic jdbc:postgresql:database user password [debug]\n\nThe debug field can be anything. It's presence will enable DriverManager's\ndebug trace. Unless you want to see screens of items, don't put anything in\nhere.");
        System.exit(1);
    }

    public static void main(String[] args) {
        System.out.println("PostgreSQL basic test v6.3 rev 1\n");
        if (args.length < 3) {
            basic.instructions();
        }
        if (args.length > 3) {
            DriverManager.setLogStream(System.err);
        }
        try {
            basic test = new basic(args);
        }
        catch (Exception ex) {
            System.err.println("Exception caught.\n" + ex);
            ex.printStackTrace();
        }
    }
}

