#!/bin/sh
# This file is part of the Cygwin port of lftp

# set -x

# Subdirectory where the new package is being installed
PREFIX=/usr

# Directory where the config files are stored
SYSCONFDIR=/etc

progname=$0
auto_answer=""

request()
{
  if [ "${auto_answer}" = "yes" ]
  then
    return 0
  elif [ "${auto_answer}" = "no" ]
  then
    return 1
  fi

  answer=""
  while [ "X${answer}" != "Xyes" -a "X${answer}" != "Xno" ]
  do
    echo -n "$1 (yes/no) "
    read answer
  done
  if [ "X${answer}" = "Xyes" ]
  then
    return 0
  else
    return 1
  fi
}

# Check how the script has been started.  If it has been started by
# giving the full path and that path is /etc/postinstall, set
# auto_answer to "no".  This allows automatic creation of the
# config files in /etc w/o overwriting them if they already exist.
progdir=`dirname $0`
if [ "$progdir" = "/etc/postinstall" ]
then
  auto_answer="no"
fi

# Check options

while :
do
  case $# in
  0)
    break
    ;;
  esac

  option=$1
  shift

  case "$option" in
  -d | --debug )
    set -x
    ;;

  -y | --yes )
    auto_answer=yes
    ;;

  -n | --no )
    auto_answer=no
    ;;
  *)
    echo "usage: ${progname} [OPTION]..."
    echo
    echo "This script creates an OpenSSH host configuration."
    echo
    echo "Options:"
    echo "    --debug  -d     Enable shell's debug output."
    echo "    --yes    -y     Answer all questions with \"yes\" automatically."
    echo "    --no     -n     Answer all questions with \"no\" automatically."
    echo
    exit 1
    ;;

  esac
done

# Check for ${SYSCONFDIR} directory

if [ -e "${SYSCONFDIR}" -a ! -d "${SYSCONFDIR}" ]
then
  echo
  echo "${SYSCONFDIR} is existant but not a directory."
  echo "Cannot create global configuration files."
  echo
  exit 1
fi

# Create it if necessary

if [ ! -e "${SYSCONFDIR}" ]
then
  mkdir "${SYSCONFDIR}"
  if [ ! -e "${SYSCONFDIR}" ]
  then
    echo
    echo "Creating ${SYSCONFDIR} directory failed"
    echo
    exit 1
  fi
fi

# Check if lftp.conf exists. If yes, ask for overwriting

if [ -f "${SYSCONFDIR}/lftp.conf" ]
then
  if request "Overwrite existing ${SYSCONFDIR}/lftp.conf file?"
  then
    rm -f "${SYSCONFDIR}/lftp.conf"
    if [ -f "${SYSCONFDIR}/lftp.conf" ]
    then
      echo "Can't overwrite. ${SYSCONFDIR}/lftp.conf is write protected."
    fi
  fi
fi

if [ ! -f "${SYSCONFDIR}/lftp.conf" ]
then
  echo "Creating default ${SYSCONFDIR}/lftp.conf file"
  cp ${SYSCONFDIR}/defaults/etc/lftp.conf ${SYSCONFDIR}
fi

echo
echo "lftp Configuration finished."
