/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public class ArrayList
extends AbstractList
implements List,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private static final int DEFAULT_CAPACITY = 16;
    private int size;
    private transient Object[] data;

    public ArrayList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.data = new Object[capacity];
    }

    public ArrayList() {
        this(16);
    }

    public ArrayList(Collection c) {
        this((int)((float)c.size() * 1.1f));
        this.addAll(c);
    }

    public void trimToSize() {
        if (this.size != this.data.length) {
            Object[] newData = new Object[this.size];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
    }

    public void ensureCapacity(int minCapacity) {
        int current = this.data.length;
        if (minCapacity > current) {
            Object[] newData = new Object[Math.max(current * 2, minCapacity)];
            System.arraycopy(this.data, 0, newData, 0, this.size);
            this.data = newData;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object e) {
        return this.indexOf(e) != -1;
    }

    public int indexOf(Object e) {
        for (int i = 0; i < this.size; ++i) {
            if (!AbstractCollection.equals(e, this.data[i])) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object e) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (!AbstractCollection.equals(e, this.data[i])) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        ArrayList clone = null;
        try {
            clone = (ArrayList)super.clone();
            clone.data = (Object[])this.data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public Object[] toArray() {
        Object[] array = new Object[this.size];
        System.arraycopy(this.data, 0, array, 0, this.size);
        return array;
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        } else if (a.length > this.size) {
            a[this.size] = null;
        }
        System.arraycopy(this.data, 0, a, 0, this.size);
        return a;
    }

    public Object get(int index) {
        this.checkBoundExclusive(index);
        return this.data[index];
    }

    public Object set(int index, Object e) {
        this.checkBoundExclusive(index);
        Object result = this.data[index];
        this.data[index] = e;
        return result;
    }

    public boolean add(Object e) {
        ++this.modCount;
        if (this.size == this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.data[this.size++] = e;
        return true;
    }

    public void add(int index, Object e) {
        this.checkBoundInclusive(index);
        ++this.modCount;
        if (this.size == this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        if (index != this.size) {
            System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        }
        this.data[index] = e;
        ++this.size;
    }

    public Object remove(int index) {
        this.checkBoundExclusive(index);
        Object r = this.data[index];
        ++this.modCount;
        if (index != --this.size) {
            System.arraycopy(this.data, index + 1, this.data, index, this.size - index);
        }
        this.data[this.size] = null;
        return r;
    }

    public void clear() {
        if (this.size > 0) {
            ++this.modCount;
            Arrays.fill(this.data, 0, this.size, null);
            this.size = 0;
        }
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size, c);
    }

    public boolean addAll(int index, Collection c) {
        this.checkBoundInclusive(index);
        Iterator itr = c.iterator();
        int csize = c.size();
        ++this.modCount;
        if (csize + this.size > this.data.length) {
            this.ensureCapacity(this.size + csize);
        }
        int end = index + csize;
        if (this.size > 0 && index != this.size) {
            System.arraycopy(this.data, index, this.data, end, this.size - index);
        }
        this.size += csize;
        while (index < end) {
            this.data[index] = itr.next();
            ++index;
        }
        return csize > 0;
    }

    protected void removeRange(int fromIndex, int toIndex) {
        int change = toIndex - fromIndex;
        if (change > 0) {
            ++this.modCount;
            System.arraycopy(this.data, toIndex, this.data, fromIndex, this.size - toIndex);
            this.size -= change;
        } else if (change < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkBoundInclusive(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private void checkBoundExclusive(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    boolean removeAllInternal(Collection c) {
        int i;
        for (i = 0; i < this.size && !c.contains(this.data[i]); ++i) {
        }
        if (i == this.size) {
            return false;
        }
        ++this.modCount;
        int j = i++;
        while (i < this.size) {
            if (!c.contains(this.data[i])) {
                this.data[j++] = this.data[i];
            }
            ++i;
        }
        this.size -= i - j;
        return true;
    }

    boolean retainAllInternal(Collection c) {
        int i;
        for (i = 0; i < this.size && c.contains(this.data[i]); ++i) {
        }
        if (i == this.size) {
            return false;
        }
        ++this.modCount;
        int j = i++;
        while (i < this.size) {
            if (c.contains(this.data[i])) {
                this.data[j++] = this.data[i];
            }
            ++i;
        }
        this.size -= i - j;
        return true;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int len = this.data.length;
        s.writeInt(len);
        for (int i = 0; i < this.size; ++i) {
            s.writeObject(this.data[i]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int capacity = s.readInt();
        this.data = new Object[capacity];
        for (int i = 0; i < this.size; ++i) {
            this.data[i] = s.readObject();
        }
    }
}

