#ifndef GCC_DCMPLR_DC_LANG_H
#define GCC_DCMPLR_DC_LANG_H

// Nothing is added to tree_identifier;
struct lang_identifier GTY(())
{
  struct tree_identifier ignore;
};

// This is required to be defined, but we do not use it.
struct language_function GTY(())
{
  int unused;
};

// The DMD front end types have not been integrated into the GCC garbage
// collection system.  Handle this by using the "skip" attribute.
struct Declaration;
typedef struct Declaration *DeclarationGTYP;
struct lang_decl GTY(())
{
    DeclarationGTYP GTY ((skip(""))) d_decl;
};

// This lang_type field is not set for every GCC type.
struct Type;
typedef struct Type *TypeGTYP;
struct lang_type GTY(())
{
    TypeGTYP GTY((skip(""))) d_type;
    tree varblock_size;
    bool is_nested_function;
};

// Another required, but unused declaration.  This could be simplified, since
// there is no special lang_identifier
union lang_tree_node 
  GTY((desc ("TREE_CODE (&%h.generic) == IDENTIFIER_NODE"),
       chain_next ("(union lang_tree_node *)TREE_CHAIN (&%h.generic)")))
{
  union tree_node GTY ((tag ("0"), 
			desc ("tree_node_structure (&%h)"))) 
    generic;
  struct lang_identifier GTY ((tag ("1"))) identifier;
};

extern bool d_mark_addressable PARAMS ((tree));
extern tree d_truthvalue_conversion PARAMS ((tree));
extern tree d_convert_basic PARAMS ((tree, tree));

#ifdef __cplusplus
extern struct lang_type * build_d_type_lang_specific(Type * t);
#endif

extern void init_global_binding_level(void);

extern void set_decl_binding_chain(tree decl_chain);

extern tree d_type_for_size(unsigned bits , int unsignedp);
extern tree d_unsigned_type(tree);
extern tree d_signed_type(tree);

#if D_GCC_VER == 33
extern rtx d_expand_expr(tree, rtx, enum machine_mode, int);
#else
extern rtx d_expand_expr(tree, rtx, enum machine_mode, int, rtx *);
#endif

/* %% gty ? */
extern tree d_void_zero_node; /* This is in c-common as a #define */
#if D_GCC_VER == 33
/* In GCC 3.3, these are in c-common; in 3.4, they are in tree.h */
extern tree boolean_type_node; /* %% should be bit_type */
extern tree boolean_false_node;
extern tree boolean_true_node;
#endif

struct Module;
struct Module * getCurrentModule(void);


extern
#ifdef __cplusplus
 "C"
#endif
tree pushdecl PARAMS ((tree));

void d_add_global_function PARAMS(( tree ));

#undef DEFTREECODE
#define DEFTREECODE(SYM, NAME, TYPE, LENGTH) SYM,

enum d_tree_code {
  D_DUMMY_TREE_CODE = LAST_AND_UNUSED_TREE_CODE,
#include "d-tree.def"
  LAST_D_TREE_CODE
};

/* True if the Tdelegate typed expression is not really a variable,
   but a literal function / method reference */
#define D_IS_METHOD_CALL_EXPR(NODE) (TREE_LANG_FLAG_0(NODE))

/* The D front-end does not use the 'binding level' system for a symbol table,
   It is only needed to get debugging information for local variables and
   otherwise support the backend. */

struct binding_level GTY(())
{
  /* A chain of declarations. These are in the reverse of the order supplied. */
  tree names;

  /* A pointer to the end of the names chain. Only needed to facilitate
     a quick test if a decl is in the list by checking if its TREE_CHAIN
     is not NULL or it is names_end (in pushdecl_nocheck()). */
  tree names_end;

  /* For each level (except the global one), a chain of BLOCK nodes for
     all the levels that were entered and exited one level down. */
  tree blocks;

  /* The BLOCK node for this level, if one has been preallocated.
     If NULL_TREE, the BLOCK is allocated (if needed) when the level is popped. */
  tree this_block;

  /* The binding level this one is contained in. */
  struct binding_level *level_chain;

};

extern GTY(()) struct binding_level * current_binding_level;
extern GTY(()) struct binding_level * global_binding_level;

extern GTY(()) tree d_void_zero_node;
#if D_GCC_VER == 33
extern GTY(()) tree boolean_type_node;
extern GTY(()) tree boolean_true_node;
extern GTY(()) tree boolean_false_node;
#endif

/* %% TODO: move these to another file */
extern GTY(()) tree intmax_type_node;
extern GTY(()) tree uintmax_type_node;
extern GTY(()) tree signed_size_type_node;
extern GTY(()) tree string_type_node;
extern GTY(()) tree const_string_type_node;

extern GTY(()) tree d_null_pointer;

#ifdef __cplusplus
extern "C" {
#endif
    
/* In d-builtins.c */
extern void d_init_builtins PARAMS ((void));

/* In d-misc.c */
extern int d_using_sjlj_exceptions PARAMS ((void));

#ifdef __cplusplus
}
#endif


/* protect from garbage collection */
extern GTY(()) tree d_keep_list;
extern void dkeep(tree t);

#endif
