/*
  ImageMagick Image Composite Private Methods.
*/
#ifndef _MAGICK_COMPOSITE_PRIVATE_H
#define _MAGICK_COMPOSITE_PRIVATE_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

/*
  ImageMagick Alpha Composite Inline Methods.
*/

static inline MagickRealType MagickAtop_(const MagickRealType p,
  const MagickRealType alpha,const MagickRealType q,const MagickRealType beta)
{
  MagickRealType
    pixel;
                                                                                
  pixel=((1-QuantumScale*alpha)*p*(1-QuantumScale*beta)+(1-QuantumScale*beta)*
    q*QuantumScale*alpha);
  return(pixel);
}
                                                                                
static inline void MagickCompositeAtop(const PixelPacket *p,
  const MagickRealType alpha,const PixelPacket *q,const MagickRealType beta,
  PixelPacket *composite)
{
  MagickRealType
    gamma;
                                                                                
  gamma=(1-QuantumScale*beta);
  composite->opacity=(Quantum) (MaxRGB*(1.0-gamma)+0.5);
  gamma=1.0/(gamma <= MagickEpsilon ? 1.0 : gamma);
  composite->red=(Quantum) (gamma*MagickAtop_(p->red,alpha,q->red,beta)+0.5);
  composite->green=(Quantum)
    (gamma*MagickAtop_(p->green,alpha,q->green,beta)+0.5);
  composite->blue=(Quantum) (gamma*MagickAtop_(p->blue,alpha,q->blue,beta)+0.5);
}

static inline MagickRealType MagickOver_(const MagickRealType p,
  const MagickRealType alpha,const MagickRealType q,const MagickRealType beta)
{
  return((1-QuantumScale*alpha)*p+(1-QuantumScale*beta)*q*QuantumScale*alpha);
}
                                                                                
static inline void MagickCompositeOver(const PixelPacket *p,
  const MagickRealType alpha,const PixelPacket *q,const MagickRealType beta,
  PixelPacket *composite)
{
  MagickRealType
    gamma;
                                                                                
  gamma=1.0-QuantumScale*QuantumScale*alpha*beta;
  composite->opacity=(Quantum) (MaxRGB*(1.0-gamma)+0.5);
  gamma=1.0/(gamma <= MagickEpsilon ? 1.0 : gamma);
  composite->red=(Quantum) (gamma*MagickOver_(p->red,alpha,q->red,beta)+0.5);
  composite->green=(Quantum)
    (gamma*MagickOver_(p->green,alpha,q->green,beta)+0.5);
  composite->blue=(Quantum) (gamma*MagickOver_(p->blue,alpha,q->blue,beta)+0.5);
}

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
