/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.expr.Expression;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.kawa.util.LList;
import gnu.kawa.util.Pair;
import gnu.mapping.Printable;
import kawa.lang.Macro;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class let_syntax
extends Syntax
implements Printable {
    boolean recursive;

    public let_syntax(boolean bl) {
        this.recursive = bl;
    }

    public Expression rewrite(Object object2, Translator translator) {
        Printable printable;
        if (!(object2 instanceof Pair)) {
            return translator.syntaxError("missing let-syntax arguments");
        }
        Pair pair = (Pair)object2;
        Object object3 = pair.car;
        Object object4 = pair.cdr;
        int n = LList.length(object3);
        Expression[] expressionArray = new Expression[n];
        Macro[] macroArray = new Macro[n];
        Object[] objectArray = new Object[n];
        LetExp letExp = new LetExp(expressionArray);
        int n2 = 0;
        while (n2 < n) {
            Pair pair2 = (Pair)object3;
            if (!(pair2.car instanceof Pair)) {
                return translator.syntaxError("let binding is not a pair");
            }
            printable = (Pair)pair2.car;
            if (!(printable.car instanceof String)) {
                return translator.syntaxError("variable in let binding is not a symbol");
            }
            String string = (String)printable.car;
            if (!(printable.cdr instanceof Pair)) {
                return translator.syntaxError("let has no value for `" + string + "'");
            }
            printable = (Pair)printable.cdr;
            if (printable.cdr != LList.Empty) {
                return translator.syntaxError("let binding for `" + string + "' is improper list");
            }
            macroArray[n2] = new Macro(string);
            objectArray[n2] = printable.car;
            letExp.addDeclaration(macroArray[n2]);
            expressionArray[n2] = QuoteExp.nullExp;
            object3 = pair2.cdr;
            ++n2;
        }
        if (this.recursive) {
            translator.push(letExp);
        }
        int n3 = 0;
        while (n3 < n) {
            expressionArray[n3] = translator.rewrite(objectArray[n3]);
            macroArray[n3].expander = expressionArray[n3];
            macroArray[n3].noteValue(expressionArray[n3]);
            ++n3;
        }
        if (!this.recursive) {
            translator.push(letExp);
        }
        printable = translator.rewrite_body(object4);
        translator.pop(letExp);
        return printable;
    }
}

