/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.Complex;
import gnu.math.DComplex;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RatNum;

public abstract class RealNum
extends Complex {
    public Numeric abs() {
        return this.isNegative() ? this.neg() : this;
    }

    public static RealNum add(RealNum realNum, RealNum realNum2, int n) {
        return (RealNum)realNum.add(realNum2, n);
    }

    public abstract Numeric add(Object var1, int var2);

    public RealNum angle() {
        return IntNum.zero();
    }

    public static RealNum div(RealNum realNum, RealNum realNum2) {
        return (RealNum)realNum.div(realNum2);
    }

    public abstract Numeric div(Object var1);

    public Complex exp() {
        return new DFloNum(Math.exp(this.doubleValue()));
    }

    public final RealNum im() {
        return IntNum.zero();
    }

    public abstract boolean isNegative();

    public boolean isZero() {
        return this.sign() == 0;
    }

    public Complex log() {
        double d = this.doubleValue();
        if (d < 0.0) {
            return DComplex.log(d, 0.0);
        }
        return new DFloNum(Math.log(d));
    }

    public RealNum max(RealNum realNum) {
        RealNum realNum2;
        boolean bl = this.isExact() && realNum.isExact();
        RealNum realNum3 = realNum2 = this.grt(realNum) ? this : realNum;
        if (!bl && realNum2.isExact()) {
            realNum2 = new DFloNum(realNum2.doubleValue());
        }
        return realNum2;
    }

    public RealNum min(RealNum realNum) {
        RealNum realNum2;
        boolean bl = this.isExact() && realNum.isExact();
        RealNum realNum3 = realNum2 = this.grt(realNum) ? realNum : this;
        if (!bl && realNum2.isExact()) {
            realNum2 = new DFloNum(realNum2.doubleValue());
        }
        return realNum2;
    }

    public static RealNum mul(RealNum realNum, RealNum realNum2) {
        return (RealNum)realNum.mul(realNum2);
    }

    public abstract Numeric mul(Object var1);

    public final RealNum re() {
        return this;
    }

    public final RealNum rneg() {
        return (RealNum)this.neg();
    }

    public abstract int sign();

    public final Complex sin() {
        return new DFloNum(Math.sin(this.doubleValue()));
    }

    public final Complex sqrt() {
        double d = this.doubleValue();
        if (d >= 0.0) {
            return new DFloNum(Math.sqrt(d));
        }
        return DComplex.sqrt(d, 0.0);
    }

    public RatNum toExact() {
        return DFloNum.toExact(this.doubleValue());
    }

    public static IntNum toExactInt(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new ArithmeticException("cannot convert " + d + " to exact integer");
        }
        long l = Double.doubleToLongBits(d);
        boolean bl = l < 0L;
        int n = (int)(l >> 52) & 0x7FF;
        l &= 0xFFFFFFFFFFFFFL;
        l = n == 0 ? (l <<= 1) : (l |= 0x10000000000000L);
        if (n <= 1075) {
            int n2 = 1075 - n;
            if (n2 > 53) {
                return IntNum.zero();
            }
            return IntNum.make(bl ? -l : (l >>= n2));
        }
        return IntNum.shift(IntNum.make(bl ? -l : l), n - 1075);
    }

    public static IntNum toExactInt(double d, int n) {
        return RealNum.toExactInt(RealNum.toInt(d, n));
    }

    public IntNum toExactInt(int n) {
        return RealNum.toExactInt(this.doubleValue(), n);
    }

    public static double toInt(double d, int n) {
        switch (n) {
            case 1: {
                return Math.floor(d);
            }
            case 2: {
                return Math.ceil(d);
            }
            case 3: {
                return d < 0.0 ? Math.ceil(d) : Math.floor(d);
            }
            case 4: {
                return Math.rint(d);
            }
        }
        return d;
    }

    public RealNum toInt(int n) {
        return new DFloNum(RealNum.toInt(this.doubleValue(), n));
    }

    public static IntNum toScaledInt(double d, int n) {
        return RealNum.toScaledInt(DFloNum.toExact(d), n);
    }

    public IntNum toScaledInt(int n) {
        return RealNum.toScaledInt(this.toExact(), n);
    }

    public static IntNum toScaledInt(RatNum ratNum, int n) {
        if (n != 0) {
            IntNum intNum = IntNum.power(IntNum.ten(), n < 0 ? -n : n);
            IntNum intNum2 = ratNum.numerator();
            IntNum intNum3 = ratNum.denominator();
            if (n >= 0) {
                intNum2 = IntNum.times(intNum2, intNum);
            } else {
                intNum3 = IntNum.times(intNum3, intNum);
            }
            ratNum = RatNum.make(intNum2, intNum3);
        }
        return ratNum.toExactInt(4);
    }
}

