/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.BindingInitializer;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Initializer;
import gnu.expr.LambdaExp;
import gnu.expr.Literal;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;

public class Declaration {
    static int counter;
    protected int id = ++counter;
    String name;
    public ScopeExp context;
    protected Type type;
    Declaration next;
    Variable var;
    Declaration nextCapturedVar;
    public Declaration base;
    public Field field;
    protected Expression value = QuoteExp.undefined_exp;
    static final int INDIRECT_BINDING = 1;
    static final int CAN_READ = 2;
    static final int CAN_CALL = 4;
    static final int CAN_WRITE = 8;
    static final int IS_FLUID = 16;
    static final int PRIVATE = 32;
    static final int IS_SIMPLE = 64;
    static final int PROCEDURE = 128;
    static final int IS_ALIAS = 256;
    public static final int NOT_DEFINING = 512;
    public static final int EXPORT_SPECIFIED = 1024;
    public static final int STATIC_SPECIFIED = 2048;
    public static final int NONSTATIC_SPECIFIED = 4096;
    public static final int TYPE_SPECIFIED = 8192;
    public static final int IS_CONSTANT = 16384;
    protected int flags = 64;
    public ApplyExp firstCall;
    Method makeBindingMethod = null;
    String filename;
    int position;

    protected Declaration() {
    }

    public Declaration(String string) {
        this(string, Type.pointer_type);
    }

    public Declaration(String string, Type type) {
        this.name = string;
        this.setType(type);
    }

    public final Variable allocateVariable(CodeAttr codeAttr) {
        if (!this.isSimple()) {
            return null;
        }
        if (this.var == null) {
            String string = null;
            if (this.name != null) {
                string = Compilation.mangleName(this.getName());
            }
            if (this.isAlias() && this.getValue() instanceof ReferenceExp) {
                Declaration declaration = Declaration.followAliases(this);
                this.var = declaration == null ? null : declaration.var;
            } else {
                Type type = this.isIndirectBinding() ? Compilation.typeLocation : this.getType();
                this.var = this.context.scope.addVariable(codeAttr, type, string);
            }
        }
        return this.var;
    }

    public void compileStore(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (this.isSimple()) {
            codeAttr.emitStore(this.getVariable());
        } else {
            if (!this.field.getStaticFlag()) {
                this.loadOwningObject(compilation);
                codeAttr.emitSwap();
            }
            codeAttr.emitPutField(this.field);
        }
    }

    public static Declaration followAliases(Declaration declaration) {
        while (declaration != null && declaration.isAlias()) {
            Expression expression = declaration.getValue();
            if (!(expression instanceof ReferenceExp)) break;
            declaration = ((ReferenceExp)expression).binding;
        }
        return declaration;
    }

    public final boolean getCanCall() {
        return (this.flags & 4) != 0;
    }

    public final boolean getCanRead() {
        return (this.flags & 2) != 0;
    }

    public final boolean getCanWrite() {
        return (this.flags & 8) != 0;
    }

    public final int getColumn() {
        return this.position & 0xFFF;
    }

    public final ScopeExp getContext() {
        return this.context;
    }

    public final String getFile() {
        return this.filename;
    }

    public final boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }

    public final int getLine() {
        return this.position >> 12;
    }

    public final String getName() {
        return this.name;
    }

    public final Type getType() {
        return this.type;
    }

    public final Expression getValue() {
        return this.value;
    }

    public Variable getVariable() {
        return this.var;
    }

    public boolean ignorable() {
        if (this.getCanRead() || this.isPublic()) {
            return false;
        }
        if (!this.getCanCall()) {
            return true;
        }
        Expression expression = this.getValue();
        if (expression == null || !(expression instanceof LambdaExp)) {
            return false;
        }
        LambdaExp lambdaExp = (LambdaExp)expression;
        return !lambdaExp.isHandlingTailCalls() || lambdaExp.getInlineOnly();
    }

    public void initBinding(Compilation compilation) {
        if (this.isIndirectBinding()) {
            this.pushIndirectBinding(compilation);
            CodeAttr codeAttr = compilation.getCode();
            codeAttr.emitStore(this.getVariable());
        } else {
            this.compileStore(compilation);
        }
    }

    public final boolean isAlias() {
        return (this.flags & 0x100) != 0;
    }

    public final boolean isFluid() {
        return (this.flags & 0x10) != 0;
    }

    public final boolean isIndirectBinding() {
        return (this.flags & 1) != 0;
    }

    public final boolean isLexical() {
        return !this.isFluid() && !this.isStatic();
    }

    public final boolean isPrivate() {
        return (this.flags & 0x20) != 0;
    }

    public final boolean isProcedureDecl() {
        return (this.flags & 0x80) != 0;
    }

    public final boolean isPublic() {
        return this.context instanceof ModuleExp && (this.flags & 0x20) == 0;
    }

    public final boolean isSimple() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isStatic() {
        return this.context instanceof ModuleExp && !this.isPrivate();
    }

    public void load(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (this.field != null) {
            if (!this.field.getStaticFlag()) {
                this.loadOwningObject(compilation);
                codeAttr.emitGetField(this.field);
            } else {
                codeAttr.emitGetStatic(this.field);
            }
        } else {
            codeAttr.emitLoad(this.getVariable());
        }
    }

    public void loadOwningObject(Compilation compilation) {
        if (this.base != null) {
            this.base.load(compilation);
        } else {
            this.getContext().currentLambda().loadHeapFrame(compilation);
        }
    }

    public void makeField(Compilation compilation, Expression expression) {
        Object object2;
        this.setSimple(false);
        String string = Compilation.mangleName(this.getName());
        int n = 0;
        boolean bl = this.getFlag(16384);
        boolean bl2 = this.getFlag(8192);
        if (this.isPublic() && !bl && !bl2) {
            this.setIndirectBinding(true);
        }
        if (this.isIndirectBinding() || bl) {
            n |= 0x10;
        }
        if (!this.isPrivate()) {
            n |= 1;
        }
        if (this.getFlag(2048) || bl && expression instanceof QuoteExp) {
            n |= 8;
        }
        Type type = this.isIndirectBinding() ? (compilation.getInterpreter().hasSeparateFunctionNamespace() ? Compilation.typeBinding2 : Compilation.typeBinding) : (expression == null || bl2 ? this.getType() : expression.getType());
        this.field = compilation.mainClass.addField(string, type, n);
        if (expression instanceof QuoteExp && (object2 = ((QuoteExp)expression).getValue()).getClass().getName().equals(type.getName())) {
            Literal literal = compilation.findLiteral(object2);
            if (literal.field == null) {
                literal.assign(this.field, compilation);
            }
        }
        if (expression instanceof QuoteExp && (type instanceof PrimType || "java.lang.String".equals(type.getName()))) {
            this.field.setConstantValue(((QuoteExp)expression).getValue(), compilation.mainClass);
        } else if (this.isIndirectBinding() || expression != null) {
            object2 = new BindingInitializer(this, this.field, expression);
            if ((n & 8) != 0) {
                ((Initializer)object2).next = compilation.clinitChain;
                compilation.clinitChain = object2;
            } else {
                ((Initializer)object2).next = compilation.initChain;
                compilation.initChain = object2;
            }
        }
    }

    public boolean needsInit() {
        return !this.ignorable() && (this.value != QuoteExp.nullExp || this.base == null);
    }

    public final Declaration nextDecl() {
        return this.next;
    }

    public void noteValue(Expression expression) {
        if (this.value == QuoteExp.undefined_exp) {
            if (expression instanceof LambdaExp) {
                ((LambdaExp)expression).nameDecl = this;
            }
            this.value = expression;
        } else if (this.value != expression) {
            if (this.value instanceof LambdaExp) {
                ((LambdaExp)this.value).nameDecl = null;
            }
            this.value = null;
        }
    }

    public void pushIndirectBinding(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        codeAttr.emitPushString(this.getName());
        if (this.makeBindingMethod == null) {
            ClassType classType = ClassType.make("gnu.mapping.Binding");
            Type[] typeArray = new Type[]{Type.pointer_type, Type.string_type};
            this.makeBindingMethod = classType.addMethod("make", typeArray, classType, 9);
        }
        codeAttr.emitInvokeStatic(this.makeBindingMethod);
    }

    public final void setAlias(boolean bl) {
        this.setFlag(bl, 256);
    }

    public final void setCanCall() {
        this.setFlag(true, 4);
        if (this.base != null) {
            this.base.setCanRead();
        }
    }

    public final void setCanCall(boolean bl) {
        this.setFlag(bl, 4);
    }

    public final void setCanRead() {
        this.setFlag(true, 2);
        if (this.base != null) {
            this.base.setCanRead();
        }
    }

    public final void setCanRead(boolean bl) {
        this.setFlag(bl, 2);
    }

    public final void setCanWrite(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public final void setFile(String string) {
        this.filename = string;
    }

    public final void setFlag(int n) {
        this.flags |= n;
    }

    public final void setFlag(boolean bl, int n) {
        this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
    }

    public final void setFluid(boolean bl) {
        this.setFlag(bl, 16);
    }

    public final void setIndirectBinding(boolean bl) {
        this.setFlag(bl, 1);
    }

    public final void setLine(int n) {
        this.setLine(n, 0);
    }

    public final void setLine(int n, int n2) {
        this.position = (n << 12) + n2;
    }

    public void setName(String string) {
        this.name = string;
    }

    public final void setPrivate(boolean bl) {
        this.setFlag(bl, 32);
    }

    public final void setProcedureDecl(boolean bl) {
        this.setFlag(bl, 128);
    }

    public final void setSimple(boolean bl) {
        this.setFlag(bl, 64);
        if (this.var != null) {
            this.var.setSimple(bl);
        }
    }

    public final void setType(Type type) {
        this.type = type;
        if (this.var != null) {
            this.var.setType(type);
        }
    }

    public String toString() {
        return "Declaration[" + this.getName() + '/' + this.id + ']';
    }
}

