/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Access;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolClass;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.CpoolUtf8;
import java.io.DataOutputStream;
import java.io.IOException;

public class InnerClassesAttr
extends Attribute {
    short count;
    short[] data;

    public InnerClassesAttr(ClassType cl) {
        super("InnerClasses");
        this.addToFrontOf(cl);
    }

    public InnerClassesAttr(short[] data, ClassType cl) {
        this(cl);
        this.count = (short)(data.length >> 2);
        this.data = data;
    }

    public int getLength() {
        return 2 + 8 * this.count;
    }

    public void print(ClassTypeWriter dst) {
        ClassType ctype = (ClassType)this.container;
        ConstantPool constants = ctype.getConstants();
        dst.print("Attribute \"");
        dst.print(this.getName());
        dst.print("\", length:");
        dst.print(this.getLength());
        dst.print(", count: ");
        dst.println(this.count);
        int i = 0;
        while (i < this.count) {
            dst.print("  ");
            int index = this.data[4 * i] & 0xFFFF;
            CpoolEntry centry = constants.getForced(index, 7);
            dst.print(((CpoolClass)centry).getStringName());
            dst.print("; ");
            index = this.data[4 * i + 1] & 0xFFFF;
            if (index != 0) {
                dst.print("Member of ");
                centry = constants.getForced(index, 7);
                dst.print(((CpoolClass)centry).getStringName());
            }
            dst.print("; ");
            index = this.data[4 * i + 2] & 0xFFFF;
            if (index != 0) {
                centry = constants.getForced(index, 1);
                dst.print(((CpoolUtf8)centry).string);
            } else {
                dst.print("(Anonymous)");
            }
            dst.print(";");
            dst.print(Access.toString(this.data[4 * i + 3] & 0xFFFF));
            dst.println();
            ++i;
        }
    }

    public void write(DataOutputStream dstr) throws IOException {
        dstr.writeShort(this.count);
        int i = 0;
        while (i < this.count) {
            dstr.writeShort(this.data[2 * i]);
            dstr.writeShort(this.data[2 * i + 1]);
            dstr.writeShort(this.data[2 * i + 2]);
            dstr.writeShort(this.data[2 * i + 3]);
            ++i;
        }
    }
}

