/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.mapping.Binding;
import gnu.mapping.FluidBinding;
import gnu.mapping.Future;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.ProcedureN;
import gnu.math.IntNum;
import java.io.IOException;
import java.io.PrintWriter;
import kawa.standard.ObjectFormat;

public class TracedProcedure
extends ProcedureN {
    public Procedure proc;
    boolean enabled;
    static Binding indentation = Binding.make(IntNum.zero(), "indentation");
    static int indentationStep = 2;

    public TracedProcedure(Procedure procedure, boolean bl) {
        this.proc = procedure;
        this.enabled = bl;
        String string = procedure.getName();
        if (string != null) {
            this.setName(string);
        }
    }

    public Object applyN(Object[] objectArray) {
        if (this.enabled) {
            Object object2;
            int n = ((IntNum)indentation.getValue()).intValue();
            OutPort outPort = OutPort.errDefault();
            String string = this.getName();
            if (string == null) {
                string = "??";
            }
            TracedProcedure.indent(n, outPort);
            outPort.print("call to ");
            outPort.print(string);
            int n2 = objectArray.length;
            outPort.print(" (");
            int n3 = 0;
            while (n3 < n2) {
                if (n3 > 0) {
                    outPort.print(' ');
                }
                TracedProcedure.put(objectArray[n3], outPort);
                ++n3;
            }
            outPort.println(")");
            Future future = Future.getContext();
            FluidBinding fluidBinding = future.fluidBindings;
            IntNum intNum = IntNum.make(n + indentationStep);
            FluidBinding fluidBinding2 = new FluidBinding(fluidBinding, intNum, indentation);
            try {
                try {
                    future.setFluids(fluidBinding2);
                    object2 = this.proc.applyN(objectArray);
                }
                catch (RuntimeException runtimeException) {
                    TracedProcedure.indent(n, outPort);
                    outPort.println("procedure " + string + " throws exception " + runtimeException);
                    throw runtimeException;
                }
                Object var13_13 = null;
                future.resetFluids(fluidBinding);
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                future.resetFluids(fluidBinding);
                throw throwable;
            }
            TracedProcedure.indent(n, outPort);
            outPort.print("return from ");
            outPort.print(string);
            outPort.print(" => ");
            TracedProcedure.put(object2, outPort);
            outPort.println();
            return object2;
        }
        return this.proc.applyN(objectArray);
    }

    public static Procedure doTrace(Procedure procedure, boolean bl) {
        if (procedure instanceof TracedProcedure) {
            ((TracedProcedure)procedure).enabled = bl;
            return procedure;
        }
        return new TracedProcedure(procedure, bl);
    }

    static void indent(int n, PrintWriter printWriter) {
        while (--n >= 0) {
            printWriter.print(' ');
        }
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<procedure ");
        String string = this.name();
        if (string == null) {
            printWriter.print("<unnamed>");
        } else {
            printWriter.print(string);
        }
        printWriter.print(this.enabled ? ", traced>" : ">");
    }

    static void put(Object object2, PrintWriter printWriter) {
        try {
            if (!ObjectFormat.format(object2, printWriter, 50, true)) {
                printWriter.print("...");
            }
        }
        catch (IOException iOException) {
            printWriter.print("<caught ");
            printWriter.print(iOException);
            printWriter.print('>');
        }
    }
}

