/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Interpreter;
import gnu.expr.ModuleExp;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.util.FString;
import gnu.kawa.util.Sequence;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Procedure2;
import gnu.mapping.WrongType;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import kawa.lang.GenericError;
import kawa.lang.Translator;

public class CompileFile
extends Procedure2 {
    public CompileFile() {
        super("compile-file");
    }

    public final Object apply2(Object object2, Object object3) {
        ModuleExp moduleExp;
        if (!(object2 instanceof FString)) {
            throw new WrongType(this.name(), 1, "file name");
        }
        Translator translator = new Translator();
        try {
            moduleExp = CompileFile.read(object2.toString(), translator);
            SourceMessages sourceMessages = translator.getMessages();
            if (sourceMessages.seenErrors()) {
                throw new SyntaxException(sourceMessages);
            }
        }
        catch (SyntaxException syntaxException) {
            throw new GenericError("read error reading file:\n" + syntaxException.toString());
        }
        try {
            moduleExp.compileToArchive(object3.toString());
        }
        catch (IOException iOException) {
            throw new GenericError(iOException.toString());
        }
        return Interpreter.voidObject;
    }

    public static void compile_to_files(String string, String string2, String string3, String object2, SourceMessages sourceMessages) {
        Object object3;
        Object object4;
        if (object2 == null) {
            object4 = new File(string);
            object3 = ((File)object4).getName();
            if (((String)object3).endsWith(".scm")) {
                object3 = ((String)object3).substring(0, ((String)object3).length() - 4);
            } else if (((String)object3).endsWith(".el")) {
                object3 = ((String)object3).substring(0, ((String)object3).length() - 3);
            }
            object2 = object3;
            if (string3 != null) {
                object2 = String.valueOf(string3) + (String)object3;
            }
        }
        object4 = new Translator(Environment.user(), sourceMessages);
        object3 = CompileFile.read(string, (Translator)object4);
        if (sourceMessages.seenErrors()) {
            return;
        }
        try {
            ((ModuleExp)object3).compileToFiles((String)object2, string2, string3);
        }
        catch (IOException iOException) {
            throw new GenericError(iOException.toString());
        }
    }

    public static final ModuleExp read(InPort inPort, Translator translator) {
        ModuleExp moduleExp = new ModuleExp();
        moduleExp.setFile(inPort.getName());
        Vector vector = new Vector(20);
        SourceMessages sourceMessages = translator.getMessages();
        translator.push(moduleExp);
        try {
            Object object2;
            LispReader lispReader = (LispReader)Interpreter.getInterpreter().getLexer(inPort, sourceMessages);
            while ((object2 = lispReader.readObject()) != Sequence.eofValue && translator.scan_form(object2, vector, moduleExp)) {
            }
            if (inPort.peek() == 41) {
                lispReader.fatal("An unexpected close paren was read.");
            }
        }
        catch (SyntaxException syntaxException) {
            if (syntaxException.getMessages() != sourceMessages) {
                throw new GenericError("confussing syntax error: " + syntaxException);
            }
        }
        catch (IOException iOException) {
            throw new GenericError("I/O exception reading file: " + iOException.toString());
        }
        translator.finishModule(moduleExp, vector);
        return moduleExp;
    }

    public static final ModuleExp read(String string, Translator translator) {
        try {
            InPort inPort = InPort.openFile(string);
            ModuleExp moduleExp = CompileFile.read(inPort, translator);
            inPort.close();
            return moduleExp;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new GenericError("compile-file: file not found: " + string);
        }
        catch (IOException iOException) {
            throw new GenericError(string.toString());
        }
    }

    public static final Object readBody(InPort inPort, SourceMessages sourceMessages) {
        Object object2 = null;
        try {
            LispReader lispReader = (LispReader)Interpreter.getInterpreter().getLexer(inPort, sourceMessages);
            object2 = lispReader.readListBody();
            if (inPort.peek() == 41) {
                lispReader.fatal("An unexpected close paren was read.");
            }
        }
        catch (SyntaxException syntaxException) {
            if (syntaxException.getMessages() != sourceMessages) {
                throw new GenericError("confussing syntax error: " + syntaxException);
            }
        }
        catch (IOException iOException) {
            throw new GenericError("I/O exception reading file: " + iOException.toString());
        }
        return object2;
    }
}

