/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.mapping.OutPort;
import gnu.mapping.Printable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.util.Hashtable;

public class Char
implements Printable,
Externalizable {
    int value;
    static Char[] ascii;
    static Char temp;
    static Hashtable hashTable;
    static char[] charNameValues;
    static String[] charNames;

    public static boolean $Eq(char c, char c2) {
        return c == c2;
    }

    public static boolean $Gr$Eq(char c, char c2) {
        return c >= c2;
    }

    public static boolean $Gr(char c, char c2) {
        return c > c2;
    }

    public static boolean $Ls$Eq(char c, char c2) {
        return c <= c2;
    }

    public static boolean $Ls(char c, char c2) {
        return c < c2;
    }

    static {
        temp = new Char(0);
        ascii = new Char[128];
        int n = 128;
        while (--n >= 0) {
            Char.ascii[n] = new Char(n);
        }
        char[] cArray = new char[12];
        cArray[0] = 32;
        cArray[1] = 9;
        cArray[2] = 10;
        cArray[3] = 10;
        cArray[4] = 13;
        cArray[5] = 12;
        cArray[6] = 8;
        cArray[7] = 27;
        cArray[8] = 127;
        cArray[9] = 127;
        cArray[10] = 7;
        charNameValues = cArray;
        charNames = new String[]{"space", "tab", "newline", "linefeed", "return", "page", "backspace", "esc", "del", "rubout", "bel", "nul"};
    }

    public Char() {
    }

    private Char(char c) {
        this.value = c;
    }

    private Char(int n) {
        this.value = n;
    }

    public final char charValue() {
        return (char)this.value;
    }

    public boolean equals(Object object2) {
        return object2 != null && object2 instanceof Char && ((Char)object2).intValue() == this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public final int intValue() {
        return this.value;
    }

    public static Char make(int n) {
        Object v;
        if (n < 128) {
            return ascii[n];
        }
        Char.temp.value = n;
        if (hashTable == null) {
            hashTable = new Hashtable();
        }
        if ((v = hashTable.get(temp)) != null) {
            return (Char)v;
        }
        Char char_ = new Char(n);
        hashTable.put(char_, char_);
        return char_;
    }

    public static int nameToChar(String string) {
        int n = charNames.length;
        while (--n >= 0) {
            if (!charNames[n].equals(string)) continue;
            return charNameValues[n];
        }
        int n2 = string.length();
        if (n2 > 1 && string.charAt(0) == 'u') {
            int n3 = 0;
            int n4 = 1;
            while (true) {
                if (n4 == n2) {
                    return n3;
                }
                int n5 = Character.digit(string.charAt(n4), 16);
                if (n5 < 0) break;
                n3 = (n3 << 4) + n5;
                ++n4;
            }
        }
        return -1;
    }

    public void print(PrintWriter printWriter) {
        boolean bl = printWriter instanceof OutPort && ((OutPort)printWriter).printReadable;
        char c = this.charValue();
        if (bl) {
            printWriter.print(Char.toScmReadableString(c));
        } else {
            printWriter.print(c);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        char c;
        this.value = objectInput.readChar();
        if (this.value >= 55296 && this.value < 56319 && (c = objectInput.readChar()) >= '\udc00' && c <= '\udfff') {
            this.value = (this.value - 55296 << 10) + (c - 56320) + 65536;
        }
    }

    public Object readResolve() throws ObjectStreamException {
        return Char.make(this.value);
    }

    public static String toScmReadableString(int n) {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append("#\\");
        int n2 = 0;
        while (n2 < charNameValues.length) {
            if ((char)n == charNameValues[n2]) {
                stringBuffer.append(charNames[n2]);
                return stringBuffer.toString();
            }
            ++n2;
        }
        if (n < 8) {
            stringBuffer.append('0');
            stringBuffer.append(n);
        } else if (n < 32 || n > 127) {
            stringBuffer.append(Integer.toString(n, 8));
        } else {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[Char '");
        if (this.value >= 32 && this.value < 127) {
            stringBuffer.append((char)this.value);
        } else {
            stringBuffer.append('\\');
            stringBuffer.append(Integer.toOctalString(this.value));
        }
        stringBuffer.append("']");
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.value > 55296) {
            if (this.value > 65535) {
                objectOutput.writeChar((this.value - 65536 >> 10) + 55296);
                this.value = (this.value & 0x3FF) + 56320;
            } else if (this.value <= 56319) {
                objectOutput.writeChar(this.value);
                this.value = 0;
            }
        }
        objectOutput.writeChar(this.value);
    }
}

