/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

import gnu.kawa.util.Sequence;
import gnu.kawa.util.UniformVector;
import gnu.math.DFloNum;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;

public class F64Vector
extends UniformVector
implements Externalizable {
    double[] data;

    public F64Vector() {
    }

    public F64Vector(int n) {
        this.data = new double[n];
    }

    public F64Vector(int n, double d) {
        double[] dArray = new double[n];
        this.data = dArray;
        while (--n >= 0) {
            dArray[n] = d;
        }
    }

    public F64Vector(Sequence sequence) {
        this.data = new double[sequence.length()];
        this.copy(sequence);
    }

    public F64Vector(double[] dArray) {
        this.data = dArray;
    }

    public final double doubleValue(int n) {
        return this.data[n];
    }

    public final Object get(int n) {
        return DFloNum.make(this.data[n]);
    }

    public final String getTag() {
        return "f64";
    }

    public final int length() {
        return this.data.length;
    }

    public final void print(int n, PrintWriter printWriter) {
        printWriter.print(this.doubleValue(n));
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = objectInput.readDouble();
            ++n2;
        }
        this.data = dArray;
    }

    public final void set(int n, double d) {
        this.data[n] = d;
    }

    public final void setElementAt(Object object2, int n) {
        this.data[n] = ((Number)object2).doubleValue();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.data.length;
        objectOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            objectOutput.writeDouble(this.data[n2]);
            ++n2;
        }
    }
}

