/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.expr.Interpreter;
import gnu.expr.Keyword;
import gnu.expr.Special;
import gnu.kawa.lispexpr.LispReader;
import gnu.kawa.util.F32Vector;
import gnu.kawa.util.F64Vector;
import gnu.kawa.util.FString;
import gnu.kawa.util.FVector;
import gnu.kawa.util.LList;
import gnu.kawa.util.Pair;
import gnu.kawa.util.PairWithPosition;
import gnu.kawa.util.S16Vector;
import gnu.kawa.util.S32Vector;
import gnu.kawa.util.S64Vector;
import gnu.kawa.util.S8Vector;
import gnu.kawa.util.Sequence;
import gnu.kawa.util.U16Vector;
import gnu.kawa.util.U32Vector;
import gnu.kawa.util.U64Vector;
import gnu.kawa.util.U8Vector;
import gnu.kawa.util.UniformVector;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.UnboundSymbol;
import gnu.mapping.Values;
import gnu.math.Complex;
import gnu.math.DComplex;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Quantity;
import gnu.math.RatNum;
import gnu.math.RealNum;
import gnu.math.Unit;
import gnu.text.Char;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;
import java.util.Vector;

public class ScmRead
extends LispReader {
    public ScmRead(InPort inPort) {
        super(inPort);
    }

    public ScmRead(InPort inPort, SourceMessages sourceMessages) {
        super(inPort, sourceMessages);
    }

    public static char getReadCase() {
        int n;
        try {
            String string = Environment.lookup_global("symbol-read-case").toString();
            n = string.charAt(0);
            if (n != 80) {
                if (n == 117) {
                    n = 85;
                } else if (n == 100 || n == 108 || n == 76) {
                    n = 68;
                } else if (n == 105) {
                    n = 73;
                }
            }
        }
        catch (Exception exception) {
            n = 80;
        }
        return (char)n;
    }

    public Object lookupUnit(String string) {
        string = (String.valueOf(string) + "$unit").intern();
        try {
            return Environment.getCurrent().getChecked(string);
        }
        catch (UnboundSymbol unboundSymbol) {
            return string;
        }
    }

    protected Object makeNil() {
        return LList.Empty;
    }

    protected Object makePair(Object object2, int n, int n2) {
        PairWithPosition pairWithPosition = new PairWithPosition(this.port, object2, (Object)LList.Empty);
        pairWithPosition.setLine(n + 1, n2 + 1);
        pairWithPosition.setFile(this.port.getName());
        return pairWithPosition;
    }

    RealNum numError(String string) throws IOException {
        int n;
        this.error(string);
        while ((n = this.read()) >= 0) {
            if (!this.isDelimiter((char)n)) continue;
            this.unread(n);
            break;
        }
        return IntNum.zero();
    }

    public String readAlphaWord(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(20);
        while (n >= 0) {
            if (!Character.isLowerCase((char)n) && !Character.isUpperCase((char)n)) {
                this.unread(n);
                break;
            }
            stringBuffer.append((char)n);
            n = this.read();
        }
        return stringBuffer.toString();
    }

    protected Object readCharacter() throws IOException {
        int n;
        int n2 = n = this.read();
        if (n < 0) {
            this.error("unexpected EOF in character literal");
            n = 63;
        }
        if (Character.isLowerCase((char)n) || Character.isUpperCase((char)n)) {
            String string = this.readSymbol(n, 'D').toString();
            if ((n = Char.nameToChar(string)) < 0) {
                if (string.length() > 1) {
                    this.error("unknown character name: " + string);
                    n = 63;
                } else {
                    n = n2;
                }
            }
        } else {
            n2 = Character.digit((char)n, 8);
            if (n2 >= 0) {
                int n3 = this.peek();
                if ((n3 = Character.digit((char)n3, 8)) >= 0) {
                    n = 8 * n2 + n3;
                    while (true) {
                        this.skip();
                        n3 = this.peek();
                        n3 = Character.digit((char)n3, 8);
                        if (n3 >= 0) {
                            n = 8 * n + n3;
                            continue;
                        }
                        break;
                    }
                }
            } else if (n2 == 13) {
                n = 10;
                if (this.peek() == 10) {
                    this.skip();
                }
            }
        }
        return Char.make((char)n);
    }

    Complex readComplex(int n, int n2, char c) throws IOException {
        int n3;
        if (!(n != 43 && n != 45 || (n3 = this.peek()) != 105 && n3 != 73)) {
            this.skip();
            if (c == 'i') {
                return new DComplex(0.0, n == 43 ? 1 : -1);
            }
            return n == 43 ? Complex.imOne() : Complex.imMinusOne();
        }
        RealNum realNum = this.readReal(n, n2, c);
        n = this.read();
        switch (n) {
            case 73: 
            case 105: {
                n3 = this.peek();
                if (Character.isLowerCase((char)n3) || Character.isUpperCase((char)n3)) {
                    this.unread(n3);
                    return realNum;
                }
                return Complex.make(IntNum.zero(), realNum);
            }
            case 64: {
                RealNum realNum2 = this.readReal(this.read(), n2, c);
                if (realNum.isZero() && !realNum2.isExact()) {
                    return new DFloNum(0.0);
                }
                return Complex.polar(realNum, realNum2);
            }
            case 43: 
            case 45: {
                RealNum realNum3;
                n3 = this.peek();
                if (n3 == 105 || n3 == 73) {
                    realNum3 = n == 43 ? IntNum.one() : IntNum.minusOne();
                    this.read();
                } else {
                    realNum3 = this.readReal(n, n2, c);
                    n = this.read();
                    if (n != 105 && n != 73) {
                        this.error("no i in rectangular complex number");
                    }
                }
                return Complex.make(realNum, realNum3);
            }
        }
        if (n >= 0) {
            this.unread(n);
        }
        return realNum;
    }

    public Object readDefault(int n) throws IOException, SyntaxException {
        return this.readSymbol(n, ScmRead.getReadCase());
    }

    public Object readNumber(int n) throws IOException {
        return this.readNumber(this.read(), n);
    }

    public Object readNumber(int n, int n2) throws IOException {
        char c = ' ';
        int n3 = 0;
        while (n == 35) {
            n = this.read();
            switch (n) {
                case 101: 
                case 105: {
                    if (c != ' ') {
                        this.error("extra exactness specifier (#" + (char)n + ")");
                    }
                    c = (char)n;
                    break;
                }
                case 98: 
                case 100: 
                case 111: 
                case 120: {
                    if (n3 != 0) {
                        this.error("extra radix specifier (#" + (char)n + ")");
                    }
                    n3 = n == 120 ? 16 : (n == 100 ? 10 : (n == 111 ? 8 : 2));
                    break;
                }
                default: {
                    this.error("unrecognized #-construct in number");
                }
            }
            n = this.read();
        }
        if (n3 != 0) {
            n2 = n3;
        }
        Complex complex = this.readComplex(n, n2, c);
        Object object2 = null;
        if (n2 == 10) {
            n = this.peek();
            while (Character.isLowerCase((char)n) || Character.isUpperCase((char)n)) {
                int n4;
                this.skip();
                String string = this.readAlphaWord(n);
                Object object3 = this.lookupUnit(string);
                try {
                    if (this.peek() == 94) {
                        this.skip();
                        n = this.peek();
                        if (n != 45 && n != 43 && Character.digit((char)n, 10) < 0) {
                            this.error("missing exponent following unit " + string + '^');
                        }
                    }
                    n4 = this.readOptionalExponent();
                }
                catch (ClassCastException classCastException) {
                    this.error("unit exponent too large");
                    n4 = 1;
                }
                if (n4 != 1) {
                    object3 = object3 instanceof Unit ? Unit.pow((Unit)object3, n4) : LList.list3("expt", object3, IntNum.make(n4));
                }
                object2 = object2 == null ? object3 : (object3 instanceof Unit && object2 instanceof Unit ? Unit.mul((Unit)object2, (Unit)object3) : LList.list3("*", object2, object3));
                n = this.peek();
                if (n != 42) continue;
                this.skip();
                n = this.peek();
            }
        }
        if (object2 == null) {
            return complex;
        }
        if (object2 instanceof Unit) {
            return Quantity.make(complex, (Unit)object2);
        }
        return LList.list3("*", complex, object2);
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object readObject(int var1_1) throws IOException, SyntaxException {
        block28: while (true) {
            cfr_temp_0 = 0;
            block29: do {
                switch (cfr_temp_0 == 0 ? var1_1 : cfr_temp_0) {
                    case 59: {
                        ** break;
                    }
                    case 41: {
                        this.error("An unexpected close paren was read.");
                        cfr_temp_0 = 40;
                        continue block29;
                    }
                    case 34: {
                        var2_2 = ((InPort)this.port).readState;
                        ((InPort)this.port).readState = (char)34;
                        try {
                            var4_5 = this.readString();
                            var6_4 = null;
                            ((InPort)this.port).readState = var2_2;
                            return var4_5;
                        }
                        catch (Throwable var5_7) {
                            var6_4 = null;
                            ((InPort)this.port).readState = var2_2;
                            throw var5_7;
                        }
                    }
                    case 44: {
                        if (this.peek() == 64) {
                            this.skip();
                            var4_6 = "unquote-splicing";
                            return this.readQuote(var4_6);
                        }
                        var4_6 = "unquote";
                        return this.readQuote(var4_6);
                    }
                    case 35: {
                        var3_3 = this.read();
                        switch (var3_3) {
                            case 40: {
                                return this.readVector();
                            }
                            case 92: {
                                return this.readCharacter();
                            }
                            case 33: {
                                return this.readSpecial();
                            }
                            case 116: {
                                return Interpreter.trueObject;
                            }
                            case 102: {
                                var3_3 = this.peek();
                                if (Character.isDigit((char)var3_3) == false) return Interpreter.falseObject;
                                return this.readUniformVector('f');
                            }
                            case 115: 
                            case 117: {
                                return this.readUniformVector((char)var3_3);
                            }
                            case 98: 
                            case 100: 
                            case 101: 
                            case 105: 
                            case 111: 
                            case 120: {
                                this.unread(var3_3);
                                return this.readNumber(35, 10);
                            }
                            case 124: {
                                var2_2 = ((InPort)this.port).readState;
                                ((InPort)this.port).readState = (char)124;
                                try {
                                    this.readNestedComment();
                                    break;
                                }
                                finally {
                                    var6_4 = null;
                                    ((InPort)this.port).readState = var2_2;
                                }
                            }
                            default: {
                                this.error("An invalid #-construct was read.");
                                break;
                            }
                        }
                        ** GOTO lbl78
                    }
                    default: {
                        if (!Character.isWhitespace((char)var1_1)) {
                            if (Character.isDigit((char)var1_1) == false) return this.readDefault(var1_1);
                            return this.readNumber(var1_1, 10);
                        }
                        ** GOTO lbl78
                    }
                    case -1: {
                        return Sequence.eofValue;
                    }
lbl74:
                    // 1 sources

                    do {
                        if ((var1_1 = this.read()) >= 0) continue;
                        return LList.Empty;
                    } while (var1_1 != 10 && var1_1 != 13);
lbl78:
                    // 3 sources

                    var1_1 = this.read();
                    continue block28;
                    case 40: {
                        return this.readList(')');
                    }
                    case 91: {
                        return this.readList(']');
                    }
                    case 39: {
                        return this.readQuote("quote");
                    }
                    case 96: {
                        return this.readQuote("quasiquote");
                    }
                    case 43: 
                    case 45: 
                    case 46: 
                }
                break block28;
            } while (true);
            break;
        }
        var3_3 = this.peek();
        if (Character.isDigit((char)var3_3) != false) return this.readNumber(var1_1, 10);
        if (var1_1 == 46) return this.readSymbol(var1_1, ScmRead.getReadCase());
        if (var3_3 == 46) return this.readNumber(var1_1, 10);
        if (var3_3 == 105) return this.readNumber(var1_1, 10);
        if (var3_3 != 73) return this.readSymbol(var1_1, ScmRead.getReadCase());
        return this.readNumber(var1_1, 10);
    }

    public static Object readObject(InPort inPort) throws IOException, SyntaxException {
        return new ScmRead(inPort).readObject();
    }

    protected Object readQuote(String string) throws IOException, SyntaxException {
        return new Pair(string, new Pair(this.readObject(), LList.Empty));
    }

    public RealNum readReal(int n, int n2, char c) throws IOException {
        IntNum intNum;
        boolean bl;
        boolean bl2 = false;
        if (n == 43) {
            n = this.read();
        } else if (n == 45) {
            bl2 = true;
            n = this.read();
        }
        int n3 = this.port.pos;
        if (n >= 0) {
            --n3;
        }
        this.port.pos = n3;
        long l = Lexer.readDigitsInBuffer(this.port, n2);
        boolean bl3 = bl = this.port.pos > n3;
        if (bl && this.port.pos < this.port.limit && this.isDelimiter(this.port.buffer[this.port.pos])) {
            if (l >= 0L) {
                return IntNum.make(bl2 ? -l : l);
            }
            return IntNum.valueOf(this.port.buffer, n3, this.port.pos - n3, n2, bl2);
        }
        StringBuffer stringBuffer = new StringBuffer(20);
        if (bl2) {
            stringBuffer.append('-');
        }
        if (bl) {
            stringBuffer.append(this.port.buffer, n3, this.port.pos - n3);
        }
        int n4 = -1;
        int n5 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        block5: while (true) {
            if (Character.digit((char)(n = this.read()), n2) >= 0) {
                if (bl4) {
                    return this.numError("digit after '#' in number");
                }
                bl = true;
                stringBuffer.append((char)n);
                continue;
            }
            switch (n) {
                case 35: {
                    if (!bl4) {
                        if (n2 != 10) {
                            return this.numError("'#' in non-decimal number");
                        }
                        if (!bl) {
                            return this.numError("'#' with no preceeding digits in number");
                        }
                        bl4 = true;
                    }
                    stringBuffer.append('0');
                    bl = true;
                    continue block5;
                }
                case 46: {
                    if (n2 != 10) {
                        return this.numError("'.' in non-decimal number");
                    }
                    if (n4 >= 0) {
                        return this.numError("duplicate '.' in number");
                    }
                    n4 = stringBuffer.length();
                    stringBuffer.append('.');
                    continue block5;
                }
                case 68: 
                case 69: 
                case 70: 
                case 76: 
                case 83: 
                case 100: 
                case 101: 
                case 102: 
                case 108: 
                case 115: {
                    int n6;
                    if (n2 != 10 || (n6 = this.peek()) != 43 && n6 != 45 && Character.digit((char)n6, 10) < 0) break block5;
                    if (!bl) {
                        return this.numError("mantissa with no digits");
                    }
                    n5 = this.readOptionalExponent();
                    bl5 = true;
                    n = this.read();
                    break block5;
                }
            }
            break;
        }
        if (n == 47) {
            if (bl4 || bl5 || n4 != -1) {
                return this.numError("exponent, '#', or '.' in numerator");
            }
            if (!bl) {
                return this.numError("numerator with no digits");
            }
            IntNum intNum2 = IntNum.valueOf(stringBuffer.toString(), n2);
            stringBuffer.setLength(0);
            n = this.peek();
            if (Character.digit((char)n, n2) < 0) {
                return this.numError("denominator with no digits");
            }
            do {
                stringBuffer.append((char)n);
                this.skip();
            } while (Character.digit((char)(n = this.peek()), n2) >= 0);
            IntNum intNum3 = IntNum.valueOf(stringBuffer.toString(), n2);
            if (intNum3.isZero()) {
                if (c == 'i') {
                    return new DFloNum(intNum2.isZero() ? Double.NaN : (bl2 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY));
                }
                if (intNum2.isZero()) {
                    return this.numError("0/0 is undefined");
                }
            }
            if (c != 'i') {
                return RatNum.make(intNum2, intNum3);
            }
            return new DFloNum(intNum2.isZero() ? (bl2 ? -0.0 : 0.0) : RatNum.make(intNum2, intNum3).doubleValue());
        }
        if (n >= 0) {
            this.unread(n);
        }
        if (!bl) {
            return this.numError("real number (or component) with no digits");
        }
        if (c == 'i' || c == ' ' && (bl4 || bl5 || n4 != -1)) {
            if (n2 == 10) {
                if (n5 != 0) {
                    stringBuffer.append('e');
                    stringBuffer.append(n5);
                }
                return new DFloNum(stringBuffer.toString());
            }
            IntNum intNum4 = IntNum.valueOf(stringBuffer.toString(), n2);
            return new DFloNum(intNum4.isZero() ? (bl2 ? -0.0 : 0.0) : intNum4.doubleValue());
        }
        if (n4 == -1 && !bl5) {
            return IntNum.valueOf(stringBuffer.toString(), n2);
        }
        if (n4 == -1) {
            intNum = IntNum.valueOf(stringBuffer.toString());
        } else {
            String string = stringBuffer.toString();
            intNum = IntNum.valueOf(String.valueOf(string.substring(0, n4)) + string.substring(n4 + 1, string.length()));
            n4 = string.length() - (n4 + 1);
            if (n5 < 0 && Integer.MIN_VALUE + n4 >= n5) {
                return this.numError("exponent overflow");
            }
            n5 -= n4;
        }
        return intNum.isZero() ? intNum : (RealNum)intNum.mul(IntNum.power(IntNum.make(10), n5));
    }

    protected Object readSpecial() throws IOException {
        int n = this.read();
        if (n < 0) {
            this.error("unexpected EOF after #!");
            return null;
        }
        String string = this.readSymbol(n, 'D').toString();
        if (string.equals("optional")) {
            return Special.optional;
        }
        if (string.equals("rest")) {
            return Special.rest;
        }
        if (string.equals("key")) {
            return Special.key;
        }
        if (string.equals("eof")) {
            return Special.eof;
        }
        if (string.equals("void")) {
            return Values.empty;
        }
        if (string.equals("default")) {
            return Special.dfault;
        }
        if (string.equals("undefined")) {
            return Interpreter.undefinedObject;
        }
        if (string.equals("null")) {
            return null;
        }
        this.error("unknown named constant #!" + string);
        return null;
    }

    protected Object readString() throws IOException, SyntaxException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        int n = 34;
        do {
            int n2;
            if ((n2 = n) == 13) {
                n = this.read();
                if (n == 10) {
                    continue;
                }
            } else {
                n = this.port.pos < this.port.limit && n2 != 10 ? this.port.buffer[this.port.pos++] : this.read();
            }
            switch (n) {
                case 34: {
                    bl = false;
                    break;
                }
                case 13: {
                    stringBuffer.append('\n');
                    break;
                }
                case 92: {
                    n = this.readEscape();
                    if (n == -2) {
                        n = 10;
                        break;
                    }
                }
                default: {
                    if (n < 0) {
                        this.eofError("unexpected EOF in string literal");
                    }
                    stringBuffer.append((char)n);
                    break;
                }
            }
        } while (bl);
        return new FString(stringBuffer);
    }

    Object readSymbol() throws IOException {
        return this.readSymbol(this.read(), ScmRead.getReadCase());
    }

    Object readSymbol(int n, char c) throws IOException {
        int n2;
        char c2 = (char)n;
        if (n < 0 || this.isDelimiter(c2)) {
            this.error("no symbol start character");
        }
        StringBuffer stringBuffer = new StringBuffer(30);
        int n3 = 32;
        while (true) {
            if ((n2 = (int)n) == 92) {
                n = this.read();
                if (n < 0) {
                    this.error("EOF after \\ escape");
                    return "??";
                }
                n2 = (char)n;
                n3 = 32;
            } else {
                n3 = n2;
                if (c == 'U' || c == 'I' && Character.isLowerCase((char)n2)) {
                    n2 = Character.toUpperCase((char)n2);
                } else if (c == 'D' || c == 'I' && Character.isUpperCase((char)n2)) {
                    n2 = Character.toLowerCase((char)n2);
                }
            }
            stringBuffer.append((char)n2);
            n = this.peek();
            if (n < 0 || this.isDelimiter((char)n)) break;
            this.skip();
        }
        if (n3 == 58) {
            n2 = stringBuffer.length();
            if (n2 == 2 && stringBuffer.charAt(0) == ':') {
                return "::";
            }
            stringBuffer.setLength(n2 - 1);
            return Keyword.make(stringBuffer.toString().intern());
        }
        if (c2 == ':') {
            stringBuffer.reverse();
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.reverse();
            return Keyword.make(stringBuffer.toString().intern());
        }
        return stringBuffer.toString().intern();
    }

    UniformVector readUniformVector(char c) throws IOException, SyntaxException {
        int n = this.readOptionalExponent();
        if (n != 8 && n != 16 && n != 32 && n != 64 || c == 'f' && n < 32 || this.read() != 40) {
            this.error("invalid uniform vector syntax");
            return null;
        }
        Object object2 = this.readList(')');
        Object var4_4 = null;
        int n2 = LList.list_length(object2);
        if (n2 <= 0) {
            this.error("invalid elements in uniform vector syntax");
            return null;
        }
        Sequence sequence = (Sequence)object2;
        switch (c) {
            case 'f': {
                switch (n) {
                    case 32: {
                        return new F32Vector(sequence);
                    }
                    case 64: {
                        return new F64Vector(sequence);
                    }
                }
            }
            case 's': {
                switch (n) {
                    case 8: {
                        return new S8Vector(sequence);
                    }
                    case 16: {
                        return new S16Vector(sequence);
                    }
                    case 32: {
                        return new S32Vector(sequence);
                    }
                    case 64: {
                        return new S64Vector(sequence);
                    }
                }
            }
            case 'u': {
                switch (n) {
                    case 8: {
                        return new U8Vector(sequence);
                    }
                    case 16: {
                        return new U16Vector(sequence);
                    }
                    case 32: {
                        return new U32Vector(sequence);
                    }
                    case 64: {
                        return new U64Vector(sequence);
                    }
                }
            }
        }
        return null;
    }

    protected FVector readVector() throws IOException, SyntaxException {
        char c = ((InPort)this.port).readState;
        ((InPort)this.port).readState = (char)40;
        try {
            Vector<Object> vector = new Vector<Object>();
            while (true) {
                int n;
                if ((n = this.skipWhitespaceAndComments()) < 0) {
                    this.eofError("unexpected EOF in vector");
                }
                if (n == 41) break;
                vector.addElement(this.readObject(n));
            }
            Object[] objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
            FVector fVector = new FVector(objectArray);
            Object var4_6 = null;
            ((InPort)this.port).readState = c;
            return fVector;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            ((InPort)this.port).readState = c;
            throw throwable;
        }
    }

    protected void setCdr(Object object2, Object object3) {
        ((Pair)object2).cdr = object3;
    }
}

