/*
 * Decompiled with CFR 0.152.
 */
package kaffe.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import kaffe.io.ObjectStreamClassImpl;
import kaffe.util.IdentityHashtable;

public class ObjectOutputStreamImpl
extends DataOutputStream {
    private boolean buffering = false;
    private ObjectOutputStream parent;
    private int nextKey = 0x7E0000;
    private IdentityHashtable objectReferences = new IdentityHashtable();

    public void writeStreamHeader() throws IOException {
        this.writeShort(-21267);
        this.writeShort(5);
        this.drain();
    }

    public void drain() throws IOException {
        this.out.flush();
    }

    public boolean enableBuffering(boolean bl) throws IOException {
        boolean bl2 = this.buffering;
        if (bl != bl2) {
            this.drain();
            this.buffering = bl;
        }
        return bl2;
    }

    public void reset() throws IOException {
        this.flush();
        this.resetObjectReferences();
        this.writeByte(121);
    }

    public void writeObject(Object object) throws IOException {
        Class clazz;
        ObjectStreamClassImpl objectStreamClassImpl;
        boolean bl = this.enableBuffering(false);
        if (object == null) {
            this.writeByte(112);
            this.enableBuffering(bl);
            return;
        }
        if (object instanceof Class) {
            object = ObjectStreamClass.lookup((Class)object);
        }
        if ((objectStreamClassImpl = (ObjectStreamClassImpl)ObjectStreamClass.lookup(clazz = object.getClass())) == null) {
            throw new NotSerializableException();
        }
        Integer n = (Integer)this.objectReferences.get(object);
        if (n != null) {
            this.writeByte(113);
            this.writeInt(n);
        } else if (clazz.isArray()) {
            this.writeByte(117);
            this.writeObject(clazz);
            objectStreamClassImpl.putArray(object, this.parent, this);
        } else if (object instanceof String) {
            this.writeByte(116);
            this.writeUTF((String)object);
            this.makeObjectReference(object);
        } else if (object instanceof ObjectStreamClass) {
            while (object != null) {
                this.writeByte(114);
                objectStreamClassImpl.putClass(object, this.parent, this);
                object = ObjectStreamClass.lookup(((ObjectStreamClass)object).forClass().getSuperclass());
            }
            this.writeObject(null);
        } else {
            this.writeByte(115);
            this.writeObject(clazz);
            objectStreamClassImpl.putObject(object, this.parent, this);
        }
        this.enableBuffering(bl);
    }

    public void defaultWriteObject(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        boolean bl = this.enableBuffering(false);
        objectStreamClass.defaultWriteObject(object, this.parent);
        this.enableBuffering(bl);
    }

    public void makeObjectReference(Object object) {
        this.objectReferences.put(object, new Integer(this.nextKey));
        ++this.nextKey;
    }

    private void resetObjectReferences() {
        this.objectReferences = new IdentityHashtable();
    }

    static /* synthetic */ OutputStream access$0(ObjectOutputStreamImpl objectOutputStreamImpl) {
        return objectOutputStreamImpl.out;
    }

    public ObjectOutputStreamImpl(OutputStream outputStream, ObjectOutputStream objectOutputStream) {
        super(null);
        this.out = new Output(outputStream);
        this.parent = objectOutputStream;
    }

    class Output
    extends OutputStream {
        private OutputStream out;
        private ByteArrayOutputStream buffer = new ByteArrayOutputStream(255);

        public void write(int n) throws IOException {
            this.buffer.write(n);
        }

        public void flush() throws IOException {
            int n = this.buffer.size();
            if (n > 0) {
                if (ObjectOutputStreamImpl.this.buffering) {
                    if (n < 256) {
                        this.out.write(119);
                        this.out.write(n);
                    } else {
                        this.out.write(122);
                        this.out.write(n >> 24 & 0xFF);
                        this.out.write(n >> 16 & 0xFF);
                        this.out.write(n >> 8 & 0xFF);
                        this.out.write(n & 0xFF);
                    }
                }
                this.buffer.writeTo(this.out);
                this.buffer.reset();
            }
        }

        Output(OutputStream outputStream) {
            this.out = outputStream;
        }
    }
}

