/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.ClassAnalyzer;
import java.awt.ClassProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Defaults;
import java.awt.FocusEvt;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.NativeGraphics;
import java.awt.ShortcutHandler;
import java.awt.Toolkit;
import java.awt.WindowEvt;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.peer.ComponentPeer;
import kaffe.util.Ptr;

public class Window
extends Container {
    static Window dummy = new Window();
    private static final long serialVersionUID = 4497834738069338734L;
    Ptr nativeData;
    WindowListener wndListener;
    Frame owner;

    public void addNotify() {
        if (this.nativeData != null) {
            return;
        }
        if (this.owner != null && this.owner.nativeData == null) {
            this.owner.addNotify();
        }
        Toolkit.createNative(this);
        if (this.nativeData == null) {
            throw new AWTError("native create failed: " + this);
        }
        AWTEvent.registerSource(this, this.nativeData);
        super.addNotify();
    }

    public void addWindowListener(WindowListener windowListener) {
        this.wndListener = AWTEventMulticaster.add(this.wndListener, windowListener);
    }

    void cleanUpNative() {
        if (this.nativeData != null) {
            AWTEvent.unregisterSource(this, this.nativeData);
            this.nativeData = null;
        }
    }

    void createNative() {
        this.nativeData = Toolkit.wndCreateWindow(this.owner != null ? this.owner.nativeData : null, this.x, this.y, this.width, this.height, this.cursor.type, this.bgClr.nativeValue);
    }

    void destroyNative() {
        Toolkit.wndDestroyWindow(this.nativeData);
        this.cleanUpNative();
    }

    public void dispose() {
        this.flags &= 0xFFFFFFFE;
        if (this.nativeData != null) {
            this.removeNotify();
        }
    }

    public void freeResource() {
        this.dispose();
    }

    ClassProperties getClassProperties() {
        return ClassAnalyzer.analyzeAll(this.getClass(), true);
    }

    public Component getFocusOwner() {
        return this == AWTEvent.activeWindow ? AWTEvent.keyTgt : null;
    }

    public Graphics getGraphics() {
        if (this.nativeData != null) {
            int n = 0;
            int n2 = 0;
            if ((Toolkit.flags & 0x10) != 0) {
                n -= this.deco.x;
                n2 -= this.deco.y;
            }
            return NativeGraphics.getGraphics(this, this.nativeData, 0, n, n2, this.insets.left, this.insets.top, this.width - this.deco.width, this.height - (this.insets.top + this.insets.bottom), this.fgClr, this.bgClr, this.font, false);
        }
        return null;
    }

    Ptr getNativeData() {
        return this.nativeData;
    }

    public Container getParent() {
        return this.owner;
    }

    public ComponentPeer getPeer() {
        return (this.flags & 0x400) != 0 ? Toolkit.windowPeer : null;
    }

    public final String getWarningString() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && securityManager.checkTopLevelWindow(this)) {
            return null;
        }
        return System.getProperty("awt.appletWarning");
    }

    public void hide() {
        super.hide();
        if (this.nativeData != null) {
            Toolkit.wndSetVisible(this.nativeData, false);
        }
    }

    public boolean isShowing() {
        return (this.flags & 1) != 0;
    }

    public void pack() {
        if (this.nativeData == null) {
            this.addNotify();
        }
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    void process(FocusEvent focusEvent) {
        Component component;
        super.process(focusEvent);
        if (focusEvent.id == 1004 && this.nChildren > 0 && !Toolkit.eventQueue.hasPendingEvents(null, 1004) && (component = ShortcutHandler.focusNext(this)) != null && component != this) {
            AWTEvent.sendEvent(FocusEvt.getEvent(component, 1004, false), true);
        }
    }

    void process(WindowEvent windowEvent) {
        if (this.wndListener != null || (this.eventMask & 0x40) != 0) {
            this.processEvent(windowEvent);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (this.wndListener != null) {
            switch (windowEvent.id) {
                case 200: {
                    this.wndListener.windowOpened(windowEvent);
                    break;
                }
                case 202: {
                    this.wndListener.windowClosed(windowEvent);
                    break;
                }
            }
        }
    }

    public void removeNotify() {
        if ((this.flags & 0x400) != 0) {
            this.flags &= 0xFFFFFBFF;
            if (AWTEvent.activeWindow == this && AWTEvent.keyTgt != null) {
                AWTEvent.sendEvent(FocusEvt.getEvent(AWTEvent.keyTgt, 1005, false), true);
            }
            super.removeNotify();
            Toolkit.destroyNative(this);
            if (this.wndListener != null || (this.eventMask & 0x40) != 0) {
                AWTEvent.sendEvent(WindowEvt.getEvent(this, 202), false);
            }
        }
    }

    public void removeWindowListener(WindowListener windowListener) {
        this.wndListener = AWTEventMulticaster.remove(this.wndListener, windowListener);
    }

    public void requestFocus() {
        if (this.nativeData != null && (this.flags & 1) != 0) {
            Toolkit.wndRequestFocus(this.nativeData);
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (n == this.x && n2 == this.y && n3 == this.width && n4 == this.height) {
            return;
        }
        if (n3 != this.width || n4 != this.height) {
            this.invalidate();
        }
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        if (this.nativeData != null) {
            if ((Toolkit.flags & 0x10) != 0) {
                n += this.deco.x;
                n2 += this.deco.y;
                n3 -= this.deco.width;
                n4 -= this.deco.height;
            }
            Toolkit.wndSetBounds(this.nativeData, n, n2, n3, n4, (this.flags & 0x40) != 0);
        }
    }

    public void setBackground(Color color) {
        if (color != null) {
            this.bgClr = color;
            this.propagateBgClr(color);
            if (this.isShowing()) {
                this.repaint();
            }
        }
    }

    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
            this.propagateFont(font);
            if (this.isShowing()) {
                this.repaint();
            }
        }
    }

    public void setForeground(Color color) {
        if (color != null) {
            this.fgClr = color;
            this.propagateFgClr(color);
            if (this.isShowing()) {
                this.repaint();
            }
        }
    }

    void setNativeCursor(Cursor cursor) {
        if (this.nativeData != null) {
            Toolkit.wndSetCursor(this.nativeData, cursor.type);
        }
    }

    public void show() {
        if (this.nativeData == null) {
            this.addNotify();
        }
        this.validate();
        if ((this.flags & 1) != 0) {
            this.toFront();
        } else {
            super.show();
            Toolkit.wndSetVisible(this.nativeData, true);
            if ((this.flags & 0x200) == 0) {
                this.flags |= 0x200;
                if (this.wndListener != null || (this.eventMask & 0x40) != 0) {
                    AWTEvent.sendEvent(WindowEvt.getEvent(this, 200), false);
                }
            }
        }
    }

    public void toBack() {
        if (this.nativeData != null) {
            Toolkit.wndToBack(this.nativeData);
        }
    }

    public void toFront() {
        if (this.nativeData != null) {
            Toolkit.wndToFront(this.nativeData);
        }
    }

    Window() {
        this.flags = 14340;
        this.fgClr = Defaults.WndForeground;
        this.bgClr = Defaults.WndBackground;
        this.font = Defaults.WndFont;
        this.setLayout(new BorderLayout());
    }

    public Window(Frame frame) {
        this();
        this.owner = frame;
    }
}

